/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.DataFormat;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckSchemaVersionValidityRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CheckSchemaVersionValidityRequest> {
    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataFormat").getter(CheckSchemaVersionValidityRequest.getter(CheckSchemaVersionValidityRequest::dataFormatAsString)).setter(CheckSchemaVersionValidityRequest.setter(Builder::dataFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()}).build();
    private static final SdkField<String> SCHEMA_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaDefinition").getter(CheckSchemaVersionValidityRequest.getter(CheckSchemaVersionValidityRequest::schemaDefinition)).setter(CheckSchemaVersionValidityRequest.setter(Builder::schemaDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FORMAT_FIELD, SCHEMA_DEFINITION_FIELD));
    private final String dataFormat;
    private final String schemaDefinition;

    private CheckSchemaVersionValidityRequest(BuilderImpl builder) {
        super(builder);
        this.dataFormat = builder.dataFormat;
        this.schemaDefinition = builder.schemaDefinition;
    }

    public final DataFormat dataFormat() {
        return DataFormat.fromValue(this.dataFormat);
    }

    public final String dataFormatAsString() {
        return this.dataFormat;
    }

    public final String schemaDefinition() {
        return this.schemaDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaDefinition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckSchemaVersionValidityRequest)) {
            return false;
        }
        CheckSchemaVersionValidityRequest other = (CheckSchemaVersionValidityRequest)((Object)obj);
        return Objects.equals(this.dataFormatAsString(), other.dataFormatAsString()) && Objects.equals(this.schemaDefinition(), other.schemaDefinition());
    }

    public final String toString() {
        return ToString.builder((String)"CheckSchemaVersionValidityRequest").add("DataFormat", (Object)this.dataFormatAsString()).add("SchemaDefinition", (Object)this.schemaDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataFormat": {
                return Optional.ofNullable(clazz.cast(this.dataFormatAsString()));
            }
            case "SchemaDefinition": {
                return Optional.ofNullable(clazz.cast(this.schemaDefinition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckSchemaVersionValidityRequest, T> g) {
        return obj -> g.apply((CheckSchemaVersionValidityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String dataFormat;
        private String schemaDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckSchemaVersionValidityRequest model) {
            super(model);
            this.dataFormat(model.dataFormat);
            this.schemaDefinition(model.schemaDefinition);
        }

        public final String getDataFormat() {
            return this.dataFormat;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        @Override
        @Transient
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final String getSchemaDefinition() {
            return this.schemaDefinition;
        }

        public final void setSchemaDefinition(String schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
        }

        @Override
        @Transient
        public final Builder schemaDefinition(String schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckSchemaVersionValidityRequest build() {
            return new CheckSchemaVersionValidityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CheckSchemaVersionValidityRequest> {
        public Builder dataFormat(String var1);

        public Builder dataFormat(DataFormat var1);

        public Builder schemaDefinition(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

