/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ClassifierNameListCopier;
import software.amazon.awssdk.services.glue.model.CrawlerTargets;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.LakeFormationConfiguration;
import software.amazon.awssdk.services.glue.model.LineageConfiguration;
import software.amazon.awssdk.services.glue.model.RecrawlPolicy;
import software.amazon.awssdk.services.glue.model.SchemaChangePolicy;
import software.amazon.awssdk.services.glue.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCrawlerRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateCrawlerRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateCrawlerRequest.getter(CreateCrawlerRequest::name)).setter(CreateCrawlerRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(CreateCrawlerRequest.getter(CreateCrawlerRequest::role)).setter(CreateCrawlerRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(CreateCrawlerRequest.getter(CreateCrawlerRequest::databaseName)).setter(CreateCrawlerRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateCrawlerRequest.getter(CreateCrawlerRequest::description)).setter(CreateCrawlerRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<CrawlerTargets> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Targets").getter(CreateCrawlerRequest.getter(CreateCrawlerRequest::targets)).setter(CreateCrawlerRequest.setter(Builder::targets)).constructor(CrawlerTargets::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build()}).build();
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schedule").getter(CreateCrawlerRequest.getter(CreateCrawlerRequest::schedule)).setter(CreateCrawlerRequest.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<List<String>> CLASSIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Classifiers").getter(CreateCrawlerRequest.getter(CreateCrawlerRequest::classifiers)).setter(CreateCrawlerRequest.setter(Builder::classifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TABLE_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TablePrefix").getter(CreateCrawlerRequest.getter(CreateCrawlerRequest::tablePrefix)).setter(CreateCrawlerRequest.setter(Builder::tablePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablePrefix").build()}).build();
    private static final SdkField<SchemaChangePolicy> SCHEMA_CHANGE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaChangePolicy").getter(CreateCrawlerRequest.getter(CreateCrawlerRequest::schemaChangePolicy)).setter(CreateCrawlerRequest.setter(Builder::schemaChangePolicy)).constructor(SchemaChangePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaChangePolicy").build()}).build();
    private static final SdkField<RecrawlPolicy> RECRAWL_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecrawlPolicy").getter(CreateCrawlerRequest.getter(CreateCrawlerRequest::recrawlPolicy)).setter(CreateCrawlerRequest.setter(Builder::recrawlPolicy)).constructor(RecrawlPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecrawlPolicy").build()}).build();
    private static final SdkField<LineageConfiguration> LINEAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LineageConfiguration").getter(CreateCrawlerRequest.getter(CreateCrawlerRequest::lineageConfiguration)).setter(CreateCrawlerRequest.setter(Builder::lineageConfiguration)).constructor(LineageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineageConfiguration").build()}).build();
    private static final SdkField<LakeFormationConfiguration> LAKE_FORMATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LakeFormationConfiguration").getter(CreateCrawlerRequest.getter(CreateCrawlerRequest::lakeFormationConfiguration)).setter(CreateCrawlerRequest.setter(Builder::lakeFormationConfiguration)).constructor(LakeFormationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LakeFormationConfiguration").build()}).build();
    private static final SdkField<String> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Configuration").getter(CreateCrawlerRequest.getter(CreateCrawlerRequest::configuration)).setter(CreateCrawlerRequest.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<String> CRAWLER_SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CrawlerSecurityConfiguration").getter(CreateCrawlerRequest.getter(CreateCrawlerRequest::crawlerSecurityConfiguration)).setter(CreateCrawlerRequest.setter(Builder::crawlerSecurityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerSecurityConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateCrawlerRequest.getter(CreateCrawlerRequest::tags)).setter(CreateCrawlerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ROLE_FIELD, DATABASE_NAME_FIELD, DESCRIPTION_FIELD, TARGETS_FIELD, SCHEDULE_FIELD, CLASSIFIERS_FIELD, TABLE_PREFIX_FIELD, SCHEMA_CHANGE_POLICY_FIELD, RECRAWL_POLICY_FIELD, LINEAGE_CONFIGURATION_FIELD, LAKE_FORMATION_CONFIGURATION_FIELD, CONFIGURATION_FIELD, CRAWLER_SECURITY_CONFIGURATION_FIELD, TAGS_FIELD));
    private final String name;
    private final String role;
    private final String databaseName;
    private final String description;
    private final CrawlerTargets targets;
    private final String schedule;
    private final List<String> classifiers;
    private final String tablePrefix;
    private final SchemaChangePolicy schemaChangePolicy;
    private final RecrawlPolicy recrawlPolicy;
    private final LineageConfiguration lineageConfiguration;
    private final LakeFormationConfiguration lakeFormationConfiguration;
    private final String configuration;
    private final String crawlerSecurityConfiguration;
    private final Map<String, String> tags;

    private CreateCrawlerRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.role = builder.role;
        this.databaseName = builder.databaseName;
        this.description = builder.description;
        this.targets = builder.targets;
        this.schedule = builder.schedule;
        this.classifiers = builder.classifiers;
        this.tablePrefix = builder.tablePrefix;
        this.schemaChangePolicy = builder.schemaChangePolicy;
        this.recrawlPolicy = builder.recrawlPolicy;
        this.lineageConfiguration = builder.lineageConfiguration;
        this.lakeFormationConfiguration = builder.lakeFormationConfiguration;
        this.configuration = builder.configuration;
        this.crawlerSecurityConfiguration = builder.crawlerSecurityConfiguration;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String role() {
        return this.role;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String description() {
        return this.description;
    }

    public final CrawlerTargets targets() {
        return this.targets;
    }

    public final String schedule() {
        return this.schedule;
    }

    public final boolean hasClassifiers() {
        return this.classifiers != null && !(this.classifiers instanceof SdkAutoConstructList);
    }

    public final List<String> classifiers() {
        return this.classifiers;
    }

    public final String tablePrefix() {
        return this.tablePrefix;
    }

    public final SchemaChangePolicy schemaChangePolicy() {
        return this.schemaChangePolicy;
    }

    public final RecrawlPolicy recrawlPolicy() {
        return this.recrawlPolicy;
    }

    public final LineageConfiguration lineageConfiguration() {
        return this.lineageConfiguration;
    }

    public final LakeFormationConfiguration lakeFormationConfiguration() {
        return this.lakeFormationConfiguration;
    }

    public final String configuration() {
        return this.configuration;
    }

    public final String crawlerSecurityConfiguration() {
        return this.crawlerSecurityConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClassifiers() ? this.classifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tablePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaChangePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.recrawlPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lakeFormationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlerSecurityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCrawlerRequest)) {
            return false;
        }
        CreateCrawlerRequest other = (CreateCrawlerRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.schedule(), other.schedule()) && this.hasClassifiers() == other.hasClassifiers() && Objects.equals(this.classifiers(), other.classifiers()) && Objects.equals(this.tablePrefix(), other.tablePrefix()) && Objects.equals(this.schemaChangePolicy(), other.schemaChangePolicy()) && Objects.equals(this.recrawlPolicy(), other.recrawlPolicy()) && Objects.equals(this.lineageConfiguration(), other.lineageConfiguration()) && Objects.equals(this.lakeFormationConfiguration(), other.lakeFormationConfiguration()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.crawlerSecurityConfiguration(), other.crawlerSecurityConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCrawlerRequest").add("Name", (Object)this.name()).add("Role", (Object)this.role()).add("DatabaseName", (Object)this.databaseName()).add("Description", (Object)this.description()).add("Targets", (Object)this.targets()).add("Schedule", (Object)this.schedule()).add("Classifiers", this.hasClassifiers() ? this.classifiers() : null).add("TablePrefix", (Object)this.tablePrefix()).add("SchemaChangePolicy", (Object)this.schemaChangePolicy()).add("RecrawlPolicy", (Object)this.recrawlPolicy()).add("LineageConfiguration", (Object)this.lineageConfiguration()).add("LakeFormationConfiguration", (Object)this.lakeFormationConfiguration()).add("Configuration", (Object)this.configuration()).add("CrawlerSecurityConfiguration", (Object)this.crawlerSecurityConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "Classifiers": {
                return Optional.ofNullable(clazz.cast(this.classifiers()));
            }
            case "TablePrefix": {
                return Optional.ofNullable(clazz.cast(this.tablePrefix()));
            }
            case "SchemaChangePolicy": {
                return Optional.ofNullable(clazz.cast(this.schemaChangePolicy()));
            }
            case "RecrawlPolicy": {
                return Optional.ofNullable(clazz.cast(this.recrawlPolicy()));
            }
            case "LineageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lineageConfiguration()));
            }
            case "LakeFormationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lakeFormationConfiguration()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "CrawlerSecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.crawlerSecurityConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCrawlerRequest, T> g) {
        return obj -> g.apply((CreateCrawlerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String name;
        private String role;
        private String databaseName;
        private String description;
        private CrawlerTargets targets;
        private String schedule;
        private List<String> classifiers = DefaultSdkAutoConstructList.getInstance();
        private String tablePrefix;
        private SchemaChangePolicy schemaChangePolicy;
        private RecrawlPolicy recrawlPolicy;
        private LineageConfiguration lineageConfiguration;
        private LakeFormationConfiguration lakeFormationConfiguration;
        private String configuration;
        private String crawlerSecurityConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCrawlerRequest model) {
            super(model);
            this.name(model.name);
            this.role(model.role);
            this.databaseName(model.databaseName);
            this.description(model.description);
            this.targets(model.targets);
            this.schedule(model.schedule);
            this.classifiers(model.classifiers);
            this.tablePrefix(model.tablePrefix);
            this.schemaChangePolicy(model.schemaChangePolicy);
            this.recrawlPolicy(model.recrawlPolicy);
            this.lineageConfiguration(model.lineageConfiguration);
            this.lakeFormationConfiguration(model.lakeFormationConfiguration);
            this.configuration(model.configuration);
            this.crawlerSecurityConfiguration(model.crawlerSecurityConfiguration);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        @Transient
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        @Transient
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final CrawlerTargets.Builder getTargets() {
            return this.targets != null ? this.targets.toBuilder() : null;
        }

        public final void setTargets(CrawlerTargets.BuilderImpl targets) {
            this.targets = targets != null ? targets.build() : null;
        }

        @Override
        @Transient
        public final Builder targets(CrawlerTargets targets) {
            this.targets = targets;
            return this;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        @Transient
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final Collection<String> getClassifiers() {
            if (this.classifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.classifiers;
        }

        public final void setClassifiers(Collection<String> classifiers) {
            this.classifiers = ClassifierNameListCopier.copy(classifiers);
        }

        @Override
        @Transient
        public final Builder classifiers(Collection<String> classifiers) {
            this.classifiers = ClassifierNameListCopier.copy(classifiers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder classifiers(String ... classifiers) {
            this.classifiers(Arrays.asList(classifiers));
            return this;
        }

        public final String getTablePrefix() {
            return this.tablePrefix;
        }

        public final void setTablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
        }

        @Override
        @Transient
        public final Builder tablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
            return this;
        }

        public final SchemaChangePolicy.Builder getSchemaChangePolicy() {
            return this.schemaChangePolicy != null ? this.schemaChangePolicy.toBuilder() : null;
        }

        public final void setSchemaChangePolicy(SchemaChangePolicy.BuilderImpl schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy != null ? schemaChangePolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder schemaChangePolicy(SchemaChangePolicy schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy;
            return this;
        }

        public final RecrawlPolicy.Builder getRecrawlPolicy() {
            return this.recrawlPolicy != null ? this.recrawlPolicy.toBuilder() : null;
        }

        public final void setRecrawlPolicy(RecrawlPolicy.BuilderImpl recrawlPolicy) {
            this.recrawlPolicy = recrawlPolicy != null ? recrawlPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder recrawlPolicy(RecrawlPolicy recrawlPolicy) {
            this.recrawlPolicy = recrawlPolicy;
            return this;
        }

        public final LineageConfiguration.Builder getLineageConfiguration() {
            return this.lineageConfiguration != null ? this.lineageConfiguration.toBuilder() : null;
        }

        public final void setLineageConfiguration(LineageConfiguration.BuilderImpl lineageConfiguration) {
            this.lineageConfiguration = lineageConfiguration != null ? lineageConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder lineageConfiguration(LineageConfiguration lineageConfiguration) {
            this.lineageConfiguration = lineageConfiguration;
            return this;
        }

        public final LakeFormationConfiguration.Builder getLakeFormationConfiguration() {
            return this.lakeFormationConfiguration != null ? this.lakeFormationConfiguration.toBuilder() : null;
        }

        public final void setLakeFormationConfiguration(LakeFormationConfiguration.BuilderImpl lakeFormationConfiguration) {
            this.lakeFormationConfiguration = lakeFormationConfiguration != null ? lakeFormationConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder lakeFormationConfiguration(LakeFormationConfiguration lakeFormationConfiguration) {
            this.lakeFormationConfiguration = lakeFormationConfiguration;
            return this;
        }

        public final String getConfiguration() {
            return this.configuration;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        @Override
        @Transient
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getCrawlerSecurityConfiguration() {
            return this.crawlerSecurityConfiguration;
        }

        public final void setCrawlerSecurityConfiguration(String crawlerSecurityConfiguration) {
            this.crawlerSecurityConfiguration = crawlerSecurityConfiguration;
        }

        @Override
        @Transient
        public final Builder crawlerSecurityConfiguration(String crawlerSecurityConfiguration) {
            this.crawlerSecurityConfiguration = crawlerSecurityConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCrawlerRequest build() {
            return new CreateCrawlerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCrawlerRequest> {
        public Builder name(String var1);

        public Builder role(String var1);

        public Builder databaseName(String var1);

        public Builder description(String var1);

        public Builder targets(CrawlerTargets var1);

        default public Builder targets(Consumer<CrawlerTargets.Builder> targets) {
            return this.targets((CrawlerTargets)((CrawlerTargets.Builder)CrawlerTargets.builder().applyMutation(targets)).build());
        }

        public Builder schedule(String var1);

        public Builder classifiers(Collection<String> var1);

        public Builder classifiers(String ... var1);

        public Builder tablePrefix(String var1);

        public Builder schemaChangePolicy(SchemaChangePolicy var1);

        default public Builder schemaChangePolicy(Consumer<SchemaChangePolicy.Builder> schemaChangePolicy) {
            return this.schemaChangePolicy((SchemaChangePolicy)((SchemaChangePolicy.Builder)SchemaChangePolicy.builder().applyMutation(schemaChangePolicy)).build());
        }

        public Builder recrawlPolicy(RecrawlPolicy var1);

        default public Builder recrawlPolicy(Consumer<RecrawlPolicy.Builder> recrawlPolicy) {
            return this.recrawlPolicy((RecrawlPolicy)((RecrawlPolicy.Builder)RecrawlPolicy.builder().applyMutation(recrawlPolicy)).build());
        }

        public Builder lineageConfiguration(LineageConfiguration var1);

        default public Builder lineageConfiguration(Consumer<LineageConfiguration.Builder> lineageConfiguration) {
            return this.lineageConfiguration((LineageConfiguration)((LineageConfiguration.Builder)LineageConfiguration.builder().applyMutation(lineageConfiguration)).build());
        }

        public Builder lakeFormationConfiguration(LakeFormationConfiguration var1);

        default public Builder lakeFormationConfiguration(Consumer<LakeFormationConfiguration.Builder> lakeFormationConfiguration) {
            return this.lakeFormationConfiguration((LakeFormationConfiguration)((LakeFormationConfiguration.Builder)LakeFormationConfiguration.builder().applyMutation(lakeFormationConfiguration)).build());
        }

        public Builder configuration(String var1);

        public Builder crawlerSecurityConfiguration(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

