/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DoubleColumnStatisticsData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DoubleColumnStatisticsData> {
    private static final SdkField<Double> MINIMUM_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinimumValue").getter(DoubleColumnStatisticsData.getter(DoubleColumnStatisticsData::minimumValue)).setter(DoubleColumnStatisticsData.setter(Builder::minimumValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumValue").build()}).build();
    private static final SdkField<Double> MAXIMUM_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaximumValue").getter(DoubleColumnStatisticsData.getter(DoubleColumnStatisticsData::maximumValue)).setter(DoubleColumnStatisticsData.setter(Builder::maximumValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumValue").build()}).build();
    private static final SdkField<Long> NUMBER_OF_NULLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfNulls").getter(DoubleColumnStatisticsData.getter(DoubleColumnStatisticsData::numberOfNulls)).setter(DoubleColumnStatisticsData.setter(Builder::numberOfNulls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNulls").build()}).build();
    private static final SdkField<Long> NUMBER_OF_DISTINCT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfDistinctValues").getter(DoubleColumnStatisticsData.getter(DoubleColumnStatisticsData::numberOfDistinctValues)).setter(DoubleColumnStatisticsData.setter(Builder::numberOfDistinctValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDistinctValues").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_VALUE_FIELD, MAXIMUM_VALUE_FIELD, NUMBER_OF_NULLS_FIELD, NUMBER_OF_DISTINCT_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double minimumValue;
    private final Double maximumValue;
    private final Long numberOfNulls;
    private final Long numberOfDistinctValues;

    private DoubleColumnStatisticsData(BuilderImpl builder) {
        this.minimumValue = builder.minimumValue;
        this.maximumValue = builder.maximumValue;
        this.numberOfNulls = builder.numberOfNulls;
        this.numberOfDistinctValues = builder.numberOfDistinctValues;
    }

    public final Double minimumValue() {
        return this.minimumValue;
    }

    public final Double maximumValue() {
        return this.maximumValue;
    }

    public final Long numberOfNulls() {
        return this.numberOfNulls;
    }

    public final Long numberOfDistinctValues() {
        return this.numberOfDistinctValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNulls());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDistinctValues());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DoubleColumnStatisticsData)) {
            return false;
        }
        DoubleColumnStatisticsData other = (DoubleColumnStatisticsData)obj;
        return Objects.equals(this.minimumValue(), other.minimumValue()) && Objects.equals(this.maximumValue(), other.maximumValue()) && Objects.equals(this.numberOfNulls(), other.numberOfNulls()) && Objects.equals(this.numberOfDistinctValues(), other.numberOfDistinctValues());
    }

    public final String toString() {
        return ToString.builder((String)"DoubleColumnStatisticsData").add("MinimumValue", (Object)this.minimumValue()).add("MaximumValue", (Object)this.maximumValue()).add("NumberOfNulls", (Object)this.numberOfNulls()).add("NumberOfDistinctValues", (Object)this.numberOfDistinctValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinimumValue": {
                return Optional.ofNullable(clazz.cast(this.minimumValue()));
            }
            case "MaximumValue": {
                return Optional.ofNullable(clazz.cast(this.maximumValue()));
            }
            case "NumberOfNulls": {
                return Optional.ofNullable(clazz.cast(this.numberOfNulls()));
            }
            case "NumberOfDistinctValues": {
                return Optional.ofNullable(clazz.cast(this.numberOfDistinctValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DoubleColumnStatisticsData, T> g) {
        return obj -> g.apply((DoubleColumnStatisticsData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double minimumValue;
        private Double maximumValue;
        private Long numberOfNulls;
        private Long numberOfDistinctValues;

        private BuilderImpl() {
        }

        private BuilderImpl(DoubleColumnStatisticsData model) {
            this.minimumValue(model.minimumValue);
            this.maximumValue(model.maximumValue);
            this.numberOfNulls(model.numberOfNulls);
            this.numberOfDistinctValues(model.numberOfDistinctValues);
        }

        public final Double getMinimumValue() {
            return this.minimumValue;
        }

        public final void setMinimumValue(Double minimumValue) {
            this.minimumValue = minimumValue;
        }

        @Override
        @Transient
        public final Builder minimumValue(Double minimumValue) {
            this.minimumValue = minimumValue;
            return this;
        }

        public final Double getMaximumValue() {
            return this.maximumValue;
        }

        public final void setMaximumValue(Double maximumValue) {
            this.maximumValue = maximumValue;
        }

        @Override
        @Transient
        public final Builder maximumValue(Double maximumValue) {
            this.maximumValue = maximumValue;
            return this;
        }

        public final Long getNumberOfNulls() {
            return this.numberOfNulls;
        }

        public final void setNumberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
        }

        @Override
        @Transient
        public final Builder numberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
            return this;
        }

        public final Long getNumberOfDistinctValues() {
            return this.numberOfDistinctValues;
        }

        public final void setNumberOfDistinctValues(Long numberOfDistinctValues) {
            this.numberOfDistinctValues = numberOfDistinctValues;
        }

        @Override
        @Transient
        public final Builder numberOfDistinctValues(Long numberOfDistinctValues) {
            this.numberOfDistinctValues = numberOfDistinctValues;
            return this;
        }

        public DoubleColumnStatisticsData build() {
            return new DoubleColumnStatisticsData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DoubleColumnStatisticsData> {
        public Builder minimumValue(Double var1);

        public Builder maximumValue(Double var1);

        public Builder numberOfNulls(Long var1);

        public Builder numberOfDistinctValues(Long var1);
    }
}

