/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.BackfillError;
import software.amazon.awssdk.services.glue.model.BackfillErrorsCopier;
import software.amazon.awssdk.services.glue.model.KeySchemaElement;
import software.amazon.awssdk.services.glue.model.KeySchemaElementListCopier;
import software.amazon.awssdk.services.glue.model.PartitionIndexStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PartitionIndexDescriptor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PartitionIndexDescriptor> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(PartitionIndexDescriptor.getter(PartitionIndexDescriptor::indexName)).setter(PartitionIndexDescriptor.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<List<KeySchemaElement>> KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Keys").getter(PartitionIndexDescriptor.getter(PartitionIndexDescriptor::keys)).setter(PartitionIndexDescriptor.setter(Builder::keys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeySchemaElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexStatus").getter(PartitionIndexDescriptor.getter(PartitionIndexDescriptor::indexStatusAsString)).setter(PartitionIndexDescriptor.setter(Builder::indexStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatus").build()}).build();
    private static final SdkField<List<BackfillError>> BACKFILL_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BackfillErrors").getter(PartitionIndexDescriptor.getter(PartitionIndexDescriptor::backfillErrors)).setter(PartitionIndexDescriptor.setter(Builder::backfillErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackfillErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BackfillError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD, KEYS_FIELD, INDEX_STATUS_FIELD, BACKFILL_ERRORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String indexName;
    private final List<KeySchemaElement> keys;
    private final String indexStatus;
    private final List<BackfillError> backfillErrors;

    private PartitionIndexDescriptor(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.keys = builder.keys;
        this.indexStatus = builder.indexStatus;
        this.backfillErrors = builder.backfillErrors;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final boolean hasKeys() {
        return this.keys != null && !(this.keys instanceof SdkAutoConstructList);
    }

    public final List<KeySchemaElement> keys() {
        return this.keys;
    }

    public final PartitionIndexStatus indexStatus() {
        return PartitionIndexStatus.fromValue(this.indexStatus);
    }

    public final String indexStatusAsString() {
        return this.indexStatus;
    }

    public final boolean hasBackfillErrors() {
        return this.backfillErrors != null && !(this.backfillErrors instanceof SdkAutoConstructList);
    }

    public final List<BackfillError> backfillErrors() {
        return this.backfillErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeys() ? this.keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackfillErrors() ? this.backfillErrors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartitionIndexDescriptor)) {
            return false;
        }
        PartitionIndexDescriptor other = (PartitionIndexDescriptor)obj;
        return Objects.equals(this.indexName(), other.indexName()) && this.hasKeys() == other.hasKeys() && Objects.equals(this.keys(), other.keys()) && Objects.equals(this.indexStatusAsString(), other.indexStatusAsString()) && this.hasBackfillErrors() == other.hasBackfillErrors() && Objects.equals(this.backfillErrors(), other.backfillErrors());
    }

    public final String toString() {
        return ToString.builder((String)"PartitionIndexDescriptor").add("IndexName", (Object)this.indexName()).add("Keys", this.hasKeys() ? this.keys() : null).add("IndexStatus", (Object)this.indexStatusAsString()).add("BackfillErrors", this.hasBackfillErrors() ? this.backfillErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "Keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
            case "IndexStatus": {
                return Optional.ofNullable(clazz.cast(this.indexStatusAsString()));
            }
            case "BackfillErrors": {
                return Optional.ofNullable(clazz.cast(this.backfillErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PartitionIndexDescriptor, T> g) {
        return obj -> g.apply((PartitionIndexDescriptor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String indexName;
        private List<KeySchemaElement> keys = DefaultSdkAutoConstructList.getInstance();
        private String indexStatus;
        private List<BackfillError> backfillErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PartitionIndexDescriptor model) {
            this.indexName(model.indexName);
            this.keys(model.keys);
            this.indexStatus(model.indexStatus);
            this.backfillErrors(model.backfillErrors);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        @Transient
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final List<KeySchemaElement.Builder> getKeys() {
            List<KeySchemaElement.Builder> result = KeySchemaElementListCopier.copyToBuilder(this.keys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeys(Collection<KeySchemaElement.BuilderImpl> keys) {
            this.keys = KeySchemaElementListCopier.copyFromBuilder(keys);
        }

        @Override
        @Transient
        public final Builder keys(Collection<KeySchemaElement> keys) {
            this.keys = KeySchemaElementListCopier.copy(keys);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder keys(KeySchemaElement ... keys) {
            this.keys(Arrays.asList(keys));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder keys(Consumer<KeySchemaElement.Builder> ... keys) {
            this.keys(Stream.of(keys).map(c -> (KeySchemaElement)((KeySchemaElement.Builder)KeySchemaElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIndexStatus() {
            return this.indexStatus;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        @Override
        @Transient
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder indexStatus(PartitionIndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        public final List<BackfillError.Builder> getBackfillErrors() {
            List<BackfillError.Builder> result = BackfillErrorsCopier.copyToBuilder(this.backfillErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackfillErrors(Collection<BackfillError.BuilderImpl> backfillErrors) {
            this.backfillErrors = BackfillErrorsCopier.copyFromBuilder(backfillErrors);
        }

        @Override
        @Transient
        public final Builder backfillErrors(Collection<BackfillError> backfillErrors) {
            this.backfillErrors = BackfillErrorsCopier.copy(backfillErrors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder backfillErrors(BackfillError ... backfillErrors) {
            this.backfillErrors(Arrays.asList(backfillErrors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder backfillErrors(Consumer<BackfillError.Builder> ... backfillErrors) {
            this.backfillErrors(Stream.of(backfillErrors).map(c -> (BackfillError)((BackfillError.Builder)BackfillError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PartitionIndexDescriptor build() {
            return new PartitionIndexDescriptor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PartitionIndexDescriptor> {
        public Builder indexName(String var1);

        public Builder keys(Collection<KeySchemaElement> var1);

        public Builder keys(KeySchemaElement ... var1);

        public Builder keys(Consumer<KeySchemaElement.Builder> ... var1);

        public Builder indexStatus(String var1);

        public Builder indexStatus(PartitionIndexStatus var1);

        public Builder backfillErrors(Collection<BackfillError> var1);

        public Builder backfillErrors(BackfillError ... var1);

        public Builder backfillErrors(Consumer<BackfillError.Builder> ... var1);
    }
}

