/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.OpenTableFormatInput;
import software.amazon.awssdk.services.glue.model.PartitionIndex;
import software.amazon.awssdk.services.glue.model.PartitionIndexListCopier;
import software.amazon.awssdk.services.glue.model.TableInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTableRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateTableRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(CreateTableRequest.getter(CreateTableRequest::catalogId)).setter(CreateTableRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(CreateTableRequest.getter(CreateTableRequest::databaseName)).setter(CreateTableRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<TableInput> TABLE_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TableInput").getter(CreateTableRequest.getter(CreateTableRequest::tableInput)).setter(CreateTableRequest.setter(Builder::tableInput)).constructor(TableInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableInput").build()}).build();
    private static final SdkField<List<PartitionIndex>> PARTITION_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartitionIndexes").getter(CreateTableRequest.getter(CreateTableRequest::partitionIndexes)).setter(CreateTableRequest.setter(Builder::partitionIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PartitionIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransactionId").getter(CreateTableRequest.getter(CreateTableRequest::transactionId)).setter(CreateTableRequest.setter(Builder::transactionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()}).build();
    private static final SdkField<OpenTableFormatInput> OPEN_TABLE_FORMAT_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpenTableFormatInput").getter(CreateTableRequest.getter(CreateTableRequest::openTableFormatInput)).setter(CreateTableRequest.setter(Builder::openTableFormatInput)).constructor(OpenTableFormatInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenTableFormatInput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, TABLE_INPUT_FIELD, PARTITION_INDEXES_FIELD, TRANSACTION_ID_FIELD, OPEN_TABLE_FORMAT_INPUT_FIELD));
    private final String catalogId;
    private final String databaseName;
    private final TableInput tableInput;
    private final List<PartitionIndex> partitionIndexes;
    private final String transactionId;
    private final OpenTableFormatInput openTableFormatInput;

    private CreateTableRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableInput = builder.tableInput;
        this.partitionIndexes = builder.partitionIndexes;
        this.transactionId = builder.transactionId;
        this.openTableFormatInput = builder.openTableFormatInput;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final TableInput tableInput() {
        return this.tableInput;
    }

    public final boolean hasPartitionIndexes() {
        return this.partitionIndexes != null && !(this.partitionIndexes instanceof SdkAutoConstructList);
    }

    public final List<PartitionIndex> partitionIndexes() {
        return this.partitionIndexes;
    }

    public final String transactionId() {
        return this.transactionId;
    }

    public final OpenTableFormatInput openTableFormatInput() {
        return this.openTableFormatInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionIndexes() ? this.partitionIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.openTableFormatInput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTableRequest)) {
            return false;
        }
        CreateTableRequest other = (CreateTableRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableInput(), other.tableInput()) && this.hasPartitionIndexes() == other.hasPartitionIndexes() && Objects.equals(this.partitionIndexes(), other.partitionIndexes()) && Objects.equals(this.transactionId(), other.transactionId()) && Objects.equals(this.openTableFormatInput(), other.openTableFormatInput());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTableRequest").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("TableInput", (Object)this.tableInput()).add("PartitionIndexes", this.hasPartitionIndexes() ? this.partitionIndexes() : null).add("TransactionId", (Object)this.transactionId()).add("OpenTableFormatInput", (Object)this.openTableFormatInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableInput": {
                return Optional.ofNullable(clazz.cast(this.tableInput()));
            }
            case "PartitionIndexes": {
                return Optional.ofNullable(clazz.cast(this.partitionIndexes()));
            }
            case "TransactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
            case "OpenTableFormatInput": {
                return Optional.ofNullable(clazz.cast(this.openTableFormatInput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTableRequest, T> g) {
        return obj -> g.apply((CreateTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private TableInput tableInput;
        private List<PartitionIndex> partitionIndexes = DefaultSdkAutoConstructList.getInstance();
        private String transactionId;
        private OpenTableFormatInput openTableFormatInput;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTableRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tableInput(model.tableInput);
            this.partitionIndexes(model.partitionIndexes);
            this.transactionId(model.transactionId);
            this.openTableFormatInput(model.openTableFormatInput);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final TableInput.Builder getTableInput() {
            return this.tableInput != null ? this.tableInput.toBuilder() : null;
        }

        public final void setTableInput(TableInput.BuilderImpl tableInput) {
            this.tableInput = tableInput != null ? tableInput.build() : null;
        }

        @Override
        public final Builder tableInput(TableInput tableInput) {
            this.tableInput = tableInput;
            return this;
        }

        public final List<PartitionIndex.Builder> getPartitionIndexes() {
            List<PartitionIndex.Builder> result = PartitionIndexListCopier.copyToBuilder(this.partitionIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartitionIndexes(Collection<PartitionIndex.BuilderImpl> partitionIndexes) {
            this.partitionIndexes = PartitionIndexListCopier.copyFromBuilder(partitionIndexes);
        }

        @Override
        public final Builder partitionIndexes(Collection<PartitionIndex> partitionIndexes) {
            this.partitionIndexes = PartitionIndexListCopier.copy(partitionIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionIndexes(PartitionIndex ... partitionIndexes) {
            this.partitionIndexes(Arrays.asList(partitionIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionIndexes(Consumer<PartitionIndex.Builder> ... partitionIndexes) {
            this.partitionIndexes(Stream.of(partitionIndexes).map(c -> (PartitionIndex)((PartitionIndex.Builder)PartitionIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final OpenTableFormatInput.Builder getOpenTableFormatInput() {
            return this.openTableFormatInput != null ? this.openTableFormatInput.toBuilder() : null;
        }

        public final void setOpenTableFormatInput(OpenTableFormatInput.BuilderImpl openTableFormatInput) {
            this.openTableFormatInput = openTableFormatInput != null ? openTableFormatInput.build() : null;
        }

        @Override
        public final Builder openTableFormatInput(OpenTableFormatInput openTableFormatInput) {
            this.openTableFormatInput = openTableFormatInput;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTableRequest build() {
            return new CreateTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTableRequest> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableInput(TableInput var1);

        default public Builder tableInput(Consumer<TableInput.Builder> tableInput) {
            return this.tableInput((TableInput)((TableInput.Builder)TableInput.builder().applyMutation(tableInput)).build());
        }

        public Builder partitionIndexes(Collection<PartitionIndex> var1);

        public Builder partitionIndexes(PartitionIndex ... var1);

        public Builder partitionIndexes(Consumer<PartitionIndex.Builder> ... var1);

        public Builder transactionId(String var1);

        public Builder openTableFormatInput(OpenTableFormatInput var1);

        default public Builder openTableFormatInput(Consumer<OpenTableFormatInput.Builder> openTableFormatInput) {
            return this.openTableFormatInput((OpenTableFormatInput)((OpenTableFormatInput.Builder)OpenTableFormatInput.builder().applyMutation(openTableFormatInput)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

