/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataQualityModelResultRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetDataQualityModelResultRequest> {
    private static final SdkField<String> STATISTIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatisticId").getter(GetDataQualityModelResultRequest.getter(GetDataQualityModelResultRequest::statisticId)).setter(GetDataQualityModelResultRequest.setter(Builder::statisticId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticId").build()}).build();
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileId").getter(GetDataQualityModelResultRequest.getter(GetDataQualityModelResultRequest::profileId)).setter(GetDataQualityModelResultRequest.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATISTIC_ID_FIELD, PROFILE_ID_FIELD));
    private final String statisticId;
    private final String profileId;

    private GetDataQualityModelResultRequest(BuilderImpl builder) {
        super(builder);
        this.statisticId = builder.statisticId;
        this.profileId = builder.profileId;
    }

    public final String statisticId() {
        return this.statisticId;
    }

    public final String profileId() {
        return this.profileId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticId());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataQualityModelResultRequest)) {
            return false;
        }
        GetDataQualityModelResultRequest other = (GetDataQualityModelResultRequest)((Object)obj);
        return Objects.equals(this.statisticId(), other.statisticId()) && Objects.equals(this.profileId(), other.profileId());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataQualityModelResultRequest").add("StatisticId", (Object)this.statisticId()).add("ProfileId", (Object)this.profileId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StatisticId": {
                return Optional.ofNullable(clazz.cast(this.statisticId()));
            }
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataQualityModelResultRequest, T> g) {
        return obj -> g.apply((GetDataQualityModelResultRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String statisticId;
        private String profileId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataQualityModelResultRequest model) {
            super(model);
            this.statisticId(model.statisticId);
            this.profileId(model.profileId);
        }

        public final String getStatisticId() {
            return this.statisticId;
        }

        public final void setStatisticId(String statisticId) {
            this.statisticId = statisticId;
        }

        @Override
        public final Builder statisticId(String statisticId) {
            this.statisticId = statisticId;
            return this;
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDataQualityModelResultRequest build() {
            return new GetDataQualityModelResultRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataQualityModelResultRequest> {
        public Builder statisticId(String var1);

        public Builder profileId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

