/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListTriggersRequest;
import software.amazon.awssdk.services.glue.model.ListTriggersResponse;

public class ListTriggersIterable
implements SdkIterable<ListTriggersResponse> {
    private final GlueClient client;
    private final ListTriggersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTriggersIterable(GlueClient client, ListTriggersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTriggersResponseFetcher();
    }

    public Iterator<ListTriggersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> triggerNames() {
        Function<ListTriggersResponse, Iterator> getIterator = response -> {
            if (response != null && response.triggerNames() != null) {
                return response.triggerNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTriggersResponseFetcher
    implements SyncPageFetcher<ListTriggersResponse> {
        private ListTriggersResponseFetcher() {
        }

        public boolean hasNextPage(ListTriggersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTriggersResponse nextPage(ListTriggersResponse previousPage) {
            if (previousPage == null) {
                return ListTriggersIterable.this.client.listTriggers(ListTriggersIterable.this.firstRequest);
            }
            return ListTriggersIterable.this.client.listTriggers((ListTriggersRequest)((Object)ListTriggersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

