/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about how AWS Ground Station should conﬁgure an antenna for downlink demod decode during a contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AntennaDownlinkDemodDecodeConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AntennaDownlinkDemodDecodeConfig.Builder, AntennaDownlinkDemodDecodeConfig> {
    private static final SdkField<DecodeConfig> DECODE_CONFIG_FIELD = SdkField.<DecodeConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(AntennaDownlinkDemodDecodeConfig::decodeConfig)).setter(setter(Builder::decodeConfig))
            .constructor(DecodeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decodeConfig").build()).build();

    private static final SdkField<DemodulationConfig> DEMODULATION_CONFIG_FIELD = SdkField
            .<DemodulationConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(AntennaDownlinkDemodDecodeConfig::demodulationConfig)).setter(setter(Builder::demodulationConfig))
            .constructor(DemodulationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("demodulationConfig").build())
            .build();

    private static final SdkField<SpectrumConfig> SPECTRUM_CONFIG_FIELD = SdkField
            .<SpectrumConfig> builder(MarshallingType.SDK_POJO).getter(getter(AntennaDownlinkDemodDecodeConfig::spectrumConfig))
            .setter(setter(Builder::spectrumConfig)).constructor(SpectrumConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spectrumConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECODE_CONFIG_FIELD,
            DEMODULATION_CONFIG_FIELD, SPECTRUM_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final DecodeConfig decodeConfig;

    private final DemodulationConfig demodulationConfig;

    private final SpectrumConfig spectrumConfig;

    private AntennaDownlinkDemodDecodeConfig(BuilderImpl builder) {
        this.decodeConfig = builder.decodeConfig;
        this.demodulationConfig = builder.demodulationConfig;
        this.spectrumConfig = builder.spectrumConfig;
    }

    /**
     * <p>
     * Information about the decode <code>Config</code>.
     * </p>
     * 
     * @return Information about the decode <code>Config</code>.
     */
    public DecodeConfig decodeConfig() {
        return decodeConfig;
    }

    /**
     * <p>
     * Information about the demodulation <code>Config</code>.
     * </p>
     * 
     * @return Information about the demodulation <code>Config</code>.
     */
    public DemodulationConfig demodulationConfig() {
        return demodulationConfig;
    }

    /**
     * <p>
     * Information about the spectral <code>Config</code>.
     * </p>
     * 
     * @return Information about the spectral <code>Config</code>.
     */
    public SpectrumConfig spectrumConfig() {
        return spectrumConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(decodeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(demodulationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(spectrumConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AntennaDownlinkDemodDecodeConfig)) {
            return false;
        }
        AntennaDownlinkDemodDecodeConfig other = (AntennaDownlinkDemodDecodeConfig) obj;
        return Objects.equals(decodeConfig(), other.decodeConfig())
                && Objects.equals(demodulationConfig(), other.demodulationConfig())
                && Objects.equals(spectrumConfig(), other.spectrumConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AntennaDownlinkDemodDecodeConfig").add("DecodeConfig", decodeConfig())
                .add("DemodulationConfig", demodulationConfig()).add("SpectrumConfig", spectrumConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "decodeConfig":
            return Optional.ofNullable(clazz.cast(decodeConfig()));
        case "demodulationConfig":
            return Optional.ofNullable(clazz.cast(demodulationConfig()));
        case "spectrumConfig":
            return Optional.ofNullable(clazz.cast(spectrumConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AntennaDownlinkDemodDecodeConfig, T> g) {
        return obj -> g.apply((AntennaDownlinkDemodDecodeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AntennaDownlinkDemodDecodeConfig> {
        /**
         * <p>
         * Information about the decode <code>Config</code>.
         * </p>
         * 
         * @param decodeConfig
         *        Information about the decode <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decodeConfig(DecodeConfig decodeConfig);

        /**
         * <p>
         * Information about the decode <code>Config</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link DecodeConfig.Builder} avoiding the need to
         * create one manually via {@link DecodeConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DecodeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #decodeConfig(DecodeConfig)}.
         * 
         * @param decodeConfig
         *        a consumer that will call methods on {@link DecodeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decodeConfig(DecodeConfig)
         */
        default Builder decodeConfig(Consumer<DecodeConfig.Builder> decodeConfig) {
            return decodeConfig(DecodeConfig.builder().applyMutation(decodeConfig).build());
        }

        /**
         * <p>
         * Information about the demodulation <code>Config</code>.
         * </p>
         * 
         * @param demodulationConfig
         *        Information about the demodulation <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder demodulationConfig(DemodulationConfig demodulationConfig);

        /**
         * <p>
         * Information about the demodulation <code>Config</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link DemodulationConfig.Builder} avoiding the need to
         * create one manually via {@link DemodulationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DemodulationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #demodulationConfig(DemodulationConfig)}.
         * 
         * @param demodulationConfig
         *        a consumer that will call methods on {@link DemodulationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #demodulationConfig(DemodulationConfig)
         */
        default Builder demodulationConfig(Consumer<DemodulationConfig.Builder> demodulationConfig) {
            return demodulationConfig(DemodulationConfig.builder().applyMutation(demodulationConfig).build());
        }

        /**
         * <p>
         * Information about the spectral <code>Config</code>.
         * </p>
         * 
         * @param spectrumConfig
         *        Information about the spectral <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spectrumConfig(SpectrumConfig spectrumConfig);

        /**
         * <p>
         * Information about the spectral <code>Config</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link SpectrumConfig.Builder} avoiding the need to
         * create one manually via {@link SpectrumConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link SpectrumConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #spectrumConfig(SpectrumConfig)}.
         * 
         * @param spectrumConfig
         *        a consumer that will call methods on {@link SpectrumConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spectrumConfig(SpectrumConfig)
         */
        default Builder spectrumConfig(Consumer<SpectrumConfig.Builder> spectrumConfig) {
            return spectrumConfig(SpectrumConfig.builder().applyMutation(spectrumConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DecodeConfig decodeConfig;

        private DemodulationConfig demodulationConfig;

        private SpectrumConfig spectrumConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AntennaDownlinkDemodDecodeConfig model) {
            decodeConfig(model.decodeConfig);
            demodulationConfig(model.demodulationConfig);
            spectrumConfig(model.spectrumConfig);
        }

        public final DecodeConfig.Builder getDecodeConfig() {
            return decodeConfig != null ? decodeConfig.toBuilder() : null;
        }

        @Override
        public final Builder decodeConfig(DecodeConfig decodeConfig) {
            this.decodeConfig = decodeConfig;
            return this;
        }

        public final void setDecodeConfig(DecodeConfig.BuilderImpl decodeConfig) {
            this.decodeConfig = decodeConfig != null ? decodeConfig.build() : null;
        }

        public final DemodulationConfig.Builder getDemodulationConfig() {
            return demodulationConfig != null ? demodulationConfig.toBuilder() : null;
        }

        @Override
        public final Builder demodulationConfig(DemodulationConfig demodulationConfig) {
            this.demodulationConfig = demodulationConfig;
            return this;
        }

        public final void setDemodulationConfig(DemodulationConfig.BuilderImpl demodulationConfig) {
            this.demodulationConfig = demodulationConfig != null ? demodulationConfig.build() : null;
        }

        public final SpectrumConfig.Builder getSpectrumConfig() {
            return spectrumConfig != null ? spectrumConfig.toBuilder() : null;
        }

        @Override
        public final Builder spectrumConfig(SpectrumConfig spectrumConfig) {
            this.spectrumConfig = spectrumConfig;
            return this;
        }

        public final void setSpectrumConfig(SpectrumConfig.BuilderImpl spectrumConfig) {
            this.spectrumConfig = spectrumConfig != null ? spectrumConfig.build() : null;
        }

        @Override
        public AntennaDownlinkDemodDecodeConfig build() {
            return new AntennaDownlinkDemodDecodeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
