/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the uplink <code>Config</code> of an antenna.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AntennaUplinkConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AntennaUplinkConfig.Builder, AntennaUplinkConfig> {
    private static final SdkField<UplinkSpectrumConfig> SPECTRUM_CONFIG_FIELD = SdkField
            .<UplinkSpectrumConfig> builder(MarshallingType.SDK_POJO).getter(getter(AntennaUplinkConfig::spectrumConfig))
            .setter(setter(Builder::spectrumConfig)).constructor(UplinkSpectrumConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spectrumConfig").build()).build();

    private static final SdkField<Eirp> TARGET_EIRP_FIELD = SdkField.<Eirp> builder(MarshallingType.SDK_POJO)
            .getter(getter(AntennaUplinkConfig::targetEirp)).setter(setter(Builder::targetEirp)).constructor(Eirp::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetEirp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPECTRUM_CONFIG_FIELD,
            TARGET_EIRP_FIELD));

    private static final long serialVersionUID = 1L;

    private final UplinkSpectrumConfig spectrumConfig;

    private final Eirp targetEirp;

    private AntennaUplinkConfig(BuilderImpl builder) {
        this.spectrumConfig = builder.spectrumConfig;
        this.targetEirp = builder.targetEirp;
    }

    /**
     * <p>
     * Information about the uplink spectral <code>Config</code>.
     * </p>
     * 
     * @return Information about the uplink spectral <code>Config</code>.
     */
    public UplinkSpectrumConfig spectrumConfig() {
        return spectrumConfig;
    }

    /**
     * <p>
     * EIRP of the target.
     * </p>
     * 
     * @return EIRP of the target.
     */
    public Eirp targetEirp() {
        return targetEirp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(spectrumConfig());
        hashCode = 31 * hashCode + Objects.hashCode(targetEirp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AntennaUplinkConfig)) {
            return false;
        }
        AntennaUplinkConfig other = (AntennaUplinkConfig) obj;
        return Objects.equals(spectrumConfig(), other.spectrumConfig()) && Objects.equals(targetEirp(), other.targetEirp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AntennaUplinkConfig").add("SpectrumConfig", spectrumConfig()).add("TargetEirp", targetEirp())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "spectrumConfig":
            return Optional.ofNullable(clazz.cast(spectrumConfig()));
        case "targetEirp":
            return Optional.ofNullable(clazz.cast(targetEirp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AntennaUplinkConfig, T> g) {
        return obj -> g.apply((AntennaUplinkConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AntennaUplinkConfig> {
        /**
         * <p>
         * Information about the uplink spectral <code>Config</code>.
         * </p>
         * 
         * @param spectrumConfig
         *        Information about the uplink spectral <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spectrumConfig(UplinkSpectrumConfig spectrumConfig);

        /**
         * <p>
         * Information about the uplink spectral <code>Config</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link UplinkSpectrumConfig.Builder} avoiding the need
         * to create one manually via {@link UplinkSpectrumConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link UplinkSpectrumConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #spectrumConfig(UplinkSpectrumConfig)}.
         * 
         * @param spectrumConfig
         *        a consumer that will call methods on {@link UplinkSpectrumConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spectrumConfig(UplinkSpectrumConfig)
         */
        default Builder spectrumConfig(Consumer<UplinkSpectrumConfig.Builder> spectrumConfig) {
            return spectrumConfig(UplinkSpectrumConfig.builder().applyMutation(spectrumConfig).build());
        }

        /**
         * <p>
         * EIRP of the target.
         * </p>
         * 
         * @param targetEirp
         *        EIRP of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetEirp(Eirp targetEirp);

        /**
         * <p>
         * EIRP of the target.
         * </p>
         * This is a convenience that creates an instance of the {@link Eirp.Builder} avoiding the need to create one
         * manually via {@link Eirp#builder()}.
         *
         * When the {@link Consumer} completes, {@link Eirp.Builder#build()} is called immediately and its result is
         * passed to {@link #targetEirp(Eirp)}.
         * 
         * @param targetEirp
         *        a consumer that will call methods on {@link Eirp.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetEirp(Eirp)
         */
        default Builder targetEirp(Consumer<Eirp.Builder> targetEirp) {
            return targetEirp(Eirp.builder().applyMutation(targetEirp).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UplinkSpectrumConfig spectrumConfig;

        private Eirp targetEirp;

        private BuilderImpl() {
        }

        private BuilderImpl(AntennaUplinkConfig model) {
            spectrumConfig(model.spectrumConfig);
            targetEirp(model.targetEirp);
        }

        public final UplinkSpectrumConfig.Builder getSpectrumConfig() {
            return spectrumConfig != null ? spectrumConfig.toBuilder() : null;
        }

        @Override
        public final Builder spectrumConfig(UplinkSpectrumConfig spectrumConfig) {
            this.spectrumConfig = spectrumConfig;
            return this;
        }

        public final void setSpectrumConfig(UplinkSpectrumConfig.BuilderImpl spectrumConfig) {
            this.spectrumConfig = spectrumConfig != null ? spectrumConfig.build() : null;
        }

        public final Eirp.Builder getTargetEirp() {
            return targetEirp != null ? targetEirp.toBuilder() : null;
        }

        @Override
        public final Builder targetEirp(Eirp targetEirp) {
            this.targetEirp = targetEirp;
            return this;
        }

        public final void setTargetEirp(Eirp.BuilderImpl targetEirp) {
            this.targetEirp = targetEirp != null ? targetEirp.build() : null;
        }

        @Override
        public AntennaUplinkConfig build() {
            return new AntennaUplinkConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
