/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the dataflow endpoint <code>Config</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataflowEndpointConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DataflowEndpointConfig.Builder, DataflowEndpointConfig> {
    private static final SdkField<String> DATAFLOW_ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataflowEndpointConfig::dataflowEndpointName)).setter(setter(Builder::dataflowEndpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEndpointName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATAFLOW_ENDPOINT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataflowEndpointName;

    private DataflowEndpointConfig(BuilderImpl builder) {
        this.dataflowEndpointName = builder.dataflowEndpointName;
    }

    /**
     * <p>
     * Name of a dataflow endpoint.
     * </p>
     * 
     * @return Name of a dataflow endpoint.
     */
    public String dataflowEndpointName() {
        return dataflowEndpointName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataflowEndpointName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataflowEndpointConfig)) {
            return false;
        }
        DataflowEndpointConfig other = (DataflowEndpointConfig) obj;
        return Objects.equals(dataflowEndpointName(), other.dataflowEndpointName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DataflowEndpointConfig").add("DataflowEndpointName", dataflowEndpointName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataflowEndpointName":
            return Optional.ofNullable(clazz.cast(dataflowEndpointName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataflowEndpointConfig, T> g) {
        return obj -> g.apply((DataflowEndpointConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataflowEndpointConfig> {
        /**
         * <p>
         * Name of a dataflow endpoint.
         * </p>
         * 
         * @param dataflowEndpointName
         *        Name of a dataflow endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEndpointName(String dataflowEndpointName);
    }

    static final class BuilderImpl implements Builder {
        private String dataflowEndpointName;

        private BuilderImpl() {
        }

        private BuilderImpl(DataflowEndpointConfig model) {
            dataflowEndpointName(model.dataflowEndpointName);
        }

        public final String getDataflowEndpointName() {
            return dataflowEndpointName;
        }

        @Override
        public final Builder dataflowEndpointName(String dataflowEndpointName) {
            this.dataflowEndpointName = dataflowEndpointName;
            return this;
        }

        public final void setDataflowEndpointName(String dataflowEndpointName) {
            this.dataflowEndpointName = dataflowEndpointName;
        }

        @Override
        public DataflowEndpointConfig build() {
            return new DataflowEndpointConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
