/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfigRequest extends GroundStationRequest implements
        ToCopyableBuilder<GetConfigRequest.Builder, GetConfigRequest> {
    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetConfigRequest::configId)).setter(setter(Builder::configId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("configId").build()).build();

    private static final SdkField<String> CONFIG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetConfigRequest::configTypeAsString)).setter(setter(Builder::configType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("configType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_ID_FIELD,
            CONFIG_TYPE_FIELD));

    private final String configId;

    private final String configType;

    private GetConfigRequest(BuilderImpl builder) {
        super(builder);
        this.configId = builder.configId;
        this.configType = builder.configType;
    }

    /**
     * <p>
     * UUID of a <code>Config</code>.
     * </p>
     * 
     * @return UUID of a <code>Config</code>.
     */
    public String configId() {
        return configId;
    }

    /**
     * <p>
     * Type of a <code>Config</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configType} will
     * return {@link ConfigCapabilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configTypeAsString}.
     * </p>
     * 
     * @return Type of a <code>Config</code>.
     * @see ConfigCapabilityType
     */
    public ConfigCapabilityType configType() {
        return ConfigCapabilityType.fromValue(configType);
    }

    /**
     * <p>
     * Type of a <code>Config</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configType} will
     * return {@link ConfigCapabilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configTypeAsString}.
     * </p>
     * 
     * @return Type of a <code>Config</code>.
     * @see ConfigCapabilityType
     */
    public String configTypeAsString() {
        return configType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configId());
        hashCode = 31 * hashCode + Objects.hashCode(configTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigRequest)) {
            return false;
        }
        GetConfigRequest other = (GetConfigRequest) obj;
        return Objects.equals(configId(), other.configId()) && Objects.equals(configTypeAsString(), other.configTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetConfigRequest").add("ConfigId", configId()).add("ConfigType", configTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configId":
            return Optional.ofNullable(clazz.cast(configId()));
        case "configType":
            return Optional.ofNullable(clazz.cast(configTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfigRequest, T> g) {
        return obj -> g.apply((GetConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetConfigRequest> {
        /**
         * <p>
         * UUID of a <code>Config</code>.
         * </p>
         * 
         * @param configId
         *        UUID of a <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configId(String configId);

        /**
         * <p>
         * Type of a <code>Config</code>.
         * </p>
         * 
         * @param configType
         *        Type of a <code>Config</code>.
         * @see ConfigCapabilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigCapabilityType
         */
        Builder configType(String configType);

        /**
         * <p>
         * Type of a <code>Config</code>.
         * </p>
         * 
         * @param configType
         *        Type of a <code>Config</code>.
         * @see ConfigCapabilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigCapabilityType
         */
        Builder configType(ConfigCapabilityType configType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GroundStationRequest.BuilderImpl implements Builder {
        private String configId;

        private String configType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigRequest model) {
            super(model);
            configId(model.configId);
            configType(model.configType);
        }

        public final String getConfigId() {
            return configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        public final String getConfigTypeAsString() {
            return configType;
        }

        @Override
        public final Builder configType(String configType) {
            this.configType = configType;
            return this;
        }

        @Override
        public final Builder configType(ConfigCapabilityType configType) {
            this.configType(configType == null ? null : configType.toString());
            return this;
        }

        public final void setConfigType(String configType) {
            this.configType = configType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConfigRequest build() {
            return new GetConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
