/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataflowEndpointGroupResponse extends GroundStationResponse implements
        ToCopyableBuilder<GetDataflowEndpointGroupResponse.Builder, GetDataflowEndpointGroupResponse> {
    private static final SdkField<String> DATAFLOW_ENDPOINT_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDataflowEndpointGroupResponse::dataflowEndpointGroupArn))
            .setter(setter(Builder::dataflowEndpointGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEndpointGroupArn").build())
            .build();

    private static final SdkField<String> DATAFLOW_ENDPOINT_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDataflowEndpointGroupResponse::dataflowEndpointGroupId))
            .setter(setter(Builder::dataflowEndpointGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEndpointGroupId").build())
            .build();

    private static final SdkField<List<EndpointDetails>> ENDPOINTS_DETAILS_FIELD = SdkField
            .<List<EndpointDetails>> builder(MarshallingType.LIST)
            .getter(getter(GetDataflowEndpointGroupResponse::endpointsDetails))
            .setter(setter(Builder::endpointsDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointsDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EndpointDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndpointDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetDataflowEndpointGroupResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATAFLOW_ENDPOINT_GROUP_ARN_FIELD, DATAFLOW_ENDPOINT_GROUP_ID_FIELD, ENDPOINTS_DETAILS_FIELD, TAGS_FIELD));

    private final String dataflowEndpointGroupArn;

    private final String dataflowEndpointGroupId;

    private final List<EndpointDetails> endpointsDetails;

    private final Map<String, String> tags;

    private GetDataflowEndpointGroupResponse(BuilderImpl builder) {
        super(builder);
        this.dataflowEndpointGroupArn = builder.dataflowEndpointGroupArn;
        this.dataflowEndpointGroupId = builder.dataflowEndpointGroupId;
        this.endpointsDetails = builder.endpointsDetails;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * ARN of a dataflow endpoint group.
     * </p>
     * 
     * @return ARN of a dataflow endpoint group.
     */
    public String dataflowEndpointGroupArn() {
        return dataflowEndpointGroupArn;
    }

    /**
     * <p>
     * UUID of a dataflow endpoint group.
     * </p>
     * 
     * @return UUID of a dataflow endpoint group.
     */
    public String dataflowEndpointGroupId() {
        return dataflowEndpointGroupId;
    }

    /**
     * Returns true if the EndpointsDetails property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEndpointsDetails() {
        return endpointsDetails != null && !(endpointsDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of a dataflow endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEndpointsDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Details of a dataflow endpoint.
     */
    public List<EndpointDetails> endpointsDetails() {
        return endpointsDetails;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags assigned to a dataflow endpoint group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tags assigned to a dataflow endpoint group.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataflowEndpointGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataflowEndpointGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(endpointsDetails());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataflowEndpointGroupResponse)) {
            return false;
        }
        GetDataflowEndpointGroupResponse other = (GetDataflowEndpointGroupResponse) obj;
        return Objects.equals(dataflowEndpointGroupArn(), other.dataflowEndpointGroupArn())
                && Objects.equals(dataflowEndpointGroupId(), other.dataflowEndpointGroupId())
                && Objects.equals(endpointsDetails(), other.endpointsDetails()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDataflowEndpointGroupResponse").add("DataflowEndpointGroupArn", dataflowEndpointGroupArn())
                .add("DataflowEndpointGroupId", dataflowEndpointGroupId()).add("EndpointsDetails", endpointsDetails())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataflowEndpointGroupArn":
            return Optional.ofNullable(clazz.cast(dataflowEndpointGroupArn()));
        case "dataflowEndpointGroupId":
            return Optional.ofNullable(clazz.cast(dataflowEndpointGroupId()));
        case "endpointsDetails":
            return Optional.ofNullable(clazz.cast(endpointsDetails()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataflowEndpointGroupResponse, T> g) {
        return obj -> g.apply((GetDataflowEndpointGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDataflowEndpointGroupResponse> {
        /**
         * <p>
         * ARN of a dataflow endpoint group.
         * </p>
         * 
         * @param dataflowEndpointGroupArn
         *        ARN of a dataflow endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEndpointGroupArn(String dataflowEndpointGroupArn);

        /**
         * <p>
         * UUID of a dataflow endpoint group.
         * </p>
         * 
         * @param dataflowEndpointGroupId
         *        UUID of a dataflow endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEndpointGroupId(String dataflowEndpointGroupId);

        /**
         * <p>
         * Details of a dataflow endpoint.
         * </p>
         * 
         * @param endpointsDetails
         *        Details of a dataflow endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointsDetails(Collection<EndpointDetails> endpointsDetails);

        /**
         * <p>
         * Details of a dataflow endpoint.
         * </p>
         * 
         * @param endpointsDetails
         *        Details of a dataflow endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointsDetails(EndpointDetails... endpointsDetails);

        /**
         * <p>
         * Details of a dataflow endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EndpointDetails>.Builder} avoiding the need
         * to create one manually via {@link List<EndpointDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EndpointDetails>.Builder#build()} is called immediately and
         * its result is passed to {@link #endpointsDetails(List<EndpointDetails>)}.
         * 
         * @param endpointsDetails
         *        a consumer that will call methods on {@link List<EndpointDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointsDetails(List<EndpointDetails>)
         */
        Builder endpointsDetails(Consumer<EndpointDetails.Builder>... endpointsDetails);

        /**
         * <p>
         * Tags assigned to a dataflow endpoint group.
         * </p>
         * 
         * @param tags
         *        Tags assigned to a dataflow endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private String dataflowEndpointGroupArn;

        private String dataflowEndpointGroupId;

        private List<EndpointDetails> endpointsDetails = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataflowEndpointGroupResponse model) {
            super(model);
            dataflowEndpointGroupArn(model.dataflowEndpointGroupArn);
            dataflowEndpointGroupId(model.dataflowEndpointGroupId);
            endpointsDetails(model.endpointsDetails);
            tags(model.tags);
        }

        public final String getDataflowEndpointGroupArn() {
            return dataflowEndpointGroupArn;
        }

        @Override
        public final Builder dataflowEndpointGroupArn(String dataflowEndpointGroupArn) {
            this.dataflowEndpointGroupArn = dataflowEndpointGroupArn;
            return this;
        }

        public final void setDataflowEndpointGroupArn(String dataflowEndpointGroupArn) {
            this.dataflowEndpointGroupArn = dataflowEndpointGroupArn;
        }

        public final String getDataflowEndpointGroupId() {
            return dataflowEndpointGroupId;
        }

        @Override
        public final Builder dataflowEndpointGroupId(String dataflowEndpointGroupId) {
            this.dataflowEndpointGroupId = dataflowEndpointGroupId;
            return this;
        }

        public final void setDataflowEndpointGroupId(String dataflowEndpointGroupId) {
            this.dataflowEndpointGroupId = dataflowEndpointGroupId;
        }

        public final Collection<EndpointDetails.Builder> getEndpointsDetails() {
            return endpointsDetails != null ? endpointsDetails.stream().map(EndpointDetails::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpointsDetails(Collection<EndpointDetails> endpointsDetails) {
            this.endpointsDetails = EndpointDetailsListCopier.copy(endpointsDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointsDetails(EndpointDetails... endpointsDetails) {
            endpointsDetails(Arrays.asList(endpointsDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointsDetails(Consumer<EndpointDetails.Builder>... endpointsDetails) {
            endpointsDetails(Stream.of(endpointsDetails).map(c -> EndpointDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEndpointsDetails(Collection<EndpointDetails.BuilderImpl> endpointsDetails) {
            this.endpointsDetails = EndpointDetailsListCopier.copyFromBuilder(endpointsDetails);
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public GetDataflowEndpointGroupResponse build() {
            return new GetDataflowEndpointGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
