/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMinuteUsageRequest extends GroundStationRequest implements
        ToCopyableBuilder<GetMinuteUsageRequest.Builder, GetMinuteUsageRequest> {
    private static final SdkField<Integer> MONTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetMinuteUsageRequest::month)).setter(setter(Builder::month))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("month").build()).build();

    private static final SdkField<Integer> YEAR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetMinuteUsageRequest::year)).setter(setter(Builder::year))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("year").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONTH_FIELD, YEAR_FIELD));

    private final Integer month;

    private final Integer year;

    private GetMinuteUsageRequest(BuilderImpl builder) {
        super(builder);
        this.month = builder.month;
        this.year = builder.year;
    }

    /**
     * <p>
     * The month being requested, with a value of 1-12.
     * </p>
     * 
     * @return The month being requested, with a value of 1-12.
     */
    public Integer month() {
        return month;
    }

    /**
     * <p>
     * The year being requested, in the format of YYYY.
     * </p>
     * 
     * @return The year being requested, in the format of YYYY.
     */
    public Integer year() {
        return year;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(month());
        hashCode = 31 * hashCode + Objects.hashCode(year());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMinuteUsageRequest)) {
            return false;
        }
        GetMinuteUsageRequest other = (GetMinuteUsageRequest) obj;
        return Objects.equals(month(), other.month()) && Objects.equals(year(), other.year());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetMinuteUsageRequest").add("Month", month()).add("Year", year()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "month":
            return Optional.ofNullable(clazz.cast(month()));
        case "year":
            return Optional.ofNullable(clazz.cast(year()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMinuteUsageRequest, T> g) {
        return obj -> g.apply((GetMinuteUsageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMinuteUsageRequest> {
        /**
         * <p>
         * The month being requested, with a value of 1-12.
         * </p>
         * 
         * @param month
         *        The month being requested, with a value of 1-12.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder month(Integer month);

        /**
         * <p>
         * The year being requested, in the format of YYYY.
         * </p>
         * 
         * @param year
         *        The year being requested, in the format of YYYY.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder year(Integer year);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GroundStationRequest.BuilderImpl implements Builder {
        private Integer month;

        private Integer year;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMinuteUsageRequest model) {
            super(model);
            month(model.month);
            year(model.year);
        }

        public final Integer getMonth() {
            return month;
        }

        @Override
        public final Builder month(Integer month) {
            this.month = month;
            return this;
        }

        public final void setMonth(Integer month) {
            this.month = month;
        }

        public final Integer getYear() {
            return year;
        }

        @Override
        public final Builder year(Integer year) {
            this.year = year;
            return this;
        }

        public final void setYear(Integer year) {
            this.year = year;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMinuteUsageRequest build() {
            return new GetMinuteUsageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
