/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateThreatIntelSetResponse extends GuardDutyResponse implements
        ToCopyableBuilder<CreateThreatIntelSetResponse.Builder, CreateThreatIntelSetResponse> {
    private static final SdkField<String> THREAT_INTEL_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateThreatIntelSetResponse::threatIntelSetId)).setter(setter(Builder::threatIntelSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatIntelSetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THREAT_INTEL_SET_ID_FIELD));

    private final String threatIntelSetId;

    private CreateThreatIntelSetResponse(BuilderImpl builder) {
        super(builder);
        this.threatIntelSetId = builder.threatIntelSetId;
    }

    /**
     * <p>
     * The ID of the ThreatIntelSet resource.
     * </p>
     * 
     * @return The ID of the ThreatIntelSet resource.
     */
    public String threatIntelSetId() {
        return threatIntelSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(threatIntelSetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThreatIntelSetResponse)) {
            return false;
        }
        CreateThreatIntelSetResponse other = (CreateThreatIntelSetResponse) obj;
        return Objects.equals(threatIntelSetId(), other.threatIntelSetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateThreatIntelSetResponse").add("ThreatIntelSetId", threatIntelSetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ThreatIntelSetId":
            return Optional.ofNullable(clazz.cast(threatIntelSetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateThreatIntelSetResponse, T> g) {
        return obj -> g.apply((CreateThreatIntelSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateThreatIntelSetResponse> {
        /**
         * <p>
         * The ID of the ThreatIntelSet resource.
         * </p>
         * 
         * @param threatIntelSetId
         *        The ID of the ThreatIntelSet resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelSetId(String threatIntelSetId);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private String threatIntelSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThreatIntelSetResponse model) {
            super(model);
            threatIntelSetId(model.threatIntelSetId);
        }

        public final String getThreatIntelSetId() {
            return threatIntelSetId;
        }

        @Override
        public final Builder threatIntelSetId(String threatIntelSetId) {
            this.threatIntelSetId = threatIntelSetId;
            return this;
        }

        public final void setThreatIntelSetId(String threatIntelSetId) {
            this.threatIntelSetId = threatIntelSetId;
        }

        @Override
        public CreateThreatIntelSetResponse build() {
            return new CreateThreatIntelSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
