/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInvitationsResponse extends GuardDutyResponse implements
        ToCopyableBuilder<ListInvitationsResponse.Builder, ListInvitationsResponse> {
    private static final SdkField<List<Invitation>> INVITATIONS_FIELD = SdkField
            .<List<Invitation>> builder(MarshallingType.LIST)
            .getter(getter(ListInvitationsResponse::invitations))
            .setter(setter(Builder::invitations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invitations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Invitation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Invitation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListInvitationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVITATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Invitation> invitations;

    private final String nextToken;

    private ListInvitationsResponse(BuilderImpl builder) {
        super(builder);
        this.invitations = builder.invitations;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Invitations property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInvitations() {
        return invitations != null && !(invitations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of invitation descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInvitations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of invitation descriptions.
     */
    public List<Invitation> invitations() {
        return invitations;
    }

    /**
     * <p>
     * Pagination parameter to be used on the next list operation to retrieve more items.
     * </p>
     * 
     * @return Pagination parameter to be used on the next list operation to retrieve more items.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(invitations());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvitationsResponse)) {
            return false;
        }
        ListInvitationsResponse other = (ListInvitationsResponse) obj;
        return Objects.equals(invitations(), other.invitations()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListInvitationsResponse").add("Invitations", invitations()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Invitations":
            return Optional.ofNullable(clazz.cast(invitations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInvitationsResponse, T> g) {
        return obj -> g.apply((ListInvitationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListInvitationsResponse> {
        /**
         * <p>
         * A list of invitation descriptions.
         * </p>
         * 
         * @param invitations
         *        A list of invitation descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitations(Collection<Invitation> invitations);

        /**
         * <p>
         * A list of invitation descriptions.
         * </p>
         * 
         * @param invitations
         *        A list of invitation descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitations(Invitation... invitations);

        /**
         * <p>
         * A list of invitation descriptions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Invitation>.Builder} avoiding the need to
         * create one manually via {@link List<Invitation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Invitation>.Builder#build()} is called immediately and its
         * result is passed to {@link #invitations(List<Invitation>)}.
         * 
         * @param invitations
         *        a consumer that will call methods on {@link List<Invitation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invitations(List<Invitation>)
         */
        Builder invitations(Consumer<Invitation.Builder>... invitations);

        /**
         * <p>
         * Pagination parameter to be used on the next list operation to retrieve more items.
         * </p>
         * 
         * @param nextToken
         *        Pagination parameter to be used on the next list operation to retrieve more items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private List<Invitation> invitations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvitationsResponse model) {
            super(model);
            invitations(model.invitations);
            nextToken(model.nextToken);
        }

        public final Collection<Invitation.Builder> getInvitations() {
            return invitations != null ? invitations.stream().map(Invitation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder invitations(Collection<Invitation> invitations) {
            this.invitations = InvitationsCopier.copy(invitations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invitations(Invitation... invitations) {
            invitations(Arrays.asList(invitations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invitations(Consumer<Invitation.Builder>... invitations) {
            invitations(Stream.of(invitations).map(c -> Invitation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInvitations(Collection<Invitation.BuilderImpl> invitations) {
            this.invitations = InvitationsCopier.copyFromBuilder(invitations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInvitationsResponse build() {
            return new ListInvitationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
