/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.guardduty.model.AnomalyObject;
import software.amazon.awssdk.services.guardduty.model.AnomalyProfilesCopier;
import software.amazon.awssdk.services.guardduty.model.AnomalyUnusual;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Anomaly
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Anomaly> {
    private static final SdkField<Map<String, Map<String, List<AnomalyObject>>>> PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Profiles").getter(Anomaly.getter(Anomaly::profiles)).setter(Anomaly.setter(Builder::profiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profiles").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnomalyObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<AnomalyUnusual> UNUSUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Unusual").getter(Anomaly.getter(Anomaly::unusual)).setter(Anomaly.setter(Builder::unusual)).constructor(AnomalyUnusual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusual").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILES_FIELD, UNUSUAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Anomaly.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, Map<String, List<AnomalyObject>>> profiles;
    private final AnomalyUnusual unusual;

    private Anomaly(BuilderImpl builder) {
        this.profiles = builder.profiles;
        this.unusual = builder.unusual;
    }

    public final boolean hasProfiles() {
        return this.profiles != null && !(this.profiles instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, List<AnomalyObject>>> profiles() {
        return this.profiles;
    }

    public final AnomalyUnusual unusual() {
        return this.unusual;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfiles() ? this.profiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.unusual());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Anomaly)) {
            return false;
        }
        Anomaly other = (Anomaly)obj;
        return this.hasProfiles() == other.hasProfiles() && Objects.equals(this.profiles(), other.profiles()) && Objects.equals(this.unusual(), other.unusual());
    }

    public final String toString() {
        return ToString.builder((String)"Anomaly").add("Profiles", this.hasProfiles() ? this.profiles() : null).add("Unusual", (Object)this.unusual()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Profiles": {
                return Optional.ofNullable(clazz.cast(this.profiles()));
            }
            case "Unusual": {
                return Optional.ofNullable(clazz.cast(this.unusual()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("profiles", PROFILES_FIELD);
        map.put("unusual", UNUSUAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Anomaly, T> g) {
        return obj -> g.apply((Anomaly)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Map<String, List<AnomalyObject>>> profiles = DefaultSdkAutoConstructMap.getInstance();
        private AnomalyUnusual unusual;

        private BuilderImpl() {
        }

        private BuilderImpl(Anomaly model) {
            this.profiles(model.profiles);
            this.unusual(model.unusual);
        }

        public final Map<String, Map<String, List<AnomalyObject.Builder>>> getProfiles() {
            Map<String, Map<String, List<AnomalyObject.Builder>>> result = AnomalyProfilesCopier.copyToBuilder(this.profiles);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setProfiles(Map<String, ? extends Map<String, ? extends Collection<AnomalyObject.BuilderImpl>>> profiles) {
            this.profiles = AnomalyProfilesCopier.copyFromBuilder(profiles);
        }

        @Override
        public final Builder profiles(Map<String, ? extends Map<String, ? extends Collection<AnomalyObject>>> profiles) {
            this.profiles = AnomalyProfilesCopier.copy(profiles);
            return this;
        }

        public final AnomalyUnusual.Builder getUnusual() {
            return this.unusual != null ? this.unusual.toBuilder() : null;
        }

        public final void setUnusual(AnomalyUnusual.BuilderImpl unusual) {
            this.unusual = unusual != null ? unusual.build() : null;
        }

        @Override
        public final Builder unusual(AnomalyUnusual unusual) {
            this.unusual = unusual;
            return this;
        }

        public Anomaly build() {
            return new Anomaly(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Anomaly> {
        public Builder profiles(Map<String, ? extends Map<String, ? extends Collection<AnomalyObject>>> var1);

        public Builder unusual(AnomalyUnusual var1);

        default public Builder unusual(Consumer<AnomalyUnusual.Builder> unusual) {
            return this.unusual((AnomalyUnusual)((AnomalyUnusual.Builder)AnomalyUnusual.builder().applyMutation(unusual)).build());
        }
    }
}

