/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.AccessKey;
import software.amazon.awssdk.services.guardduty.model.Ec2Instance;
import software.amazon.awssdk.services.guardduty.model.Ec2NetworkInterface;
import software.amazon.awssdk.services.guardduty.model.S3Bucket;
import software.amazon.awssdk.services.guardduty.model.S3Object;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceData> {
    private static final SdkField<S3Bucket> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Bucket").getter(ResourceData.getter(ResourceData::s3Bucket)).setter(ResourceData.setter(Builder::s3Bucket)).constructor(S3Bucket::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()}).build();
    private static final SdkField<Ec2Instance> EC2_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ec2Instance").getter(ResourceData.getter(ResourceData::ec2Instance)).setter(ResourceData.setter(Builder::ec2Instance)).constructor(Ec2Instance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2Instance").build()}).build();
    private static final SdkField<AccessKey> ACCESS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessKey").getter(ResourceData.getter(ResourceData::accessKey)).setter(ResourceData.setter(Builder::accessKey)).constructor(AccessKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKey").build()}).build();
    private static final SdkField<Ec2NetworkInterface> EC2_NETWORK_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ec2NetworkInterface").getter(ResourceData.getter(ResourceData::ec2NetworkInterface)).setter(ResourceData.setter(Builder::ec2NetworkInterface)).constructor(Ec2NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2NetworkInterface").build()}).build();
    private static final SdkField<S3Object> S3_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Object").getter(ResourceData.getter(ResourceData::s3Object)).setter(ResourceData.setter(Builder::s3Object)).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Object").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD, EC2_INSTANCE_FIELD, ACCESS_KEY_FIELD, EC2_NETWORK_INTERFACE_FIELD, S3_OBJECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3Bucket s3Bucket;
    private final Ec2Instance ec2Instance;
    private final AccessKey accessKey;
    private final Ec2NetworkInterface ec2NetworkInterface;
    private final S3Object s3Object;

    private ResourceData(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.ec2Instance = builder.ec2Instance;
        this.accessKey = builder.accessKey;
        this.ec2NetworkInterface = builder.ec2NetworkInterface;
        this.s3Object = builder.s3Object;
    }

    public final S3Bucket s3Bucket() {
        return this.s3Bucket;
    }

    public final Ec2Instance ec2Instance() {
        return this.ec2Instance;
    }

    public final AccessKey accessKey() {
        return this.accessKey;
    }

    public final Ec2NetworkInterface ec2NetworkInterface() {
        return this.ec2NetworkInterface;
    }

    public final S3Object s3Object() {
        return this.s3Object;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2Instance());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2NetworkInterface());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Object());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceData)) {
            return false;
        }
        ResourceData other = (ResourceData)obj;
        return Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.ec2Instance(), other.ec2Instance()) && Objects.equals(this.accessKey(), other.accessKey()) && Objects.equals(this.ec2NetworkInterface(), other.ec2NetworkInterface()) && Objects.equals(this.s3Object(), other.s3Object());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceData").add("S3Bucket", (Object)this.s3Bucket()).add("Ec2Instance", (Object)this.ec2Instance()).add("AccessKey", (Object)this.accessKey()).add("Ec2NetworkInterface", (Object)this.ec2NetworkInterface()).add("S3Object", (Object)this.s3Object()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "Ec2Instance": {
                return Optional.ofNullable(clazz.cast(this.ec2Instance()));
            }
            case "AccessKey": {
                return Optional.ofNullable(clazz.cast(this.accessKey()));
            }
            case "Ec2NetworkInterface": {
                return Optional.ofNullable(clazz.cast(this.ec2NetworkInterface()));
            }
            case "S3Object": {
                return Optional.ofNullable(clazz.cast(this.s3Object()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("s3Bucket", S3_BUCKET_FIELD);
        map.put("ec2Instance", EC2_INSTANCE_FIELD);
        map.put("accessKey", ACCESS_KEY_FIELD);
        map.put("ec2NetworkInterface", EC2_NETWORK_INTERFACE_FIELD);
        map.put("s3Object", S3_OBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceData, T> g) {
        return obj -> g.apply((ResourceData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3Bucket s3Bucket;
        private Ec2Instance ec2Instance;
        private AccessKey accessKey;
        private Ec2NetworkInterface ec2NetworkInterface;
        private S3Object s3Object;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceData model) {
            this.s3Bucket(model.s3Bucket);
            this.ec2Instance(model.ec2Instance);
            this.accessKey(model.accessKey);
            this.ec2NetworkInterface(model.ec2NetworkInterface);
            this.s3Object(model.s3Object);
        }

        public final S3Bucket.Builder getS3Bucket() {
            return this.s3Bucket != null ? this.s3Bucket.toBuilder() : null;
        }

        public final void setS3Bucket(S3Bucket.BuilderImpl s3Bucket) {
            this.s3Bucket = s3Bucket != null ? s3Bucket.build() : null;
        }

        @Override
        public final Builder s3Bucket(S3Bucket s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final Ec2Instance.Builder getEc2Instance() {
            return this.ec2Instance != null ? this.ec2Instance.toBuilder() : null;
        }

        public final void setEc2Instance(Ec2Instance.BuilderImpl ec2Instance) {
            this.ec2Instance = ec2Instance != null ? ec2Instance.build() : null;
        }

        @Override
        public final Builder ec2Instance(Ec2Instance ec2Instance) {
            this.ec2Instance = ec2Instance;
            return this;
        }

        public final AccessKey.Builder getAccessKey() {
            return this.accessKey != null ? this.accessKey.toBuilder() : null;
        }

        public final void setAccessKey(AccessKey.BuilderImpl accessKey) {
            this.accessKey = accessKey != null ? accessKey.build() : null;
        }

        @Override
        public final Builder accessKey(AccessKey accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public final Ec2NetworkInterface.Builder getEc2NetworkInterface() {
            return this.ec2NetworkInterface != null ? this.ec2NetworkInterface.toBuilder() : null;
        }

        public final void setEc2NetworkInterface(Ec2NetworkInterface.BuilderImpl ec2NetworkInterface) {
            this.ec2NetworkInterface = ec2NetworkInterface != null ? ec2NetworkInterface.build() : null;
        }

        @Override
        public final Builder ec2NetworkInterface(Ec2NetworkInterface ec2NetworkInterface) {
            this.ec2NetworkInterface = ec2NetworkInterface;
            return this;
        }

        public final S3Object.Builder getS3Object() {
            return this.s3Object != null ? this.s3Object.toBuilder() : null;
        }

        public final void setS3Object(S3Object.BuilderImpl s3Object) {
            this.s3Object = s3Object != null ? s3Object.build() : null;
        }

        @Override
        public final Builder s3Object(S3Object s3Object) {
            this.s3Object = s3Object;
            return this;
        }

        public ResourceData build() {
            return new ResourceData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceData> {
        public Builder s3Bucket(S3Bucket var1);

        default public Builder s3Bucket(Consumer<S3Bucket.Builder> s3Bucket) {
            return this.s3Bucket((S3Bucket)((S3Bucket.Builder)S3Bucket.builder().applyMutation(s3Bucket)).build());
        }

        public Builder ec2Instance(Ec2Instance var1);

        default public Builder ec2Instance(Consumer<Ec2Instance.Builder> ec2Instance) {
            return this.ec2Instance((Ec2Instance)((Ec2Instance.Builder)Ec2Instance.builder().applyMutation(ec2Instance)).build());
        }

        public Builder accessKey(AccessKey var1);

        default public Builder accessKey(Consumer<AccessKey.Builder> accessKey) {
            return this.accessKey((AccessKey)((AccessKey.Builder)AccessKey.builder().applyMutation(accessKey)).build());
        }

        public Builder ec2NetworkInterface(Ec2NetworkInterface var1);

        default public Builder ec2NetworkInterface(Consumer<Ec2NetworkInterface.Builder> ec2NetworkInterface) {
            return this.ec2NetworkInterface((Ec2NetworkInterface)((Ec2NetworkInterface.Builder)Ec2NetworkInterface.builder().applyMutation(ec2NetworkInterface)).build());
        }

        public Builder s3Object(S3Object var1);

        default public Builder s3Object(Consumer<S3Object.Builder> s3Object) {
            return this.s3Object((S3Object)((S3Object.Builder)S3Object.builder().applyMutation(s3Object)).build());
        }
    }
}

