/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.EbsSnapshotPreservation;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.services.guardduty.model.ScanResourceCriteria;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMalwareScanSettingsRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, UpdateMalwareScanSettingsRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(UpdateMalwareScanSettingsRequest.getter(UpdateMalwareScanSettingsRequest::detectorId)).setter(UpdateMalwareScanSettingsRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<ScanResourceCriteria> SCAN_RESOURCE_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScanResourceCriteria").getter(UpdateMalwareScanSettingsRequest.getter(UpdateMalwareScanSettingsRequest::scanResourceCriteria)).setter(UpdateMalwareScanSettingsRequest.setter(Builder::scanResourceCriteria)).constructor(ScanResourceCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanResourceCriteria").build()}).build();
    private static final SdkField<String> EBS_SNAPSHOT_PRESERVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EbsSnapshotPreservation").getter(UpdateMalwareScanSettingsRequest.getter(UpdateMalwareScanSettingsRequest::ebsSnapshotPreservationAsString)).setter(UpdateMalwareScanSettingsRequest.setter(Builder::ebsSnapshotPreservation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsSnapshotPreservation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, SCAN_RESOURCE_CRITERIA_FIELD, EBS_SNAPSHOT_PRESERVATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMalwareScanSettingsRequest.memberNameToFieldInitializer();
    private final String detectorId;
    private final ScanResourceCriteria scanResourceCriteria;
    private final String ebsSnapshotPreservation;

    private UpdateMalwareScanSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.scanResourceCriteria = builder.scanResourceCriteria;
        this.ebsSnapshotPreservation = builder.ebsSnapshotPreservation;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final ScanResourceCriteria scanResourceCriteria() {
        return this.scanResourceCriteria;
    }

    public final EbsSnapshotPreservation ebsSnapshotPreservation() {
        return EbsSnapshotPreservation.fromValue(this.ebsSnapshotPreservation);
    }

    public final String ebsSnapshotPreservationAsString() {
        return this.ebsSnapshotPreservation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanResourceCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsSnapshotPreservationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMalwareScanSettingsRequest)) {
            return false;
        }
        UpdateMalwareScanSettingsRequest other = (UpdateMalwareScanSettingsRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.scanResourceCriteria(), other.scanResourceCriteria()) && Objects.equals(this.ebsSnapshotPreservationAsString(), other.ebsSnapshotPreservationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMalwareScanSettingsRequest").add("DetectorId", (Object)this.detectorId()).add("ScanResourceCriteria", (Object)this.scanResourceCriteria()).add("EbsSnapshotPreservation", (Object)this.ebsSnapshotPreservationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "ScanResourceCriteria": {
                return Optional.ofNullable(clazz.cast(this.scanResourceCriteria()));
            }
            case "EbsSnapshotPreservation": {
                return Optional.ofNullable(clazz.cast(this.ebsSnapshotPreservationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("scanResourceCriteria", SCAN_RESOURCE_CRITERIA_FIELD);
        map.put("ebsSnapshotPreservation", EBS_SNAPSHOT_PRESERVATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMalwareScanSettingsRequest, T> g) {
        return obj -> g.apply((UpdateMalwareScanSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private ScanResourceCriteria scanResourceCriteria;
        private String ebsSnapshotPreservation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMalwareScanSettingsRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.scanResourceCriteria(model.scanResourceCriteria);
            this.ebsSnapshotPreservation(model.ebsSnapshotPreservation);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final ScanResourceCriteria.Builder getScanResourceCriteria() {
            return this.scanResourceCriteria != null ? this.scanResourceCriteria.toBuilder() : null;
        }

        public final void setScanResourceCriteria(ScanResourceCriteria.BuilderImpl scanResourceCriteria) {
            this.scanResourceCriteria = scanResourceCriteria != null ? scanResourceCriteria.build() : null;
        }

        @Override
        public final Builder scanResourceCriteria(ScanResourceCriteria scanResourceCriteria) {
            this.scanResourceCriteria = scanResourceCriteria;
            return this;
        }

        public final String getEbsSnapshotPreservation() {
            return this.ebsSnapshotPreservation;
        }

        public final void setEbsSnapshotPreservation(String ebsSnapshotPreservation) {
            this.ebsSnapshotPreservation = ebsSnapshotPreservation;
        }

        @Override
        public final Builder ebsSnapshotPreservation(String ebsSnapshotPreservation) {
            this.ebsSnapshotPreservation = ebsSnapshotPreservation;
            return this;
        }

        @Override
        public final Builder ebsSnapshotPreservation(EbsSnapshotPreservation ebsSnapshotPreservation) {
            this.ebsSnapshotPreservation(ebsSnapshotPreservation == null ? null : ebsSnapshotPreservation.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMalwareScanSettingsRequest build() {
            return new UpdateMalwareScanSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMalwareScanSettingsRequest> {
        public Builder detectorId(String var1);

        public Builder scanResourceCriteria(ScanResourceCriteria var1);

        default public Builder scanResourceCriteria(Consumer<ScanResourceCriteria.Builder> scanResourceCriteria) {
            return this.scanResourceCriteria((ScanResourceCriteria)((ScanResourceCriteria.Builder)ScanResourceCriteria.builder().applyMutation(scanResourceCriteria)).build());
        }

        public Builder ebsSnapshotPreservation(String var1);

        public Builder ebsSnapshotPreservation(EbsSnapshotPreservation var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

