/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyAsyncClient;
import software.amazon.awssdk.services.guardduty.internal.UserAgentUtils;
import software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationResponse;

public class DescribeOrganizationConfigurationPublisher
implements SdkPublisher<DescribeOrganizationConfigurationResponse> {
    private final GuardDutyAsyncClient client;
    private final DescribeOrganizationConfigurationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeOrganizationConfigurationPublisher(GuardDutyAsyncClient client, DescribeOrganizationConfigurationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeOrganizationConfigurationPublisher(GuardDutyAsyncClient client, DescribeOrganizationConfigurationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeOrganizationConfigurationResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeOrganizationConfigurationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeOrganizationConfigurationResponseFetcher
    implements AsyncPageFetcher<DescribeOrganizationConfigurationResponse> {
        private DescribeOrganizationConfigurationResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrganizationConfigurationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeOrganizationConfigurationResponse> nextPage(DescribeOrganizationConfigurationResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrganizationConfigurationPublisher.this.client.describeOrganizationConfiguration(DescribeOrganizationConfigurationPublisher.this.firstRequest);
            }
            return DescribeOrganizationConfigurationPublisher.this.client.describeOrganizationConfiguration((DescribeOrganizationConfigurationRequest)((Object)DescribeOrganizationConfigurationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

