/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyAsyncClient;
import software.amazon.awssdk.services.guardduty.internal.UserAgentUtils;
import software.amazon.awssdk.services.guardduty.model.Invitation;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse;

public class ListInvitationsPublisher
implements SdkPublisher<ListInvitationsResponse> {
    private final GuardDutyAsyncClient client;
    private final ListInvitationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInvitationsPublisher(GuardDutyAsyncClient client, ListInvitationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInvitationsPublisher(GuardDutyAsyncClient client, ListInvitationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInvitationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInvitationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Invitation> invitations() {
        Function<ListInvitationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.invitations() != null) {
                return response.invitations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInvitationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInvitationsResponseFetcher
    implements AsyncPageFetcher<ListInvitationsResponse> {
        private ListInvitationsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvitationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInvitationsResponse> nextPage(ListInvitationsResponse previousPage) {
            if (previousPage == null) {
                return ListInvitationsPublisher.this.client.listInvitations(ListInvitationsPublisher.this.firstRequest);
            }
            return ListInvitationsPublisher.this.client.listInvitations((ListInvitationsRequest)((Object)ListInvitationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

