/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.async;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;

@SdkPublicApi
public final class AsyncExecuteRequest {
    private final SdkHttpRequest request;
    private final SdkHttpContentPublisher requestContentPublisher;
    private final SdkAsyncHttpResponseHandler responseHandler;
    private final boolean isFullDuplex;

    private AsyncExecuteRequest(BuilderImpl builder) {
        this.request = builder.request;
        this.requestContentPublisher = builder.requestContentPublisher;
        this.responseHandler = builder.responseHandler;
        this.isFullDuplex = builder.isFullDuplex;
    }

    public SdkHttpRequest request() {
        return this.request;
    }

    public SdkHttpContentPublisher requestContentPublisher() {
        return this.requestContentPublisher;
    }

    public SdkAsyncHttpResponseHandler responseHandler() {
        return this.responseHandler;
    }

    public boolean fullDuplex() {
        return this.isFullDuplex;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    private static class BuilderImpl
    implements Builder {
        private SdkHttpRequest request;
        private SdkHttpContentPublisher requestContentPublisher;
        private SdkAsyncHttpResponseHandler responseHandler;
        private boolean isFullDuplex;

        private BuilderImpl() {
        }

        @Override
        public Builder request(SdkHttpRequest request) {
            this.request = request;
            return this;
        }

        @Override
        public Builder requestContentPublisher(SdkHttpContentPublisher requestContentPublisher) {
            this.requestContentPublisher = requestContentPublisher;
            return this;
        }

        @Override
        public Builder responseHandler(SdkAsyncHttpResponseHandler responseHandler) {
            this.responseHandler = responseHandler;
            return this;
        }

        @Override
        public Builder fullDuplex(boolean fullDuplex) {
            this.isFullDuplex = fullDuplex;
            return this;
        }

        @Override
        public AsyncExecuteRequest build() {
            return new AsyncExecuteRequest(this);
        }
    }

    public static interface Builder {
        public Builder request(SdkHttpRequest var1);

        public Builder requestContentPublisher(SdkHttpContentPublisher var1);

        public Builder responseHandler(SdkAsyncHttpResponseHandler var1);

        public Builder fullDuplex(boolean var1);

        public AsyncExecuteRequest build();
    }
}

