/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.SummaryKeyType;
import software.amazon.awssdk.services.iam.model._summaryMapTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccountSummaryResponse
extends IamResponse
implements ToCopyableBuilder<Builder, GetAccountSummaryResponse> {
    private static final SdkField<Map<String, Integer>> SUMMARY_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SummaryMap").getter(GetAccountSummaryResponse.getter(GetAccountSummaryResponse::summaryMapAsStrings)).setter(GetAccountSummaryResponse.setter(Builder::summaryMapWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_MAP_FIELD));
    private final Map<String, Integer> summaryMap;

    private GetAccountSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.summaryMap = builder.summaryMap;
    }

    public final Map<SummaryKeyType, Integer> summaryMap() {
        return _summaryMapTypeCopier.copyStringToEnum(this.summaryMap);
    }

    public final boolean hasSummaryMap() {
        return this.summaryMap != null && !(this.summaryMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> summaryMapAsStrings() {
        return this.summaryMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSummaryMap() ? this.summaryMapAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountSummaryResponse)) {
            return false;
        }
        GetAccountSummaryResponse other = (GetAccountSummaryResponse)((Object)obj);
        return this.hasSummaryMap() == other.hasSummaryMap() && Objects.equals(this.summaryMapAsStrings(), other.summaryMapAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccountSummaryResponse").add("SummaryMap", this.hasSummaryMap() ? this.summaryMapAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SummaryMap": {
                return Optional.ofNullable(clazz.cast(this.summaryMapAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccountSummaryResponse, T> g) {
        return obj -> g.apply((GetAccountSummaryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private Map<String, Integer> summaryMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountSummaryResponse model) {
            super(model);
            this.summaryMapWithStrings(model.summaryMap);
        }

        public final Map<String, Integer> getSummaryMap() {
            if (this.summaryMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.summaryMap;
        }

        @Override
        public final Builder summaryMapWithStrings(Map<String, Integer> summaryMap) {
            this.summaryMap = _summaryMapTypeCopier.copy(summaryMap);
            return this;
        }

        @Override
        public final Builder summaryMap(Map<SummaryKeyType, Integer> summaryMap) {
            this.summaryMap = _summaryMapTypeCopier.copyEnumToString(summaryMap);
            return this;
        }

        public final void setSummaryMap(Map<String, Integer> summaryMap) {
            this.summaryMap = _summaryMapTypeCopier.copy(summaryMap);
        }

        @Override
        public GetAccountSummaryResponse build() {
            return new GetAccountSummaryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccountSummaryResponse> {
        public Builder summaryMapWithStrings(Map<String, Integer> var1);

        public Builder summaryMap(Map<SummaryKeyType, Integer> var1);
    }
}

