/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRoleRequest extends IamRequest implements
        ToCopyableBuilder<CreateRoleRequest.Builder, CreateRoleRequest> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(CreateRoleRequest::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleName").getter(getter(CreateRoleRequest::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()).build();

    private static final SdkField<String> ASSUME_ROLE_POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssumeRolePolicyDocument").getter(getter(CreateRoleRequest::assumeRolePolicyDocument))
            .setter(setter(Builder::assumeRolePolicyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssumeRolePolicyDocument").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateRoleRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> MAX_SESSION_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSessionDuration").getter(getter(CreateRoleRequest::maxSessionDuration))
            .setter(setter(Builder::maxSessionDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSessionDuration").build())
            .build();

    private static final SdkField<String> PERMISSIONS_BOUNDARY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionsBoundary").getter(getter(CreateRoleRequest::permissionsBoundary))
            .setter(setter(Builder::permissionsBoundary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundary").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateRoleRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, ROLE_NAME_FIELD,
            ASSUME_ROLE_POLICY_DOCUMENT_FIELD, DESCRIPTION_FIELD, MAX_SESSION_DURATION_FIELD, PERMISSIONS_BOUNDARY_FIELD,
            TAGS_FIELD));

    private final String path;

    private final String roleName;

    private final String assumeRolePolicyDocument;

    private final String description;

    private final Integer maxSessionDuration;

    private final String permissionsBoundary;

    private final List<Tag> tags;

    private CreateRoleRequest(BuilderImpl builder) {
        super(builder);
        this.path = builder.path;
        this.roleName = builder.roleName;
        this.assumeRolePolicyDocument = builder.assumeRolePolicyDocument;
        this.description = builder.description;
        this.maxSessionDuration = builder.maxSessionDuration;
        this.permissionsBoundary = builder.permissionsBoundary;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The path to the role. For more information about paths, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     * <p>
     * This parameter is optional. If it is not included, it defaults to a slash (/).
     * </p>
     * <p>
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
     * characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward
     * slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL
     * character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.
     * </p>
     * 
     * @return The path to the role. For more information about paths, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
     *         <i>IAM User Guide</i>.</p>
     *         <p>
     *         This parameter is optional. If it is not included, it defaults to a slash (/).
     *         </p>
     *         <p>
     *         This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string
     *         of characters consisting of either a forward slash (/) by itself or a string that must begin and end with
     *         forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through
     *         the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and
     *         lowercased letters.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The name of the role to create.
     * </p>
     * <p>
     * IAM user, group, role, and policy names must be unique within the account. Names are not distinguished by case.
     * For example, you cannot create resources named both "MyResource" and "myresource".
     * </p>
     * 
     * @return The name of the role to create.</p>
     *         <p>
     *         IAM user, group, role, and policy names must be unique within the account. Names are not distinguished by
     *         case. For example, you cannot create resources named both "MyResource" and "myresource".
     */
    public final String roleName() {
        return roleName;
    }

    /**
     * <p>
     * The trust relationship policy document that grants an entity permission to assume the role.
     * </p>
     * <p>
     * In IAM, you must provide a JSON policy that has been converted to a string. However, for CloudFormation templates
     * formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML
     * policy to JSON format before submitting it to IAM.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of
     * characters consisting of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII
     * character range
     * </p>
     * </li>
     * <li>
     * <p>
     * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>
     * )
     * </p>
     * </li>
     * </ul>
     * <p>
     * Upon success, the response includes the same trust policy in JSON format.
     * </p>
     * 
     * @return The trust relationship policy document that grants an entity permission to assume the role.</p>
     *         <p>
     *         In IAM, you must provide a JSON policy that has been converted to a string. However, for CloudFormation
     *         templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always
     *         converts a YAML policy to JSON format before submitting it to IAM.
     *         </p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
     *         string of characters consisting of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of
     *         the ASCII character range
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The printable characters in the Basic Latin and Latin-1 Supplement character set (through
     *         <code>\u00FF</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
     *         <code>\u000D</code>)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Upon success, the response includes the same trust policy in JSON format.
     */
    public final String assumeRolePolicyDocument() {
        return assumeRolePolicyDocument;
    }

    /**
     * <p>
     * A description of the role.
     * </p>
     * 
     * @return A description of the role.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The maximum session duration (in seconds) that you want to set for the specified role. If you do not specify a
     * value for this setting, the default value of one hour is applied. This setting can have a value from 1 hour to 12
     * hours.
     * </p>
     * <p>
     * Anyone who assumes the role from the or API can use the <code>DurationSeconds</code> API parameter or the
     * <code>duration-seconds</code> CLI parameter to request a longer session. The <code>MaxSessionDuration</code>
     * setting determines the maximum duration that can be requested using the <code>DurationSeconds</code> parameter.
     * If users don't specify a value for the <code>DurationSeconds</code> parameter, their security credentials are
     * valid for one hour by default. This applies when you use the <code>AssumeRole*</code> API operations or the
     * <code>assume-role*</code> CLI operations but does not apply when you use those operations to create a console
     * URL. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html">Using
     * IAM roles</a> in the <i>IAM User Guide</i>.
     * </p>
     * 
     * @return The maximum session duration (in seconds) that you want to set for the specified role. If you do not
     *         specify a value for this setting, the default value of one hour is applied. This setting can have a value
     *         from 1 hour to 12 hours.</p>
     *         <p>
     *         Anyone who assumes the role from the or API can use the <code>DurationSeconds</code> API parameter or the
     *         <code>duration-seconds</code> CLI parameter to request a longer session. The
     *         <code>MaxSessionDuration</code> setting determines the maximum duration that can be requested using the
     *         <code>DurationSeconds</code> parameter. If users don't specify a value for the
     *         <code>DurationSeconds</code> parameter, their security credentials are valid for one hour by default.
     *         This applies when you use the <code>AssumeRole*</code> API operations or the <code>assume-role*</code>
     *         CLI operations but does not apply when you use those operations to create a console URL. For more
     *         information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html">Using IAM
     *         roles</a> in the <i>IAM User Guide</i>.
     */
    public final Integer maxSessionDuration() {
        return maxSessionDuration;
    }

    /**
     * <p>
     * The ARN of the policy that is used to set the permissions boundary for the role.
     * </p>
     * 
     * @return The ARN of the policy that is used to set the permissions boundary for the role.
     */
    public final String permissionsBoundary() {
        return permissionsBoundary;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags that you want to attach to the new role. Each tag consists of a key name and an associated value.
     * For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <note>
     * <p>
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags that you want to attach to the new role. Each tag consists of a key name and an associated
     *         value. For more information about tagging, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
     *         <i>IAM User Guide</i>.</p> <note>
     *         <p>
     *         If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire
     *         request fails and the resource is not created.
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(assumeRolePolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(maxSessionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoleRequest)) {
            return false;
        }
        CreateRoleRequest other = (CreateRoleRequest) obj;
        return Objects.equals(path(), other.path()) && Objects.equals(roleName(), other.roleName())
                && Objects.equals(assumeRolePolicyDocument(), other.assumeRolePolicyDocument())
                && Objects.equals(description(), other.description())
                && Objects.equals(maxSessionDuration(), other.maxSessionDuration())
                && Objects.equals(permissionsBoundary(), other.permissionsBoundary()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRoleRequest").add("Path", path()).add("RoleName", roleName())
                .add("AssumeRolePolicyDocument", assumeRolePolicyDocument()).add("Description", description())
                .add("MaxSessionDuration", maxSessionDuration()).add("PermissionsBoundary", permissionsBoundary())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "AssumeRolePolicyDocument":
            return Optional.ofNullable(clazz.cast(assumeRolePolicyDocument()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "MaxSessionDuration":
            return Optional.ofNullable(clazz.cast(maxSessionDuration()));
        case "PermissionsBoundary":
            return Optional.ofNullable(clazz.cast(permissionsBoundary()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRoleRequest, T> g) {
        return obj -> g.apply((CreateRoleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRoleRequest> {
        /**
         * <p>
         * The path to the role. For more information about paths, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
         * <i>IAM User Guide</i>.
         * </p>
         * <p>
         * This parameter is optional. If it is not included, it defaults to a slash (/).
         * </p>
         * <p>
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
         * characters consisting of either a forward slash (/) by itself or a string that must begin and end with
         * forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the
         * DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased
         * letters.
         * </p>
         * 
         * @param path
         *        The path to the role. For more information about paths, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in
         *        the <i>IAM User Guide</i>.</p>
         *        <p>
         *        This parameter is optional. If it is not included, it defaults to a slash (/).
         *        </p>
         *        <p>
         *        This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
         *        string of characters consisting of either a forward slash (/) by itself or a string that must begin
         *        and end with forward slashes. In addition, it can contain any ASCII character from the ! (
         *        <code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation
         *        characters, digits, and upper and lowercased letters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The name of the role to create.
         * </p>
         * <p>
         * IAM user, group, role, and policy names must be unique within the account. Names are not distinguished by
         * case. For example, you cannot create resources named both "MyResource" and "myresource".
         * </p>
         * 
         * @param roleName
         *        The name of the role to create.</p>
         *        <p>
         *        IAM user, group, role, and policy names must be unique within the account. Names are not distinguished
         *        by case. For example, you cannot create resources named both "MyResource" and "myresource".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * The trust relationship policy document that grants an entity permission to assume the role.
         * </p>
         * <p>
         * In IAM, you must provide a JSON policy that has been converted to a string. However, for CloudFormation
         * templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always
         * converts a YAML policy to JSON format before submitting it to IAM.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string
         * of characters consisting of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the
         * ASCII character range
         * </p>
         * </li>
         * <li>
         * <p>
         * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
         * )
         * </p>
         * </li>
         * <li>
         * <p>
         * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
         * <code>\u000D</code>)
         * </p>
         * </li>
         * </ul>
         * <p>
         * Upon success, the response includes the same trust policy in JSON format.
         * </p>
         * 
         * @param assumeRolePolicyDocument
         *        The trust relationship policy document that grants an entity permission to assume the role.</p>
         *        <p>
         *        In IAM, you must provide a JSON policy that has been converted to a string. However, for
         *        CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format.
         *        CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.
         *        </p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
         *        string of characters consisting of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end
         *        of the ASCII character range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The printable characters in the Basic Latin and Latin-1 Supplement character set (through
         *        <code>\u00FF</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return
         *        (<code>\u000D</code>)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Upon success, the response includes the same trust policy in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assumeRolePolicyDocument(String assumeRolePolicyDocument);

        /**
         * <p>
         * A description of the role.
         * </p>
         * 
         * @param description
         *        A description of the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The maximum session duration (in seconds) that you want to set for the specified role. If you do not specify
         * a value for this setting, the default value of one hour is applied. This setting can have a value from 1 hour
         * to 12 hours.
         * </p>
         * <p>
         * Anyone who assumes the role from the or API can use the <code>DurationSeconds</code> API parameter or the
         * <code>duration-seconds</code> CLI parameter to request a longer session. The <code>MaxSessionDuration</code>
         * setting determines the maximum duration that can be requested using the <code>DurationSeconds</code>
         * parameter. If users don't specify a value for the <code>DurationSeconds</code> parameter, their security
         * credentials are valid for one hour by default. This applies when you use the <code>AssumeRole*</code> API
         * operations or the <code>assume-role*</code> CLI operations but does not apply when you use those operations
         * to create a console URL. For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html">Using IAM roles</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * 
         * @param maxSessionDuration
         *        The maximum session duration (in seconds) that you want to set for the specified role. If you do not
         *        specify a value for this setting, the default value of one hour is applied. This setting can have a
         *        value from 1 hour to 12 hours.</p>
         *        <p>
         *        Anyone who assumes the role from the or API can use the <code>DurationSeconds</code> API parameter or
         *        the <code>duration-seconds</code> CLI parameter to request a longer session. The
         *        <code>MaxSessionDuration</code> setting determines the maximum duration that can be requested using
         *        the <code>DurationSeconds</code> parameter. If users don't specify a value for the
         *        <code>DurationSeconds</code> parameter, their security credentials are valid for one hour by default.
         *        This applies when you use the <code>AssumeRole*</code> API operations or the <code>assume-role*</code>
         *        CLI operations but does not apply when you use those operations to create a console URL. For more
         *        information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html">Using
         *        IAM roles</a> in the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSessionDuration(Integer maxSessionDuration);

        /**
         * <p>
         * The ARN of the policy that is used to set the permissions boundary for the role.
         * </p>
         * 
         * @param permissionsBoundary
         *        The ARN of the policy that is used to set the permissions boundary for the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsBoundary(String permissionsBoundary);

        /**
         * <p>
         * A list of tags that you want to attach to the new role. Each tag consists of a key name and an associated
         * value. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * <note>
         * <p>
         * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire
         * request fails and the resource is not created.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of tags that you want to attach to the new role. Each tag consists of a key name and an
         *        associated value. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
         *        <i>IAM User Guide</i>.</p> <note>
         *        <p>
         *        If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire
         *        request fails and the resource is not created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags that you want to attach to the new role. Each tag consists of a key name and an associated
         * value. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * <note>
         * <p>
         * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire
         * request fails and the resource is not created.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of tags that you want to attach to the new role. Each tag consists of a key name and an
         *        associated value. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
         *        <i>IAM User Guide</i>.</p> <note>
         *        <p>
         *        If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire
         *        request fails and the resource is not created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags that you want to attach to the new role. Each tag consists of a key name and an associated
         * value. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * <note>
         * <p>
         * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire
         * request fails and the resource is not created.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iam.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iam.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.iam.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.iam.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String path;

        private String roleName;

        private String assumeRolePolicyDocument;

        private String description;

        private Integer maxSessionDuration;

        private String permissionsBoundary;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoleRequest model) {
            super(model);
            path(model.path);
            roleName(model.roleName);
            assumeRolePolicyDocument(model.assumeRolePolicyDocument);
            description(model.description);
            maxSessionDuration(model.maxSessionDuration);
            permissionsBoundary(model.permissionsBoundary);
            tags(model.tags);
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getRoleName() {
            return roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final String getAssumeRolePolicyDocument() {
            return assumeRolePolicyDocument;
        }

        public final void setAssumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
        }

        @Override
        public final Builder assumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getMaxSessionDuration() {
            return maxSessionDuration;
        }

        public final void setMaxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
        }

        @Override
        public final Builder maxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
            return this;
        }

        public final String getPermissionsBoundary() {
            return permissionsBoundary;
        }

        public final void setPermissionsBoundary(String permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
        }

        @Override
        public final Builder permissionsBoundary(String permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = _tagListTypeCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListTypeCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRoleRequest build() {
            return new CreateRoleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
