/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.DelegationPermission;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDelegationRequestRequest
extends IamRequest
implements ToCopyableBuilder<Builder, CreateDelegationRequestRequest> {
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccountId").getter(CreateDelegationRequestRequest.getter(CreateDelegationRequestRequest::ownerAccountId)).setter(CreateDelegationRequestRequest.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateDelegationRequestRequest.getter(CreateDelegationRequestRequest::description)).setter(CreateDelegationRequestRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<DelegationPermission> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Permissions").getter(CreateDelegationRequestRequest.getter(CreateDelegationRequestRequest::permissions)).setter(CreateDelegationRequestRequest.setter(Builder::permissions)).constructor(DelegationPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build()}).build();
    private static final SdkField<String> REQUEST_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestMessage").getter(CreateDelegationRequestRequest.getter(CreateDelegationRequestRequest::requestMessage)).setter(CreateDelegationRequestRequest.setter(Builder::requestMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestMessage").build()}).build();
    private static final SdkField<String> REQUESTOR_WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestorWorkflowId").getter(CreateDelegationRequestRequest.getter(CreateDelegationRequestRequest::requestorWorkflowId)).setter(CreateDelegationRequestRequest.setter(Builder::requestorWorkflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestorWorkflowId").build()}).build();
    private static final SdkField<String> REDIRECT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedirectUrl").getter(CreateDelegationRequestRequest.getter(CreateDelegationRequestRequest::redirectUrl)).setter(CreateDelegationRequestRequest.setter(Builder::redirectUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectUrl").build()}).build();
    private static final SdkField<String> NOTIFICATION_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationChannel").getter(CreateDelegationRequestRequest.getter(CreateDelegationRequestRequest::notificationChannel)).setter(CreateDelegationRequestRequest.setter(Builder::notificationChannel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationChannel").build()}).build();
    private static final SdkField<Integer> SESSION_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionDuration").getter(CreateDelegationRequestRequest.getter(CreateDelegationRequestRequest::sessionDuration)).setter(CreateDelegationRequestRequest.setter(Builder::sessionDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionDuration").build()}).build();
    private static final SdkField<Boolean> ONLY_SEND_BY_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OnlySendByOwner").getter(CreateDelegationRequestRequest.getter(CreateDelegationRequestRequest::onlySendByOwner)).setter(CreateDelegationRequestRequest.setter(Builder::onlySendByOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnlySendByOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ACCOUNT_ID_FIELD, DESCRIPTION_FIELD, PERMISSIONS_FIELD, REQUEST_MESSAGE_FIELD, REQUESTOR_WORKFLOW_ID_FIELD, REDIRECT_URL_FIELD, NOTIFICATION_CHANNEL_FIELD, SESSION_DURATION_FIELD, ONLY_SEND_BY_OWNER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDelegationRequestRequest.memberNameToFieldInitializer();
    private final String ownerAccountId;
    private final String description;
    private final DelegationPermission permissions;
    private final String requestMessage;
    private final String requestorWorkflowId;
    private final String redirectUrl;
    private final String notificationChannel;
    private final Integer sessionDuration;
    private final Boolean onlySendByOwner;

    private CreateDelegationRequestRequest(BuilderImpl builder) {
        super(builder);
        this.ownerAccountId = builder.ownerAccountId;
        this.description = builder.description;
        this.permissions = builder.permissions;
        this.requestMessage = builder.requestMessage;
        this.requestorWorkflowId = builder.requestorWorkflowId;
        this.redirectUrl = builder.redirectUrl;
        this.notificationChannel = builder.notificationChannel;
        this.sessionDuration = builder.sessionDuration;
        this.onlySendByOwner = builder.onlySendByOwner;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final String description() {
        return this.description;
    }

    public final DelegationPermission permissions() {
        return this.permissions;
    }

    public final String requestMessage() {
        return this.requestMessage;
    }

    public final String requestorWorkflowId() {
        return this.requestorWorkflowId;
    }

    public final String redirectUrl() {
        return this.redirectUrl;
    }

    public final String notificationChannel() {
        return this.notificationChannel;
    }

    public final Integer sessionDuration() {
        return this.sessionDuration;
    }

    public final Boolean onlySendByOwner() {
        return this.onlySendByOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestorWorkflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlySendByOwner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDelegationRequestRequest)) {
            return false;
        }
        CreateDelegationRequestRequest other = (CreateDelegationRequestRequest)((Object)obj);
        return Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.requestMessage(), other.requestMessage()) && Objects.equals(this.requestorWorkflowId(), other.requestorWorkflowId()) && Objects.equals(this.redirectUrl(), other.redirectUrl()) && Objects.equals(this.notificationChannel(), other.notificationChannel()) && Objects.equals(this.sessionDuration(), other.sessionDuration()) && Objects.equals(this.onlySendByOwner(), other.onlySendByOwner());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDelegationRequestRequest").add("OwnerAccountId", (Object)this.ownerAccountId()).add("Description", (Object)this.description()).add("Permissions", (Object)this.permissions()).add("RequestMessage", (Object)this.requestMessage()).add("RequestorWorkflowId", (Object)this.requestorWorkflowId()).add("RedirectUrl", (Object)this.redirectUrl()).add("NotificationChannel", (Object)this.notificationChannel()).add("SessionDuration", (Object)this.sessionDuration()).add("OnlySendByOwner", (Object)this.onlySendByOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "RequestMessage": {
                return Optional.ofNullable(clazz.cast(this.requestMessage()));
            }
            case "RequestorWorkflowId": {
                return Optional.ofNullable(clazz.cast(this.requestorWorkflowId()));
            }
            case "RedirectUrl": {
                return Optional.ofNullable(clazz.cast(this.redirectUrl()));
            }
            case "NotificationChannel": {
                return Optional.ofNullable(clazz.cast(this.notificationChannel()));
            }
            case "SessionDuration": {
                return Optional.ofNullable(clazz.cast(this.sessionDuration()));
            }
            case "OnlySendByOwner": {
                return Optional.ofNullable(clazz.cast(this.onlySendByOwner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("RequestMessage", REQUEST_MESSAGE_FIELD);
        map.put("RequestorWorkflowId", REQUESTOR_WORKFLOW_ID_FIELD);
        map.put("RedirectUrl", REDIRECT_URL_FIELD);
        map.put("NotificationChannel", NOTIFICATION_CHANNEL_FIELD);
        map.put("SessionDuration", SESSION_DURATION_FIELD);
        map.put("OnlySendByOwner", ONLY_SEND_BY_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDelegationRequestRequest, T> g) {
        return obj -> g.apply((CreateDelegationRequestRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String ownerAccountId;
        private String description;
        private DelegationPermission permissions;
        private String requestMessage;
        private String requestorWorkflowId;
        private String redirectUrl;
        private String notificationChannel;
        private Integer sessionDuration;
        private Boolean onlySendByOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDelegationRequestRequest model) {
            super(model);
            this.ownerAccountId(model.ownerAccountId);
            this.description(model.description);
            this.permissions(model.permissions);
            this.requestMessage(model.requestMessage);
            this.requestorWorkflowId(model.requestorWorkflowId);
            this.redirectUrl(model.redirectUrl);
            this.notificationChannel(model.notificationChannel);
            this.sessionDuration(model.sessionDuration);
            this.onlySendByOwner(model.onlySendByOwner);
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final DelegationPermission.Builder getPermissions() {
            return this.permissions != null ? this.permissions.toBuilder() : null;
        }

        public final void setPermissions(DelegationPermission.BuilderImpl permissions) {
            this.permissions = permissions != null ? permissions.build() : null;
        }

        @Override
        public final Builder permissions(DelegationPermission permissions) {
            this.permissions = permissions;
            return this;
        }

        public final String getRequestMessage() {
            return this.requestMessage;
        }

        public final void setRequestMessage(String requestMessage) {
            this.requestMessage = requestMessage;
        }

        @Override
        public final Builder requestMessage(String requestMessage) {
            this.requestMessage = requestMessage;
            return this;
        }

        public final String getRequestorWorkflowId() {
            return this.requestorWorkflowId;
        }

        public final void setRequestorWorkflowId(String requestorWorkflowId) {
            this.requestorWorkflowId = requestorWorkflowId;
        }

        @Override
        public final Builder requestorWorkflowId(String requestorWorkflowId) {
            this.requestorWorkflowId = requestorWorkflowId;
            return this;
        }

        public final String getRedirectUrl() {
            return this.redirectUrl;
        }

        public final void setRedirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
        }

        @Override
        public final Builder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public final String getNotificationChannel() {
            return this.notificationChannel;
        }

        public final void setNotificationChannel(String notificationChannel) {
            this.notificationChannel = notificationChannel;
        }

        @Override
        public final Builder notificationChannel(String notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public final Integer getSessionDuration() {
            return this.sessionDuration;
        }

        public final void setSessionDuration(Integer sessionDuration) {
            this.sessionDuration = sessionDuration;
        }

        @Override
        public final Builder sessionDuration(Integer sessionDuration) {
            this.sessionDuration = sessionDuration;
            return this;
        }

        public final Boolean getOnlySendByOwner() {
            return this.onlySendByOwner;
        }

        public final void setOnlySendByOwner(Boolean onlySendByOwner) {
            this.onlySendByOwner = onlySendByOwner;
        }

        @Override
        public final Builder onlySendByOwner(Boolean onlySendByOwner) {
            this.onlySendByOwner = onlySendByOwner;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDelegationRequestRequest build() {
            return new CreateDelegationRequestRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDelegationRequestRequest> {
        public Builder ownerAccountId(String var1);

        public Builder description(String var1);

        public Builder permissions(DelegationPermission var1);

        default public Builder permissions(Consumer<DelegationPermission.Builder> permissions) {
            return this.permissions((DelegationPermission)((DelegationPermission.Builder)DelegationPermission.builder().applyMutation(permissions)).build());
        }

        public Builder requestMessage(String var1);

        public Builder requestorWorkflowId(String var1);

        public Builder redirectUrl(String var1);

        public Builder notificationChannel(String var1);

        public Builder sessionDuration(Integer var1);

        public Builder onlySendByOwner(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

