/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.DelegationRequest;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.PermissionCheckResultType;
import software.amazon.awssdk.services.iam.model.PermissionCheckStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDelegationRequestResponse
extends IamResponse
implements ToCopyableBuilder<Builder, GetDelegationRequestResponse> {
    private static final SdkField<DelegationRequest> DELEGATION_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DelegationRequest").getter(GetDelegationRequestResponse.getter(GetDelegationRequestResponse::delegationRequest)).setter(GetDelegationRequestResponse.setter(Builder::delegationRequest)).constructor(DelegationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationRequest").build()}).build();
    private static final SdkField<String> PERMISSION_CHECK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionCheckStatus").getter(GetDelegationRequestResponse.getter(GetDelegationRequestResponse::permissionCheckStatusAsString)).setter(GetDelegationRequestResponse.setter(Builder::permissionCheckStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionCheckStatus").build()}).build();
    private static final SdkField<String> PERMISSION_CHECK_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionCheckResult").getter(GetDelegationRequestResponse.getter(GetDelegationRequestResponse::permissionCheckResultAsString)).setter(GetDelegationRequestResponse.setter(Builder::permissionCheckResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionCheckResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATION_REQUEST_FIELD, PERMISSION_CHECK_STATUS_FIELD, PERMISSION_CHECK_RESULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDelegationRequestResponse.memberNameToFieldInitializer();
    private final DelegationRequest delegationRequest;
    private final String permissionCheckStatus;
    private final String permissionCheckResult;

    private GetDelegationRequestResponse(BuilderImpl builder) {
        super(builder);
        this.delegationRequest = builder.delegationRequest;
        this.permissionCheckStatus = builder.permissionCheckStatus;
        this.permissionCheckResult = builder.permissionCheckResult;
    }

    public final DelegationRequest delegationRequest() {
        return this.delegationRequest;
    }

    public final PermissionCheckStatusType permissionCheckStatus() {
        return PermissionCheckStatusType.fromValue(this.permissionCheckStatus);
    }

    public final String permissionCheckStatusAsString() {
        return this.permissionCheckStatus;
    }

    public final PermissionCheckResultType permissionCheckResult() {
        return PermissionCheckResultType.fromValue(this.permissionCheckResult);
    }

    public final String permissionCheckResultAsString() {
        return this.permissionCheckResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.delegationRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionCheckStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionCheckResultAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDelegationRequestResponse)) {
            return false;
        }
        GetDelegationRequestResponse other = (GetDelegationRequestResponse)((Object)obj);
        return Objects.equals(this.delegationRequest(), other.delegationRequest()) && Objects.equals(this.permissionCheckStatusAsString(), other.permissionCheckStatusAsString()) && Objects.equals(this.permissionCheckResultAsString(), other.permissionCheckResultAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetDelegationRequestResponse").add("DelegationRequest", (Object)this.delegationRequest()).add("PermissionCheckStatus", (Object)this.permissionCheckStatusAsString()).add("PermissionCheckResult", (Object)this.permissionCheckResultAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DelegationRequest": {
                return Optional.ofNullable(clazz.cast(this.delegationRequest()));
            }
            case "PermissionCheckStatus": {
                return Optional.ofNullable(clazz.cast(this.permissionCheckStatusAsString()));
            }
            case "PermissionCheckResult": {
                return Optional.ofNullable(clazz.cast(this.permissionCheckResultAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DelegationRequest", DELEGATION_REQUEST_FIELD);
        map.put("PermissionCheckStatus", PERMISSION_CHECK_STATUS_FIELD);
        map.put("PermissionCheckResult", PERMISSION_CHECK_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDelegationRequestResponse, T> g) {
        return obj -> g.apply((GetDelegationRequestResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private DelegationRequest delegationRequest;
        private String permissionCheckStatus;
        private String permissionCheckResult;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDelegationRequestResponse model) {
            super(model);
            this.delegationRequest(model.delegationRequest);
            this.permissionCheckStatus(model.permissionCheckStatus);
            this.permissionCheckResult(model.permissionCheckResult);
        }

        public final DelegationRequest.Builder getDelegationRequest() {
            return this.delegationRequest != null ? this.delegationRequest.toBuilder() : null;
        }

        public final void setDelegationRequest(DelegationRequest.BuilderImpl delegationRequest) {
            this.delegationRequest = delegationRequest != null ? delegationRequest.build() : null;
        }

        @Override
        public final Builder delegationRequest(DelegationRequest delegationRequest) {
            this.delegationRequest = delegationRequest;
            return this;
        }

        public final String getPermissionCheckStatus() {
            return this.permissionCheckStatus;
        }

        public final void setPermissionCheckStatus(String permissionCheckStatus) {
            this.permissionCheckStatus = permissionCheckStatus;
        }

        @Override
        public final Builder permissionCheckStatus(String permissionCheckStatus) {
            this.permissionCheckStatus = permissionCheckStatus;
            return this;
        }

        @Override
        public final Builder permissionCheckStatus(PermissionCheckStatusType permissionCheckStatus) {
            this.permissionCheckStatus(permissionCheckStatus == null ? null : permissionCheckStatus.toString());
            return this;
        }

        public final String getPermissionCheckResult() {
            return this.permissionCheckResult;
        }

        public final void setPermissionCheckResult(String permissionCheckResult) {
            this.permissionCheckResult = permissionCheckResult;
        }

        @Override
        public final Builder permissionCheckResult(String permissionCheckResult) {
            this.permissionCheckResult = permissionCheckResult;
            return this;
        }

        @Override
        public final Builder permissionCheckResult(PermissionCheckResultType permissionCheckResult) {
            this.permissionCheckResult(permissionCheckResult == null ? null : permissionCheckResult.toString());
            return this;
        }

        @Override
        public GetDelegationRequestResponse build() {
            return new GetDelegationRequestResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDelegationRequestResponse> {
        public Builder delegationRequest(DelegationRequest var1);

        default public Builder delegationRequest(Consumer<DelegationRequest.Builder> delegationRequest) {
            return this.delegationRequest((DelegationRequest)((DelegationRequest.Builder)DelegationRequest.builder().applyMutation(delegationRequest)).build());
        }

        public Builder permissionCheckStatus(String var1);

        public Builder permissionCheckStatus(PermissionCheckStatusType var1);

        public Builder permissionCheckResult(String var1);

        public Builder permissionCheckResult(PermissionCheckResultType var1);
    }
}

