/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.BatchDescribeArnListCopier;
import software.amazon.awssdk.services.inspector.model.InspectorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAssessmentTemplatesRequest
extends InspectorRequest
implements ToCopyableBuilder<Builder, DescribeAssessmentTemplatesRequest> {
    private static final SdkField<List<String>> ASSESSMENT_TEMPLATE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assessmentTemplateArns").getter(DescribeAssessmentTemplatesRequest.getter(DescribeAssessmentTemplatesRequest::assessmentTemplateArns)).setter(DescribeAssessmentTemplatesRequest.setter(Builder::assessmentTemplateArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTemplateArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TEMPLATE_ARNS_FIELD));
    private final List<String> assessmentTemplateArns;

    private DescribeAssessmentTemplatesRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentTemplateArns = builder.assessmentTemplateArns;
    }

    public boolean hasAssessmentTemplateArns() {
        return this.assessmentTemplateArns != null && !(this.assessmentTemplateArns instanceof SdkAutoConstructList);
    }

    public List<String> assessmentTemplateArns() {
        return this.assessmentTemplateArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessmentTemplateArns() ? this.assessmentTemplateArns() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssessmentTemplatesRequest)) {
            return false;
        }
        DescribeAssessmentTemplatesRequest other = (DescribeAssessmentTemplatesRequest)((Object)obj);
        return this.hasAssessmentTemplateArns() == other.hasAssessmentTemplateArns() && Objects.equals(this.assessmentTemplateArns(), other.assessmentTemplateArns());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAssessmentTemplatesRequest").add("AssessmentTemplateArns", this.hasAssessmentTemplateArns() ? this.assessmentTemplateArns() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentTemplateArns": {
                return Optional.ofNullable(clazz.cast(this.assessmentTemplateArns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssessmentTemplatesRequest, T> g) {
        return obj -> g.apply((DescribeAssessmentTemplatesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorRequest.BuilderImpl
    implements Builder {
        private List<String> assessmentTemplateArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssessmentTemplatesRequest model) {
            super(model);
            this.assessmentTemplateArns(model.assessmentTemplateArns);
        }

        public final Collection<String> getAssessmentTemplateArns() {
            if (this.assessmentTemplateArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assessmentTemplateArns;
        }

        @Override
        public final Builder assessmentTemplateArns(Collection<String> assessmentTemplateArns) {
            this.assessmentTemplateArns = BatchDescribeArnListCopier.copy(assessmentTemplateArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTemplateArns(String ... assessmentTemplateArns) {
            this.assessmentTemplateArns(Arrays.asList(assessmentTemplateArns));
            return this;
        }

        public final void setAssessmentTemplateArns(Collection<String> assessmentTemplateArns) {
            this.assessmentTemplateArns = BatchDescribeArnListCopier.copy(assessmentTemplateArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAssessmentTemplatesRequest build() {
            return new DescribeAssessmentTemplatesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAssessmentTemplatesRequest> {
        public Builder assessmentTemplateArns(Collection<String> var1);

        public Builder assessmentTemplateArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

