/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.AwsJobExponentialRolloutRate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsJobExecutionsRolloutConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsJobExecutionsRolloutConfig> {
    private static final SdkField<Integer> MAXIMUM_PER_MINUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumPerMinute").getter(AwsJobExecutionsRolloutConfig.getter(AwsJobExecutionsRolloutConfig::maximumPerMinute)).setter(AwsJobExecutionsRolloutConfig.setter(Builder::maximumPerMinute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumPerMinute").build()}).build();
    private static final SdkField<AwsJobExponentialRolloutRate> EXPONENTIAL_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("exponentialRate").getter(AwsJobExecutionsRolloutConfig.getter(AwsJobExecutionsRolloutConfig::exponentialRate)).setter(AwsJobExecutionsRolloutConfig.setter(Builder::exponentialRate)).constructor(AwsJobExponentialRolloutRate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exponentialRate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_PER_MINUTE_FIELD, EXPONENTIAL_RATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maximumPerMinute;
    private final AwsJobExponentialRolloutRate exponentialRate;

    private AwsJobExecutionsRolloutConfig(BuilderImpl builder) {
        this.maximumPerMinute = builder.maximumPerMinute;
        this.exponentialRate = builder.exponentialRate;
    }

    public final Integer maximumPerMinute() {
        return this.maximumPerMinute;
    }

    public final AwsJobExponentialRolloutRate exponentialRate() {
        return this.exponentialRate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPerMinute());
        hashCode = 31 * hashCode + Objects.hashCode(this.exponentialRate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsJobExecutionsRolloutConfig)) {
            return false;
        }
        AwsJobExecutionsRolloutConfig other = (AwsJobExecutionsRolloutConfig)obj;
        return Objects.equals(this.maximumPerMinute(), other.maximumPerMinute()) && Objects.equals(this.exponentialRate(), other.exponentialRate());
    }

    public final String toString() {
        return ToString.builder((String)"AwsJobExecutionsRolloutConfig").add("MaximumPerMinute", (Object)this.maximumPerMinute()).add("ExponentialRate", (Object)this.exponentialRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maximumPerMinute": {
                return Optional.ofNullable(clazz.cast(this.maximumPerMinute()));
            }
            case "exponentialRate": {
                return Optional.ofNullable(clazz.cast(this.exponentialRate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsJobExecutionsRolloutConfig, T> g) {
        return obj -> g.apply((AwsJobExecutionsRolloutConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maximumPerMinute;
        private AwsJobExponentialRolloutRate exponentialRate;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsJobExecutionsRolloutConfig model) {
            this.maximumPerMinute(model.maximumPerMinute);
            this.exponentialRate(model.exponentialRate);
        }

        public final Integer getMaximumPerMinute() {
            return this.maximumPerMinute;
        }

        @Override
        public final Builder maximumPerMinute(Integer maximumPerMinute) {
            this.maximumPerMinute = maximumPerMinute;
            return this;
        }

        public final void setMaximumPerMinute(Integer maximumPerMinute) {
            this.maximumPerMinute = maximumPerMinute;
        }

        public final AwsJobExponentialRolloutRate.Builder getExponentialRate() {
            return this.exponentialRate != null ? this.exponentialRate.toBuilder() : null;
        }

        @Override
        public final Builder exponentialRate(AwsJobExponentialRolloutRate exponentialRate) {
            this.exponentialRate = exponentialRate;
            return this;
        }

        public final void setExponentialRate(AwsJobExponentialRolloutRate.BuilderImpl exponentialRate) {
            this.exponentialRate = exponentialRate != null ? exponentialRate.build() : null;
        }

        public AwsJobExecutionsRolloutConfig build() {
            return new AwsJobExecutionsRolloutConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsJobExecutionsRolloutConfig> {
        public Builder maximumPerMinute(Integer var1);

        public Builder exponentialRate(AwsJobExponentialRolloutRate var1);

        default public Builder exponentialRate(Consumer<AwsJobExponentialRolloutRate.Builder> exponentialRate) {
            return this.exponentialRate((AwsJobExponentialRolloutRate)((AwsJobExponentialRolloutRate.Builder)AwsJobExponentialRolloutRate.builder().applyMutation(exponentialRate)).build());
        }
    }
}

