/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.DetailsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobExecutionStatusDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobExecutionStatusDetails> {
    private static final SdkField<Map<String, String>> DETAILS_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("detailsMap").getter(JobExecutionStatusDetails.getter(JobExecutionStatusDetails::detailsMap)).setter(JobExecutionStatusDetails.setter(Builder::detailsMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detailsMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_MAP_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> detailsMap;

    private JobExecutionStatusDetails(BuilderImpl builder) {
        this.detailsMap = builder.detailsMap;
    }

    public final boolean hasDetailsMap() {
        return this.detailsMap != null && !(this.detailsMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> detailsMap() {
        return this.detailsMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetailsMap() ? this.detailsMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionStatusDetails)) {
            return false;
        }
        JobExecutionStatusDetails other = (JobExecutionStatusDetails)obj;
        return this.hasDetailsMap() == other.hasDetailsMap() && Objects.equals(this.detailsMap(), other.detailsMap());
    }

    public final String toString() {
        return ToString.builder((String)"JobExecutionStatusDetails").add("DetailsMap", this.hasDetailsMap() ? this.detailsMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detailsMap": {
                return Optional.ofNullable(clazz.cast(this.detailsMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobExecutionStatusDetails, T> g) {
        return obj -> g.apply((JobExecutionStatusDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> detailsMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionStatusDetails model) {
            this.detailsMap(model.detailsMap);
        }

        public final Map<String, String> getDetailsMap() {
            if (this.detailsMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.detailsMap;
        }

        @Override
        public final Builder detailsMap(Map<String, String> detailsMap) {
            this.detailsMap = DetailsMapCopier.copy(detailsMap);
            return this;
        }

        public final void setDetailsMap(Map<String, String> detailsMap) {
            this.detailsMap = DetailsMapCopier.copy(detailsMap);
        }

        public JobExecutionStatusDetails build() {
            return new JobExecutionStatusDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobExecutionStatusDetails> {
        public Builder detailsMap(Map<String, String> var1);
    }
}

