/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.ReportType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListThingRegistrationTaskReportsRequest
extends IotRequest
implements ToCopyableBuilder<Builder, ListThingRegistrationTaskReportsRequest> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(ListThingRegistrationTaskReportsRequest.getter(ListThingRegistrationTaskReportsRequest::taskId)).setter(ListThingRegistrationTaskReportsRequest.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("taskId").build()}).build();
    private static final SdkField<String> REPORT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportType").getter(ListThingRegistrationTaskReportsRequest.getter(ListThingRegistrationTaskReportsRequest::reportTypeAsString)).setter(ListThingRegistrationTaskReportsRequest.setter(Builder::reportType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("reportType").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListThingRegistrationTaskReportsRequest.getter(ListThingRegistrationTaskReportsRequest::nextToken)).setter(ListThingRegistrationTaskReportsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListThingRegistrationTaskReportsRequest.getter(ListThingRegistrationTaskReportsRequest::maxResults)).setter(ListThingRegistrationTaskReportsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, REPORT_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String taskId;
    private final String reportType;
    private final String nextToken;
    private final Integer maxResults;

    private ListThingRegistrationTaskReportsRequest(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.reportType = builder.reportType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final ReportType reportType() {
        return ReportType.fromValue(this.reportType);
    }

    public final String reportTypeAsString() {
        return this.reportType;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingRegistrationTaskReportsRequest)) {
            return false;
        }
        ListThingRegistrationTaskReportsRequest other = (ListThingRegistrationTaskReportsRequest)((Object)obj);
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.reportTypeAsString(), other.reportTypeAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListThingRegistrationTaskReportsRequest").add("TaskId", (Object)this.taskId()).add("ReportType", (Object)this.reportTypeAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "reportType": {
                return Optional.ofNullable(clazz.cast(this.reportTypeAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListThingRegistrationTaskReportsRequest, T> g) {
        return obj -> g.apply((ListThingRegistrationTaskReportsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String taskId;
        private String reportType;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingRegistrationTaskReportsRequest model) {
            super(model);
            this.taskId(model.taskId);
            this.reportType(model.reportType);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getReportType() {
            return this.reportType;
        }

        @Override
        public final Builder reportType(String reportType) {
            this.reportType = reportType;
            return this;
        }

        @Override
        public final Builder reportType(ReportType reportType) {
            this.reportType(reportType == null ? null : reportType.toString());
            return this;
        }

        public final void setReportType(String reportType) {
            this.reportType = reportType;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListThingRegistrationTaskReportsRequest build() {
            return new ListThingRegistrationTaskReportsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListThingRegistrationTaskReportsRequest> {
        public Builder taskId(String var1);

        public Builder reportType(String var1);

        public Builder reportType(ReportType var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

