/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LogTargetType {
    DEFAULT("DEFAULT"),
    THING_GROUP("THING_GROUP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LogTargetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LogTargetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LogTargetType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LogTargetType> knownValues() {
        return Stream.of(LogTargetType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

