/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AdditionalParameterMapCopier;
import software.amazon.awssdk.services.iot.model.AwsJobAbortConfig;
import software.amazon.awssdk.services.iot.model.AwsJobExecutionsRolloutConfig;
import software.amazon.awssdk.services.iot.model.AwsJobPresignedUrlConfig;
import software.amazon.awssdk.services.iot.model.AwsJobTimeoutConfig;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.OTAUpdateFile;
import software.amazon.awssdk.services.iot.model.OTAUpdateFilesCopier;
import software.amazon.awssdk.services.iot.model.Protocol;
import software.amazon.awssdk.services.iot.model.ProtocolsCopier;
import software.amazon.awssdk.services.iot.model.Tag;
import software.amazon.awssdk.services.iot.model.TagListCopier;
import software.amazon.awssdk.services.iot.model.TargetSelection;
import software.amazon.awssdk.services.iot.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOtaUpdateRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateOtaUpdateRequest> {
    private static final SdkField<String> OTA_UPDATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("otaUpdateId").getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::otaUpdateId)).setter(CreateOtaUpdateRequest.setter(Builder::otaUpdateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("otaUpdateId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::description)).setter(CreateOtaUpdateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targets").getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::targets)).setter(CreateOtaUpdateRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("protocols").getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::protocolsAsStrings)).setter(CreateOtaUpdateRequest.setter(Builder::protocolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetSelection").getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::targetSelectionAsString)).setter(CreateOtaUpdateRequest.setter(Builder::targetSelection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSelection").build()}).build();
    private static final SdkField<AwsJobExecutionsRolloutConfig> AWS_JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsJobExecutionsRolloutConfig").getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::awsJobExecutionsRolloutConfig)).setter(CreateOtaUpdateRequest.setter(Builder::awsJobExecutionsRolloutConfig)).constructor(AwsJobExecutionsRolloutConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsJobExecutionsRolloutConfig").build()}).build();
    private static final SdkField<AwsJobPresignedUrlConfig> AWS_JOB_PRESIGNED_URL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsJobPresignedUrlConfig").getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::awsJobPresignedUrlConfig)).setter(CreateOtaUpdateRequest.setter(Builder::awsJobPresignedUrlConfig)).constructor(AwsJobPresignedUrlConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsJobPresignedUrlConfig").build()}).build();
    private static final SdkField<AwsJobAbortConfig> AWS_JOB_ABORT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsJobAbortConfig").getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::awsJobAbortConfig)).setter(CreateOtaUpdateRequest.setter(Builder::awsJobAbortConfig)).constructor(AwsJobAbortConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsJobAbortConfig").build()}).build();
    private static final SdkField<AwsJobTimeoutConfig> AWS_JOB_TIMEOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsJobTimeoutConfig").getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::awsJobTimeoutConfig)).setter(CreateOtaUpdateRequest.setter(Builder::awsJobTimeoutConfig)).constructor(AwsJobTimeoutConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsJobTimeoutConfig").build()}).build();
    private static final SdkField<List<OTAUpdateFile>> FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("files").getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::files)).setter(CreateOtaUpdateRequest.setter(Builder::files)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OTAUpdateFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::roleArn)).setter(CreateOtaUpdateRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalParameters").getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::additionalParameters)).setter(CreateOtaUpdateRequest.setter(Builder::additionalParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::tags)).setter(CreateOtaUpdateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OTA_UPDATE_ID_FIELD, DESCRIPTION_FIELD, TARGETS_FIELD, PROTOCOLS_FIELD, TARGET_SELECTION_FIELD, AWS_JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD, AWS_JOB_PRESIGNED_URL_CONFIG_FIELD, AWS_JOB_ABORT_CONFIG_FIELD, AWS_JOB_TIMEOUT_CONFIG_FIELD, FILES_FIELD, ROLE_ARN_FIELD, ADDITIONAL_PARAMETERS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateOtaUpdateRequest.memberNameToFieldInitializer();
    private final String otaUpdateId;
    private final String description;
    private final List<String> targets;
    private final List<String> protocols;
    private final String targetSelection;
    private final AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig;
    private final AwsJobPresignedUrlConfig awsJobPresignedUrlConfig;
    private final AwsJobAbortConfig awsJobAbortConfig;
    private final AwsJobTimeoutConfig awsJobTimeoutConfig;
    private final List<OTAUpdateFile> files;
    private final String roleArn;
    private final Map<String, String> additionalParameters;
    private final List<Tag> tags;

    private CreateOtaUpdateRequest(BuilderImpl builder) {
        super(builder);
        this.otaUpdateId = builder.otaUpdateId;
        this.description = builder.description;
        this.targets = builder.targets;
        this.protocols = builder.protocols;
        this.targetSelection = builder.targetSelection;
        this.awsJobExecutionsRolloutConfig = builder.awsJobExecutionsRolloutConfig;
        this.awsJobPresignedUrlConfig = builder.awsJobPresignedUrlConfig;
        this.awsJobAbortConfig = builder.awsJobAbortConfig;
        this.awsJobTimeoutConfig = builder.awsJobTimeoutConfig;
        this.files = builder.files;
        this.roleArn = builder.roleArn;
        this.additionalParameters = builder.additionalParameters;
        this.tags = builder.tags;
    }

    public final String otaUpdateId() {
        return this.otaUpdateId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<String> targets() {
        return this.targets;
    }

    public final List<Protocol> protocols() {
        return ProtocolsCopier.copyStringToEnum(this.protocols);
    }

    public final boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public final List<String> protocolsAsStrings() {
        return this.protocols;
    }

    public final TargetSelection targetSelection() {
        return TargetSelection.fromValue(this.targetSelection);
    }

    public final String targetSelectionAsString() {
        return this.targetSelection;
    }

    public final AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig() {
        return this.awsJobExecutionsRolloutConfig;
    }

    public final AwsJobPresignedUrlConfig awsJobPresignedUrlConfig() {
        return this.awsJobPresignedUrlConfig;
    }

    public final AwsJobAbortConfig awsJobAbortConfig() {
        return this.awsJobAbortConfig;
    }

    public final AwsJobTimeoutConfig awsJobTimeoutConfig() {
        return this.awsJobTimeoutConfig;
    }

    public final boolean hasFiles() {
        return this.files != null && !(this.files instanceof SdkAutoConstructList);
    }

    public final List<OTAUpdateFile> files() {
        return this.files;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasAdditionalParameters() {
        return this.additionalParameters != null && !(this.additionalParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalParameters() {
        return this.additionalParameters;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.otaUpdateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocolsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsJobExecutionsRolloutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsJobPresignedUrlConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsJobAbortConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsJobTimeoutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFiles() ? this.files() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalParameters() ? this.additionalParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOtaUpdateRequest)) {
            return false;
        }
        CreateOtaUpdateRequest other = (CreateOtaUpdateRequest)((Object)obj);
        return Objects.equals(this.otaUpdateId(), other.otaUpdateId()) && Objects.equals(this.description(), other.description()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocolsAsStrings(), other.protocolsAsStrings()) && Objects.equals(this.targetSelectionAsString(), other.targetSelectionAsString()) && Objects.equals(this.awsJobExecutionsRolloutConfig(), other.awsJobExecutionsRolloutConfig()) && Objects.equals(this.awsJobPresignedUrlConfig(), other.awsJobPresignedUrlConfig()) && Objects.equals(this.awsJobAbortConfig(), other.awsJobAbortConfig()) && Objects.equals(this.awsJobTimeoutConfig(), other.awsJobTimeoutConfig()) && this.hasFiles() == other.hasFiles() && Objects.equals(this.files(), other.files()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasAdditionalParameters() == other.hasAdditionalParameters() && Objects.equals(this.additionalParameters(), other.additionalParameters()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOtaUpdateRequest").add("OtaUpdateId", (Object)this.otaUpdateId()).add("Description", (Object)this.description()).add("Targets", this.hasTargets() ? this.targets() : null).add("Protocols", this.hasProtocols() ? this.protocolsAsStrings() : null).add("TargetSelection", (Object)this.targetSelectionAsString()).add("AwsJobExecutionsRolloutConfig", (Object)this.awsJobExecutionsRolloutConfig()).add("AwsJobPresignedUrlConfig", (Object)this.awsJobPresignedUrlConfig()).add("AwsJobAbortConfig", (Object)this.awsJobAbortConfig()).add("AwsJobTimeoutConfig", (Object)this.awsJobTimeoutConfig()).add("Files", this.hasFiles() ? this.files() : null).add("RoleArn", (Object)this.roleArn()).add("AdditionalParameters", this.hasAdditionalParameters() ? this.additionalParameters() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "otaUpdateId": {
                return Optional.ofNullable(clazz.cast(this.otaUpdateId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "protocols": {
                return Optional.ofNullable(clazz.cast(this.protocolsAsStrings()));
            }
            case "targetSelection": {
                return Optional.ofNullable(clazz.cast(this.targetSelectionAsString()));
            }
            case "awsJobExecutionsRolloutConfig": {
                return Optional.ofNullable(clazz.cast(this.awsJobExecutionsRolloutConfig()));
            }
            case "awsJobPresignedUrlConfig": {
                return Optional.ofNullable(clazz.cast(this.awsJobPresignedUrlConfig()));
            }
            case "awsJobAbortConfig": {
                return Optional.ofNullable(clazz.cast(this.awsJobAbortConfig()));
            }
            case "awsJobTimeoutConfig": {
                return Optional.ofNullable(clazz.cast(this.awsJobTimeoutConfig()));
            }
            case "files": {
                return Optional.ofNullable(clazz.cast(this.files()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "additionalParameters": {
                return Optional.ofNullable(clazz.cast(this.additionalParameters()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("otaUpdateId", OTA_UPDATE_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("targets", TARGETS_FIELD);
        map.put("protocols", PROTOCOLS_FIELD);
        map.put("targetSelection", TARGET_SELECTION_FIELD);
        map.put("awsJobExecutionsRolloutConfig", AWS_JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD);
        map.put("awsJobPresignedUrlConfig", AWS_JOB_PRESIGNED_URL_CONFIG_FIELD);
        map.put("awsJobAbortConfig", AWS_JOB_ABORT_CONFIG_FIELD);
        map.put("awsJobTimeoutConfig", AWS_JOB_TIMEOUT_CONFIG_FIELD);
        map.put("files", FILES_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("additionalParameters", ADDITIONAL_PARAMETERS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOtaUpdateRequest, T> g) {
        return obj -> g.apply((CreateOtaUpdateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String otaUpdateId;
        private String description;
        private List<String> targets = DefaultSdkAutoConstructList.getInstance();
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();
        private String targetSelection;
        private AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig;
        private AwsJobPresignedUrlConfig awsJobPresignedUrlConfig;
        private AwsJobAbortConfig awsJobAbortConfig;
        private AwsJobTimeoutConfig awsJobTimeoutConfig;
        private List<OTAUpdateFile> files = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private Map<String, String> additionalParameters = DefaultSdkAutoConstructMap.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOtaUpdateRequest model) {
            super(model);
            this.otaUpdateId(model.otaUpdateId);
            this.description(model.description);
            this.targets(model.targets);
            this.protocolsWithStrings(model.protocols);
            this.targetSelection(model.targetSelection);
            this.awsJobExecutionsRolloutConfig(model.awsJobExecutionsRolloutConfig);
            this.awsJobPresignedUrlConfig(model.awsJobPresignedUrlConfig);
            this.awsJobAbortConfig(model.awsJobAbortConfig);
            this.awsJobTimeoutConfig(model.awsJobTimeoutConfig);
            this.files(model.files);
            this.roleArn(model.roleArn);
            this.additionalParameters(model.additionalParameters);
            this.tags(model.tags);
        }

        public final String getOtaUpdateId() {
            return this.otaUpdateId;
        }

        public final void setOtaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
        }

        @Override
        public final Builder otaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getTargets() {
            if (this.targets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targets;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = TargetsCopier.copy(targets);
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final Collection<String> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ProtocolsCopier.copy(protocols);
        }

        @Override
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = ProtocolsCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsWithStrings(String ... protocols) {
            this.protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        public final Builder protocols(Collection<Protocol> protocols) {
            this.protocols = ProtocolsCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(Protocol ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        public final String getTargetSelection() {
            return this.targetSelection;
        }

        public final void setTargetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
        }

        @Override
        public final Builder targetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
            return this;
        }

        @Override
        public final Builder targetSelection(TargetSelection targetSelection) {
            this.targetSelection(targetSelection == null ? null : targetSelection.toString());
            return this;
        }

        public final AwsJobExecutionsRolloutConfig.Builder getAwsJobExecutionsRolloutConfig() {
            return this.awsJobExecutionsRolloutConfig != null ? this.awsJobExecutionsRolloutConfig.toBuilder() : null;
        }

        public final void setAwsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig.BuilderImpl awsJobExecutionsRolloutConfig) {
            this.awsJobExecutionsRolloutConfig = awsJobExecutionsRolloutConfig != null ? awsJobExecutionsRolloutConfig.build() : null;
        }

        @Override
        public final Builder awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig) {
            this.awsJobExecutionsRolloutConfig = awsJobExecutionsRolloutConfig;
            return this;
        }

        public final AwsJobPresignedUrlConfig.Builder getAwsJobPresignedUrlConfig() {
            return this.awsJobPresignedUrlConfig != null ? this.awsJobPresignedUrlConfig.toBuilder() : null;
        }

        public final void setAwsJobPresignedUrlConfig(AwsJobPresignedUrlConfig.BuilderImpl awsJobPresignedUrlConfig) {
            this.awsJobPresignedUrlConfig = awsJobPresignedUrlConfig != null ? awsJobPresignedUrlConfig.build() : null;
        }

        @Override
        public final Builder awsJobPresignedUrlConfig(AwsJobPresignedUrlConfig awsJobPresignedUrlConfig) {
            this.awsJobPresignedUrlConfig = awsJobPresignedUrlConfig;
            return this;
        }

        public final AwsJobAbortConfig.Builder getAwsJobAbortConfig() {
            return this.awsJobAbortConfig != null ? this.awsJobAbortConfig.toBuilder() : null;
        }

        public final void setAwsJobAbortConfig(AwsJobAbortConfig.BuilderImpl awsJobAbortConfig) {
            this.awsJobAbortConfig = awsJobAbortConfig != null ? awsJobAbortConfig.build() : null;
        }

        @Override
        public final Builder awsJobAbortConfig(AwsJobAbortConfig awsJobAbortConfig) {
            this.awsJobAbortConfig = awsJobAbortConfig;
            return this;
        }

        public final AwsJobTimeoutConfig.Builder getAwsJobTimeoutConfig() {
            return this.awsJobTimeoutConfig != null ? this.awsJobTimeoutConfig.toBuilder() : null;
        }

        public final void setAwsJobTimeoutConfig(AwsJobTimeoutConfig.BuilderImpl awsJobTimeoutConfig) {
            this.awsJobTimeoutConfig = awsJobTimeoutConfig != null ? awsJobTimeoutConfig.build() : null;
        }

        @Override
        public final Builder awsJobTimeoutConfig(AwsJobTimeoutConfig awsJobTimeoutConfig) {
            this.awsJobTimeoutConfig = awsJobTimeoutConfig;
            return this;
        }

        public final List<OTAUpdateFile.Builder> getFiles() {
            List<OTAUpdateFile.Builder> result = OTAUpdateFilesCopier.copyToBuilder(this.files);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiles(Collection<OTAUpdateFile.BuilderImpl> files) {
            this.files = OTAUpdateFilesCopier.copyFromBuilder(files);
        }

        @Override
        public final Builder files(Collection<OTAUpdateFile> files) {
            this.files = OTAUpdateFilesCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(OTAUpdateFile ... files) {
            this.files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<OTAUpdateFile.Builder> ... files) {
            this.files(Stream.of(files).map(c -> (OTAUpdateFile)((OTAUpdateFile.Builder)OTAUpdateFile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getAdditionalParameters() {
            if (this.additionalParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalParameters;
        }

        public final void setAdditionalParameters(Map<String, String> additionalParameters) {
            this.additionalParameters = AdditionalParameterMapCopier.copy(additionalParameters);
        }

        @Override
        public final Builder additionalParameters(Map<String, String> additionalParameters) {
            this.additionalParameters = AdditionalParameterMapCopier.copy(additionalParameters);
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOtaUpdateRequest build() {
            return new CreateOtaUpdateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOtaUpdateRequest> {
        public Builder otaUpdateId(String var1);

        public Builder description(String var1);

        public Builder targets(Collection<String> var1);

        public Builder targets(String ... var1);

        public Builder protocolsWithStrings(Collection<String> var1);

        public Builder protocolsWithStrings(String ... var1);

        public Builder protocols(Collection<Protocol> var1);

        public Builder protocols(Protocol ... var1);

        public Builder targetSelection(String var1);

        public Builder targetSelection(TargetSelection var1);

        public Builder awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig var1);

        default public Builder awsJobExecutionsRolloutConfig(Consumer<AwsJobExecutionsRolloutConfig.Builder> awsJobExecutionsRolloutConfig) {
            return this.awsJobExecutionsRolloutConfig((AwsJobExecutionsRolloutConfig)((AwsJobExecutionsRolloutConfig.Builder)AwsJobExecutionsRolloutConfig.builder().applyMutation(awsJobExecutionsRolloutConfig)).build());
        }

        public Builder awsJobPresignedUrlConfig(AwsJobPresignedUrlConfig var1);

        default public Builder awsJobPresignedUrlConfig(Consumer<AwsJobPresignedUrlConfig.Builder> awsJobPresignedUrlConfig) {
            return this.awsJobPresignedUrlConfig((AwsJobPresignedUrlConfig)((AwsJobPresignedUrlConfig.Builder)AwsJobPresignedUrlConfig.builder().applyMutation(awsJobPresignedUrlConfig)).build());
        }

        public Builder awsJobAbortConfig(AwsJobAbortConfig var1);

        default public Builder awsJobAbortConfig(Consumer<AwsJobAbortConfig.Builder> awsJobAbortConfig) {
            return this.awsJobAbortConfig((AwsJobAbortConfig)((AwsJobAbortConfig.Builder)AwsJobAbortConfig.builder().applyMutation(awsJobAbortConfig)).build());
        }

        public Builder awsJobTimeoutConfig(AwsJobTimeoutConfig var1);

        default public Builder awsJobTimeoutConfig(Consumer<AwsJobTimeoutConfig.Builder> awsJobTimeoutConfig) {
            return this.awsJobTimeoutConfig((AwsJobTimeoutConfig)((AwsJobTimeoutConfig.Builder)AwsJobTimeoutConfig.builder().applyMutation(awsJobTimeoutConfig)).build());
        }

        public Builder files(Collection<OTAUpdateFile> var1);

        public Builder files(OTAUpdateFile ... var1);

        public Builder files(Consumer<OTAUpdateFile.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder additionalParameters(Map<String, String> var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

