/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.DisconnectReasonValue;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetThingConnectivityDataResponse
extends IotResponse
implements ToCopyableBuilder<Builder, GetThingConnectivityDataResponse> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(GetThingConnectivityDataResponse.getter(GetThingConnectivityDataResponse::thingName)).setter(GetThingConnectivityDataResponse.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()}).build();
    private static final SdkField<Boolean> CONNECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("connected").getter(GetThingConnectivityDataResponse.getter(GetThingConnectivityDataResponse::connected)).setter(GetThingConnectivityDataResponse.setter(Builder::connected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connected").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestamp").getter(GetThingConnectivityDataResponse.getter(GetThingConnectivityDataResponse::timestamp)).setter(GetThingConnectivityDataResponse.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<String> DISCONNECT_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("disconnectReason").getter(GetThingConnectivityDataResponse.getter(GetThingConnectivityDataResponse::disconnectReasonAsString)).setter(GetThingConnectivityDataResponse.setter(Builder::disconnectReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disconnectReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD, CONNECTED_FIELD, TIMESTAMP_FIELD, DISCONNECT_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetThingConnectivityDataResponse.memberNameToFieldInitializer();
    private final String thingName;
    private final Boolean connected;
    private final Instant timestamp;
    private final String disconnectReason;

    private GetThingConnectivityDataResponse(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.connected = builder.connected;
        this.timestamp = builder.timestamp;
        this.disconnectReason = builder.disconnectReason;
    }

    public final String thingName() {
        return this.thingName;
    }

    public final Boolean connected() {
        return this.connected;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final DisconnectReasonValue disconnectReason() {
        return DisconnectReasonValue.fromValue(this.disconnectReason);
    }

    public final String disconnectReasonAsString() {
        return this.disconnectReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connected());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.disconnectReasonAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetThingConnectivityDataResponse)) {
            return false;
        }
        GetThingConnectivityDataResponse other = (GetThingConnectivityDataResponse)((Object)obj);
        return Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.connected(), other.connected()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.disconnectReasonAsString(), other.disconnectReasonAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetThingConnectivityDataResponse").add("ThingName", (Object)(this.thingName() == null ? null : "*** Sensitive Data Redacted ***")).add("Connected", (Object)this.connected()).add("Timestamp", (Object)this.timestamp()).add("DisconnectReason", (Object)this.disconnectReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "connected": {
                return Optional.ofNullable(clazz.cast(this.connected()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "disconnectReason": {
                return Optional.ofNullable(clazz.cast(this.disconnectReasonAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("thingName", THING_NAME_FIELD);
        map.put("connected", CONNECTED_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("disconnectReason", DISCONNECT_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetThingConnectivityDataResponse, T> g) {
        return obj -> g.apply((GetThingConnectivityDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String thingName;
        private Boolean connected;
        private Instant timestamp;
        private String disconnectReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetThingConnectivityDataResponse model) {
            super(model);
            this.thingName(model.thingName);
            this.connected(model.connected);
            this.timestamp(model.timestamp);
            this.disconnectReason(model.disconnectReason);
        }

        public final String getThingName() {
            return this.thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final Boolean getConnected() {
            return this.connected;
        }

        public final void setConnected(Boolean connected) {
            this.connected = connected;
        }

        @Override
        public final Builder connected(Boolean connected) {
            this.connected = connected;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getDisconnectReason() {
            return this.disconnectReason;
        }

        public final void setDisconnectReason(String disconnectReason) {
            this.disconnectReason = disconnectReason;
        }

        @Override
        public final Builder disconnectReason(String disconnectReason) {
            this.disconnectReason = disconnectReason;
            return this;
        }

        @Override
        public final Builder disconnectReason(DisconnectReasonValue disconnectReason) {
            this.disconnectReason(disconnectReason == null ? null : disconnectReason.toString());
            return this;
        }

        @Override
        public GetThingConnectivityDataResponse build() {
            return new GetThingConnectivityDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetThingConnectivityDataResponse> {
        public Builder thingName(String var1);

        public Builder connected(Boolean var1);

        public Builder timestamp(Instant var1);

        public Builder disconnectReason(String var1);

        public Builder disconnectReason(DisconnectReasonValue var1);
    }
}

