/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest;
import software.amazon.awssdk.services.iot.model.ListAttachedPoliciesResponse;
import software.amazon.awssdk.services.iot.model.Policy;

public class ListAttachedPoliciesIterable
implements SdkIterable<ListAttachedPoliciesResponse> {
    private final IotClient client;
    private final ListAttachedPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAttachedPoliciesIterable(IotClient client, ListAttachedPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAttachedPoliciesResponseFetcher();
    }

    public Iterator<ListAttachedPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Policy> policies() {
        Function<ListAttachedPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policies() != null) {
                return response.policies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAttachedPoliciesResponseFetcher
    implements SyncPageFetcher<ListAttachedPoliciesResponse> {
        private ListAttachedPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListAttachedPoliciesResponse nextPage(ListAttachedPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedPoliciesIterable.this.client.listAttachedPolicies(ListAttachedPoliciesIterable.this.firstRequest);
            }
            return ListAttachedPoliciesIterable.this.client.listAttachedPolicies((ListAttachedPoliciesRequest)((Object)ListAttachedPoliciesIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

