/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesResponse;
import software.amazon.awssdk.services.iot.model.OutgoingCertificate;

public class ListOutgoingCertificatesIterable
implements SdkIterable<ListOutgoingCertificatesResponse> {
    private final IotClient client;
    private final ListOutgoingCertificatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOutgoingCertificatesIterable(IotClient client, ListOutgoingCertificatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOutgoingCertificatesResponseFetcher();
    }

    public Iterator<ListOutgoingCertificatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OutgoingCertificate> outgoingCertificates() {
        Function<ListOutgoingCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.outgoingCertificates() != null) {
                return response.outgoingCertificates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOutgoingCertificatesResponseFetcher
    implements SyncPageFetcher<ListOutgoingCertificatesResponse> {
        private ListOutgoingCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(ListOutgoingCertificatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListOutgoingCertificatesResponse nextPage(ListOutgoingCertificatesResponse previousPage) {
            if (previousPage == null) {
                return ListOutgoingCertificatesIterable.this.client.listOutgoingCertificates(ListOutgoingCertificatesIterable.this.firstRequest);
            }
            return ListOutgoingCertificatesIterable.this.client.listOutgoingCertificates((ListOutgoingCertificatesRequest)((Object)ListOutgoingCertificatesIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

