/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsV2Request;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsV2Response;
import software.amazon.awssdk.services.iot.model.PrincipalThingObject;

public class ListPrincipalThingsV2Publisher
implements SdkPublisher<ListPrincipalThingsV2Response> {
    private final IotAsyncClient client;
    private final ListPrincipalThingsV2Request firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPrincipalThingsV2Publisher(IotAsyncClient client, ListPrincipalThingsV2Request firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPrincipalThingsV2Publisher(IotAsyncClient client, ListPrincipalThingsV2Request firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPrincipalThingsV2ResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPrincipalThingsV2Response> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PrincipalThingObject> principalThingObjects() {
        Function<ListPrincipalThingsV2Response, Iterator> getIterator = response -> {
            if (response != null && response.principalThingObjects() != null) {
                return response.principalThingObjects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPrincipalThingsV2ResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPrincipalThingsV2ResponseFetcher
    implements AsyncPageFetcher<ListPrincipalThingsV2Response> {
        private ListPrincipalThingsV2ResponseFetcher() {
        }

        public boolean hasNextPage(ListPrincipalThingsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPrincipalThingsV2Response> nextPage(ListPrincipalThingsV2Response previousPage) {
            if (previousPage == null) {
                return ListPrincipalThingsV2Publisher.this.client.listPrincipalThingsV2(ListPrincipalThingsV2Publisher.this.firstRequest);
            }
            return ListPrincipalThingsV2Publisher.this.client.listPrincipalThingsV2((ListPrincipalThingsV2Request)((Object)ListPrincipalThingsV2Publisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

