/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickdevices.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot1clickdevices.model.Device;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceEvent> {
    private static final SdkField<Device> DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeviceEvent.getter(DeviceEvent::device)).setter(DeviceEvent.setter(Builder::device)).constructor(Device::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("device").build()}).build();
    private static final SdkField<String> STD_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceEvent.getter(DeviceEvent::stdEvent)).setter(DeviceEvent.setter(Builder::stdEvent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stdEvent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FIELD, STD_EVENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Device device;
    private final String stdEvent;

    private DeviceEvent(BuilderImpl builder) {
        this.device = builder.device;
        this.stdEvent = builder.stdEvent;
    }

    public Device device() {
        return this.device;
    }

    public String stdEvent() {
        return this.stdEvent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.device());
        hashCode = 31 * hashCode + Objects.hashCode(this.stdEvent());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceEvent)) {
            return false;
        }
        DeviceEvent other = (DeviceEvent)obj;
        return Objects.equals(this.device(), other.device()) && Objects.equals(this.stdEvent(), other.stdEvent());
    }

    public String toString() {
        return ToString.builder((String)"DeviceEvent").add("Device", (Object)this.device()).add("StdEvent", (Object)this.stdEvent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Device": {
                return Optional.ofNullable(clazz.cast(this.device()));
            }
            case "StdEvent": {
                return Optional.ofNullable(clazz.cast(this.stdEvent()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceEvent, T> g) {
        return obj -> g.apply((DeviceEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Device device;
        private String stdEvent;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceEvent model) {
            this.device(model.device);
            this.stdEvent(model.stdEvent);
        }

        public final Device.Builder getDevice() {
            return this.device != null ? this.device.toBuilder() : null;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        public final String getStdEvent() {
            return this.stdEvent;
        }

        @Override
        public final Builder stdEvent(String stdEvent) {
            this.stdEvent = stdEvent;
            return this;
        }

        public final void setStdEvent(String stdEvent) {
            this.stdEvent = stdEvent;
        }

        public DeviceEvent build() {
            return new DeviceEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceEvent> {
        public Builder device(Device var1);

        default public Builder device(Consumer<Device.Builder> device) {
            return this.device((Device)((Device.Builder)Device.builder().applyMutation(device)).build());
        }

        public Builder stdEvent(String var1);
    }
}

