/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use this to store channel data in an S3 bucket that you manage. If customer managed storage is selected, the
 * "retentionPeriod" parameter is ignored. The choice of service-managed or customer-managed S3 storage cannot be
 * changed after creation of the channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerManagedChannelS3Storage implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomerManagedChannelS3Storage.Builder, CustomerManagedChannelS3Storage> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CustomerManagedChannelS3Storage::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucket").build()).build();

    private static final SdkField<String> KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CustomerManagedChannelS3Storage::keyPrefix)).setter(setter(Builder::keyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPrefix").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CustomerManagedChannelS3Storage::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD,
            KEY_PREFIX_FIELD, ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final String keyPrefix;

    private final String roleArn;

    private CustomerManagedChannelS3Storage(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.keyPrefix = builder.keyPrefix;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket in which channel data is stored.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket in which channel data is stored.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * [Optional] The prefix used to create the keys of the channel data objects. Each object in an Amazon S3 bucket has
     * a key that is its unique identifier within the bucket (each object in a bucket has exactly one key). The prefix
     * must end with a '/'.
     * </p>
     * 
     * @return [Optional] The prefix used to create the keys of the channel data objects. Each object in an Amazon S3
     *         bucket has a key that is its unique identifier within the bucket (each object in a bucket has exactly one
     *         key). The prefix must end with a '/'.
     */
    public String keyPrefix() {
        return keyPrefix;
    }

    /**
     * <p>
     * The ARN of the role which grants AWS IoT Analytics permission to interact with your Amazon S3 resources.
     * </p>
     * 
     * @return The ARN of the role which grants AWS IoT Analytics permission to interact with your Amazon S3 resources.
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(keyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerManagedChannelS3Storage)) {
            return false;
        }
        CustomerManagedChannelS3Storage other = (CustomerManagedChannelS3Storage) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(keyPrefix(), other.keyPrefix())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CustomerManagedChannelS3Storage").add("Bucket", bucket()).add("KeyPrefix", keyPrefix())
                .add("RoleArn", roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "keyPrefix":
            return Optional.ofNullable(clazz.cast(keyPrefix()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomerManagedChannelS3Storage, T> g) {
        return obj -> g.apply((CustomerManagedChannelS3Storage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerManagedChannelS3Storage> {
        /**
         * <p>
         * The name of the Amazon S3 bucket in which channel data is stored.
         * </p>
         * 
         * @param bucket
         *        The name of the Amazon S3 bucket in which channel data is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * [Optional] The prefix used to create the keys of the channel data objects. Each object in an Amazon S3 bucket
         * has a key that is its unique identifier within the bucket (each object in a bucket has exactly one key). The
         * prefix must end with a '/'.
         * </p>
         * 
         * @param keyPrefix
         *        [Optional] The prefix used to create the keys of the channel data objects. Each object in an Amazon S3
         *        bucket has a key that is its unique identifier within the bucket (each object in a bucket has exactly
         *        one key). The prefix must end with a '/'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPrefix(String keyPrefix);

        /**
         * <p>
         * The ARN of the role which grants AWS IoT Analytics permission to interact with your Amazon S3 resources.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role which grants AWS IoT Analytics permission to interact with your Amazon S3
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String keyPrefix;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerManagedChannelS3Storage model) {
            bucket(model.bucket);
            keyPrefix(model.keyPrefix);
            roleArn(model.roleArn);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKeyPrefix() {
            return keyPrefix;
        }

        @Override
        public final Builder keyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public final void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public CustomerManagedChannelS3Storage build() {
            return new CustomerManagedChannelS3Storage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
