/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of information about a data set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetSummary implements SdkPojo, Serializable, ToCopyableBuilder<DatasetSummary.Builder, DatasetSummary> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DatasetSummary::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DatasetSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DatasetSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DatasetSummary::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final SdkField<List<DatasetTrigger>> TRIGGERS_FIELD = SdkField
            .<List<DatasetTrigger>> builder(MarshallingType.LIST)
            .getter(getter(DatasetSummary::triggers))
            .setter(setter(Builder::triggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetTrigger> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetTrigger::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DatasetActionSummary>> ACTIONS_FIELD = SdkField
            .<List<DatasetActionSummary>> builder(MarshallingType.LIST)
            .getter(getter(DatasetSummary::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetActionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetActionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD,
            STATUS_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, TRIGGERS_FIELD, ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String datasetName;

    private final String status;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private final List<DatasetTrigger> triggers;

    private final List<DatasetActionSummary> actions;

    private DatasetSummary(BuilderImpl builder) {
        this.datasetName = builder.datasetName;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.triggers = builder.triggers;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The name of the data set.
     * </p>
     * 
     * @return The name of the data set.
     */
    public String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The status of the data set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data set.
     * @see DatasetStatus
     */
    public DatasetStatus status() {
        return DatasetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the data set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data set.
     * @see DatasetStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time the data set was created.
     * </p>
     * 
     * @return The time the data set was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the data set was updated.
     * </p>
     * 
     * @return The last time the data set was updated.
     */
    public Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * Returns true if the Triggers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTriggers() {
        return triggers != null && !(triggers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of triggers. A trigger causes data set content to be populated at a specified time interval or when
     * another data set is populated. The list of triggers can be empty or contain up to five DataSetTrigger objects
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTriggers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of triggers. A trigger causes data set content to be populated at a specified time interval or
     *         when another data set is populated. The list of triggers can be empty or contain up to five
     *         DataSetTrigger objects
     */
    public List<DatasetTrigger> triggers() {
        return triggers;
    }

    /**
     * Returns true if the Actions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of "DataActionSummary" objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of "DataActionSummary" objects.
     */
    public List<DatasetActionSummary> actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(triggers());
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetSummary)) {
            return false;
        }
        DatasetSummary other = (DatasetSummary) obj;
        return Objects.equals(datasetName(), other.datasetName()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(triggers(), other.triggers())
                && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DatasetSummary").add("DatasetName", datasetName()).add("Status", statusAsString())
                .add("CreationTime", creationTime()).add("LastUpdateTime", lastUpdateTime()).add("Triggers", triggers())
                .add("Actions", actions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "triggers":
            return Optional.ofNullable(clazz.cast(triggers()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetSummary, T> g) {
        return obj -> g.apply((DatasetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetSummary> {
        /**
         * <p>
         * The name of the data set.
         * </p>
         * 
         * @param datasetName
         *        The name of the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The status of the data set.
         * </p>
         * 
         * @param status
         *        The status of the data set.
         * @see DatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the data set.
         * </p>
         * 
         * @param status
         *        The status of the data set.
         * @see DatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetStatus
         */
        Builder status(DatasetStatus status);

        /**
         * <p>
         * The time the data set was created.
         * </p>
         * 
         * @param creationTime
         *        The time the data set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the data set was updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last time the data set was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * A list of triggers. A trigger causes data set content to be populated at a specified time interval or when
         * another data set is populated. The list of triggers can be empty or contain up to five DataSetTrigger objects
         * </p>
         * 
         * @param triggers
         *        A list of triggers. A trigger causes data set content to be populated at a specified time interval or
         *        when another data set is populated. The list of triggers can be empty or contain up to five
         *        DataSetTrigger objects
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Collection<DatasetTrigger> triggers);

        /**
         * <p>
         * A list of triggers. A trigger causes data set content to be populated at a specified time interval or when
         * another data set is populated. The list of triggers can be empty or contain up to five DataSetTrigger objects
         * </p>
         * 
         * @param triggers
         *        A list of triggers. A trigger causes data set content to be populated at a specified time interval or
         *        when another data set is populated. The list of triggers can be empty or contain up to five
         *        DataSetTrigger objects
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(DatasetTrigger... triggers);

        /**
         * <p>
         * A list of triggers. A trigger causes data set content to be populated at a specified time interval or when
         * another data set is populated. The list of triggers can be empty or contain up to five DataSetTrigger objects
         * </p>
         * This is a convenience that creates an instance of the {@link List<DatasetTrigger>.Builder} avoiding the need
         * to create one manually via {@link List<DatasetTrigger>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DatasetTrigger>.Builder#build()} is called immediately and
         * its result is passed to {@link #triggers(List<DatasetTrigger>)}.
         * 
         * @param triggers
         *        a consumer that will call methods on {@link List<DatasetTrigger>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggers(List<DatasetTrigger>)
         */
        Builder triggers(Consumer<DatasetTrigger.Builder>... triggers);

        /**
         * <p>
         * A list of "DataActionSummary" objects.
         * </p>
         * 
         * @param actions
         *        A list of "DataActionSummary" objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<DatasetActionSummary> actions);

        /**
         * <p>
         * A list of "DataActionSummary" objects.
         * </p>
         * 
         * @param actions
         *        A list of "DataActionSummary" objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(DatasetActionSummary... actions);

        /**
         * <p>
         * A list of "DataActionSummary" objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DatasetActionSummary>.Builder} avoiding the
         * need to create one manually via {@link List<DatasetActionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DatasetActionSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #actions(List<DatasetActionSummary>)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link List<DatasetActionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(List<DatasetActionSummary>)
         */
        Builder actions(Consumer<DatasetActionSummary.Builder>... actions);
    }

    static final class BuilderImpl implements Builder {
        private String datasetName;

        private String status;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private List<DatasetTrigger> triggers = DefaultSdkAutoConstructList.getInstance();

        private List<DatasetActionSummary> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetSummary model) {
            datasetName(model.datasetName);
            status(model.status);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
            triggers(model.triggers);
            actions(model.actions);
        }

        public final String getDatasetName() {
            return datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public final Collection<DatasetTrigger.Builder> getTriggers() {
            return triggers != null ? triggers.stream().map(DatasetTrigger::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder triggers(Collection<DatasetTrigger> triggers) {
            this.triggers = DatasetTriggersCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(DatasetTrigger... triggers) {
            triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<DatasetTrigger.Builder>... triggers) {
            triggers(Stream.of(triggers).map(c -> DatasetTrigger.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTriggers(Collection<DatasetTrigger.BuilderImpl> triggers) {
            this.triggers = DatasetTriggersCopier.copyFromBuilder(triggers);
        }

        public final Collection<DatasetActionSummary.Builder> getActions() {
            return actions != null ? actions.stream().map(DatasetActionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<DatasetActionSummary> actions) {
            this.actions = DatasetActionSummariesCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(DatasetActionSummary... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<DatasetActionSummary.Builder>... actions) {
            actions(Stream.of(actions).map(c -> DatasetActionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<DatasetActionSummary.BuilderImpl> actions) {
            this.actions = DatasetActionSummariesCopier.copyFromBuilder(actions);
        }

        @Override
        public DatasetSummary build() {
            return new DatasetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
