/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SampleChannelDataRequest extends IoTAnalyticsRequest implements
        ToCopyableBuilder<SampleChannelDataRequest.Builder, SampleChannelDataRequest> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SampleChannelDataRequest::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelName").build()).build();

    private static final SdkField<Integer> MAX_MESSAGES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SampleChannelDataRequest::maxMessages)).setter(setter(Builder::maxMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxMessages").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(SampleChannelDataRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(SampleChannelDataRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD,
            MAX_MESSAGES_FIELD, START_TIME_FIELD, END_TIME_FIELD));

    private final String channelName;

    private final Integer maxMessages;

    private final Instant startTime;

    private final Instant endTime;

    private SampleChannelDataRequest(BuilderImpl builder) {
        super(builder);
        this.channelName = builder.channelName;
        this.maxMessages = builder.maxMessages;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The name of the channel whose message samples are retrieved.
     * </p>
     * 
     * @return The name of the channel whose message samples are retrieved.
     */
    public String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The number of sample messages to be retrieved. The limit is 10, the default is also 10.
     * </p>
     * 
     * @return The number of sample messages to be retrieved. The limit is 10, the default is also 10.
     */
    public Integer maxMessages() {
        return maxMessages;
    }

    /**
     * <p>
     * The start of the time window from which sample messages are retrieved.
     * </p>
     * 
     * @return The start of the time window from which sample messages are retrieved.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time window from which sample messages are retrieved.
     * </p>
     * 
     * @return The end of the time window from which sample messages are retrieved.
     */
    public Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(maxMessages());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SampleChannelDataRequest)) {
            return false;
        }
        SampleChannelDataRequest other = (SampleChannelDataRequest) obj;
        return Objects.equals(channelName(), other.channelName()) && Objects.equals(maxMessages(), other.maxMessages())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SampleChannelDataRequest").add("ChannelName", channelName()).add("MaxMessages", maxMessages())
                .add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "maxMessages":
            return Optional.ofNullable(clazz.cast(maxMessages()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SampleChannelDataRequest, T> g) {
        return obj -> g.apply((SampleChannelDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, SampleChannelDataRequest> {
        /**
         * <p>
         * The name of the channel whose message samples are retrieved.
         * </p>
         * 
         * @param channelName
         *        The name of the channel whose message samples are retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The number of sample messages to be retrieved. The limit is 10, the default is also 10.
         * </p>
         * 
         * @param maxMessages
         *        The number of sample messages to be retrieved. The limit is 10, the default is also 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxMessages(Integer maxMessages);

        /**
         * <p>
         * The start of the time window from which sample messages are retrieved.
         * </p>
         * 
         * @param startTime
         *        The start of the time window from which sample messages are retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time window from which sample messages are retrieved.
         * </p>
         * 
         * @param endTime
         *        The end of the time window from which sample messages are retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTAnalyticsRequest.BuilderImpl implements Builder {
        private String channelName;

        private Integer maxMessages;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SampleChannelDataRequest model) {
            super(model);
            channelName(model.channelName);
            maxMessages(model.maxMessages);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getChannelName() {
            return channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public final Integer getMaxMessages() {
            return maxMessages;
        }

        @Override
        public final Builder maxMessages(Integer maxMessages) {
            this.maxMessages = maxMessages;
            return this;
        }

        public final void setMaxMessages(Integer maxMessages) {
            this.maxMessages = maxMessages;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SampleChannelDataRequest build() {
            return new SampleChannelDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
