/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDatasetRequest extends IoTAnalyticsRequest implements
        ToCopyableBuilder<UpdateDatasetRequest.Builder, UpdateDatasetRequest> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDatasetRequest::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetName").build()).build();

    private static final SdkField<List<DatasetAction>> ACTIONS_FIELD = SdkField
            .<List<DatasetAction>> builder(MarshallingType.LIST)
            .getter(getter(UpdateDatasetRequest::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DatasetTrigger>> TRIGGERS_FIELD = SdkField
            .<List<DatasetTrigger>> builder(MarshallingType.LIST)
            .getter(getter(UpdateDatasetRequest::triggers))
            .setter(setter(Builder::triggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetTrigger> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetTrigger::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DatasetContentDeliveryRule>> CONTENT_DELIVERY_RULES_FIELD = SdkField
            .<List<DatasetContentDeliveryRule>> builder(MarshallingType.LIST)
            .getter(getter(UpdateDatasetRequest::contentDeliveryRules))
            .setter(setter(Builder::contentDeliveryRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentDeliveryRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetContentDeliveryRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetContentDeliveryRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).getter(getter(UpdateDatasetRequest::retentionPeriod))
            .setter(setter(Builder::retentionPeriod)).constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()).build();

    private static final SdkField<VersioningConfiguration> VERSIONING_CONFIGURATION_FIELD = SdkField
            .<VersioningConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateDatasetRequest::versioningConfiguration)).setter(setter(Builder::versioningConfiguration))
            .constructor(VersioningConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versioningConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD,
            ACTIONS_FIELD, TRIGGERS_FIELD, CONTENT_DELIVERY_RULES_FIELD, RETENTION_PERIOD_FIELD, VERSIONING_CONFIGURATION_FIELD));

    private final String datasetName;

    private final List<DatasetAction> actions;

    private final List<DatasetTrigger> triggers;

    private final List<DatasetContentDeliveryRule> contentDeliveryRules;

    private final RetentionPeriod retentionPeriod;

    private final VersioningConfiguration versioningConfiguration;

    private UpdateDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.datasetName = builder.datasetName;
        this.actions = builder.actions;
        this.triggers = builder.triggers;
        this.contentDeliveryRules = builder.contentDeliveryRules;
        this.retentionPeriod = builder.retentionPeriod;
        this.versioningConfiguration = builder.versioningConfiguration;
    }

    /**
     * <p>
     * The name of the data set to update.
     * </p>
     * 
     * @return The name of the data set to update.
     */
    public String datasetName() {
        return datasetName;
    }

    /**
     * Returns true if the Actions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of "DatasetAction" objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of "DatasetAction" objects.
     */
    public List<DatasetAction> actions() {
        return actions;
    }

    /**
     * Returns true if the Triggers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTriggers() {
        return triggers != null && !(triggers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of "DatasetTrigger" objects. The list can be empty or can contain up to five <b>DataSetTrigger</b>
     * objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTriggers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of "DatasetTrigger" objects. The list can be empty or can contain up to five <b>DataSetTrigger</b>
     *         objects.
     */
    public List<DatasetTrigger> triggers() {
        return triggers;
    }

    /**
     * Returns true if the ContentDeliveryRules property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasContentDeliveryRules() {
        return contentDeliveryRules != null && !(contentDeliveryRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * When data set contents are created they are delivered to destinations specified here.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContentDeliveryRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return When data set contents are created they are delivered to destinations specified here.
     */
    public List<DatasetContentDeliveryRule> contentDeliveryRules() {
        return contentDeliveryRules;
    }

    /**
     * <p>
     * How long, in days, data set contents are kept for the data set.
     * </p>
     * 
     * @return How long, in days, data set contents are kept for the data set.
     */
    public RetentionPeriod retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * [Optional] How many versions of data set contents are kept. If not specified or set to null, only the latest
     * version plus the latest succeeded version (if they are different) are kept for the time period specified by the
     * "retentionPeriod" parameter. (For more information, see
     * https://docs.aws.amazon.com/iotanalytics/latest/userguide/
     * getting-started.html#aws-iot-analytics-dataset-versions)
     * </p>
     * 
     * @return [Optional] How many versions of data set contents are kept. If not specified or set to null, only the
     *         latest version plus the latest succeeded version (if they are different) are kept for the time period
     *         specified by the "retentionPeriod" parameter. (For more information, see
     *         https://docs.aws.amazon.com/iotanalytics
     *         /latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions)
     */
    public VersioningConfiguration versioningConfiguration() {
        return versioningConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        hashCode = 31 * hashCode + Objects.hashCode(triggers());
        hashCode = 31 * hashCode + Objects.hashCode(contentDeliveryRules());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(versioningConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatasetRequest)) {
            return false;
        }
        UpdateDatasetRequest other = (UpdateDatasetRequest) obj;
        return Objects.equals(datasetName(), other.datasetName()) && Objects.equals(actions(), other.actions())
                && Objects.equals(triggers(), other.triggers())
                && Objects.equals(contentDeliveryRules(), other.contentDeliveryRules())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(versioningConfiguration(), other.versioningConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDatasetRequest").add("DatasetName", datasetName()).add("Actions", actions())
                .add("Triggers", triggers()).add("ContentDeliveryRules", contentDeliveryRules())
                .add("RetentionPeriod", retentionPeriod()).add("VersioningConfiguration", versioningConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "triggers":
            return Optional.ofNullable(clazz.cast(triggers()));
        case "contentDeliveryRules":
            return Optional.ofNullable(clazz.cast(contentDeliveryRules()));
        case "retentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "versioningConfiguration":
            return Optional.ofNullable(clazz.cast(versioningConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatasetRequest, T> g) {
        return obj -> g.apply((UpdateDatasetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDatasetRequest> {
        /**
         * <p>
         * The name of the data set to update.
         * </p>
         * 
         * @param datasetName
         *        The name of the data set to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * A list of "DatasetAction" objects.
         * </p>
         * 
         * @param actions
         *        A list of "DatasetAction" objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<DatasetAction> actions);

        /**
         * <p>
         * A list of "DatasetAction" objects.
         * </p>
         * 
         * @param actions
         *        A list of "DatasetAction" objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(DatasetAction... actions);

        /**
         * <p>
         * A list of "DatasetAction" objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DatasetAction>.Builder} avoiding the need
         * to create one manually via {@link List<DatasetAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DatasetAction>.Builder#build()} is called immediately and
         * its result is passed to {@link #actions(List<DatasetAction>)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link List<DatasetAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(List<DatasetAction>)
         */
        Builder actions(Consumer<DatasetAction.Builder>... actions);

        /**
         * <p>
         * A list of "DatasetTrigger" objects. The list can be empty or can contain up to five <b>DataSetTrigger</b>
         * objects.
         * </p>
         * 
         * @param triggers
         *        A list of "DatasetTrigger" objects. The list can be empty or can contain up to five
         *        <b>DataSetTrigger</b> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Collection<DatasetTrigger> triggers);

        /**
         * <p>
         * A list of "DatasetTrigger" objects. The list can be empty or can contain up to five <b>DataSetTrigger</b>
         * objects.
         * </p>
         * 
         * @param triggers
         *        A list of "DatasetTrigger" objects. The list can be empty or can contain up to five
         *        <b>DataSetTrigger</b> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(DatasetTrigger... triggers);

        /**
         * <p>
         * A list of "DatasetTrigger" objects. The list can be empty or can contain up to five <b>DataSetTrigger</b>
         * objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DatasetTrigger>.Builder} avoiding the need
         * to create one manually via {@link List<DatasetTrigger>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DatasetTrigger>.Builder#build()} is called immediately and
         * its result is passed to {@link #triggers(List<DatasetTrigger>)}.
         * 
         * @param triggers
         *        a consumer that will call methods on {@link List<DatasetTrigger>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggers(List<DatasetTrigger>)
         */
        Builder triggers(Consumer<DatasetTrigger.Builder>... triggers);

        /**
         * <p>
         * When data set contents are created they are delivered to destinations specified here.
         * </p>
         * 
         * @param contentDeliveryRules
         *        When data set contents are created they are delivered to destinations specified here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentDeliveryRules(Collection<DatasetContentDeliveryRule> contentDeliveryRules);

        /**
         * <p>
         * When data set contents are created they are delivered to destinations specified here.
         * </p>
         * 
         * @param contentDeliveryRules
         *        When data set contents are created they are delivered to destinations specified here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentDeliveryRules(DatasetContentDeliveryRule... contentDeliveryRules);

        /**
         * <p>
         * When data set contents are created they are delivered to destinations specified here.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DatasetContentDeliveryRule>.Builder}
         * avoiding the need to create one manually via {@link List<DatasetContentDeliveryRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DatasetContentDeliveryRule>.Builder#build()} is called
         * immediately and its result is passed to {@link #contentDeliveryRules(List<DatasetContentDeliveryRule>)}.
         * 
         * @param contentDeliveryRules
         *        a consumer that will call methods on {@link List<DatasetContentDeliveryRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentDeliveryRules(List<DatasetContentDeliveryRule>)
         */
        Builder contentDeliveryRules(Consumer<DatasetContentDeliveryRule.Builder>... contentDeliveryRules);

        /**
         * <p>
         * How long, in days, data set contents are kept for the data set.
         * </p>
         * 
         * @param retentionPeriod
         *        How long, in days, data set contents are kept for the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(RetentionPeriod retentionPeriod);

        /**
         * <p>
         * How long, in days, data set contents are kept for the data set.
         * </p>
         * This is a convenience that creates an instance of the {@link RetentionPeriod.Builder} avoiding the need to
         * create one manually via {@link RetentionPeriod#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionPeriod(RetentionPeriod)}.
         * 
         * @param retentionPeriod
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionPeriod(RetentionPeriod)
         */
        default Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return retentionPeriod(RetentionPeriod.builder().applyMutation(retentionPeriod).build());
        }

        /**
         * <p>
         * [Optional] How many versions of data set contents are kept. If not specified or set to null, only the latest
         * version plus the latest succeeded version (if they are different) are kept for the time period specified by
         * the "retentionPeriod" parameter. (For more information, see
         * https://docs.aws.amazon.com/iotanalytics/latest/userguide
         * /getting-started.html#aws-iot-analytics-dataset-versions)
         * </p>
         * 
         * @param versioningConfiguration
         *        [Optional] How many versions of data set contents are kept. If not specified or set to null, only the
         *        latest version plus the latest succeeded version (if they are different) are kept for the time period
         *        specified by the "retentionPeriod" parameter. (For more information, see
         *        https://docs.aws.amazon.com/iotanalytics
         *        /latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versioningConfiguration(VersioningConfiguration versioningConfiguration);

        /**
         * <p>
         * [Optional] How many versions of data set contents are kept. If not specified or set to null, only the latest
         * version plus the latest succeeded version (if they are different) are kept for the time period specified by
         * the "retentionPeriod" parameter. (For more information, see
         * https://docs.aws.amazon.com/iotanalytics/latest/userguide
         * /getting-started.html#aws-iot-analytics-dataset-versions)
         * </p>
         * This is a convenience that creates an instance of the {@link VersioningConfiguration.Builder} avoiding the
         * need to create one manually via {@link VersioningConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link VersioningConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #versioningConfiguration(VersioningConfiguration)}.
         * 
         * @param versioningConfiguration
         *        a consumer that will call methods on {@link VersioningConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #versioningConfiguration(VersioningConfiguration)
         */
        default Builder versioningConfiguration(Consumer<VersioningConfiguration.Builder> versioningConfiguration) {
            return versioningConfiguration(VersioningConfiguration.builder().applyMutation(versioningConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTAnalyticsRequest.BuilderImpl implements Builder {
        private String datasetName;

        private List<DatasetAction> actions = DefaultSdkAutoConstructList.getInstance();

        private List<DatasetTrigger> triggers = DefaultSdkAutoConstructList.getInstance();

        private List<DatasetContentDeliveryRule> contentDeliveryRules = DefaultSdkAutoConstructList.getInstance();

        private RetentionPeriod retentionPeriod;

        private VersioningConfiguration versioningConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatasetRequest model) {
            super(model);
            datasetName(model.datasetName);
            actions(model.actions);
            triggers(model.triggers);
            contentDeliveryRules(model.contentDeliveryRules);
            retentionPeriod(model.retentionPeriod);
            versioningConfiguration(model.versioningConfiguration);
        }

        public final String getDatasetName() {
            return datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final Collection<DatasetAction.Builder> getActions() {
            return actions != null ? actions.stream().map(DatasetAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<DatasetAction> actions) {
            this.actions = DatasetActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(DatasetAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<DatasetAction.Builder>... actions) {
            actions(Stream.of(actions).map(c -> DatasetAction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<DatasetAction.BuilderImpl> actions) {
            this.actions = DatasetActionsCopier.copyFromBuilder(actions);
        }

        public final Collection<DatasetTrigger.Builder> getTriggers() {
            return triggers != null ? triggers.stream().map(DatasetTrigger::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder triggers(Collection<DatasetTrigger> triggers) {
            this.triggers = DatasetTriggersCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(DatasetTrigger... triggers) {
            triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<DatasetTrigger.Builder>... triggers) {
            triggers(Stream.of(triggers).map(c -> DatasetTrigger.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTriggers(Collection<DatasetTrigger.BuilderImpl> triggers) {
            this.triggers = DatasetTriggersCopier.copyFromBuilder(triggers);
        }

        public final Collection<DatasetContentDeliveryRule.Builder> getContentDeliveryRules() {
            return contentDeliveryRules != null ? contentDeliveryRules.stream().map(DatasetContentDeliveryRule::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder contentDeliveryRules(Collection<DatasetContentDeliveryRule> contentDeliveryRules) {
            this.contentDeliveryRules = DatasetContentDeliveryRulesCopier.copy(contentDeliveryRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentDeliveryRules(DatasetContentDeliveryRule... contentDeliveryRules) {
            contentDeliveryRules(Arrays.asList(contentDeliveryRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentDeliveryRules(Consumer<DatasetContentDeliveryRule.Builder>... contentDeliveryRules) {
            contentDeliveryRules(Stream.of(contentDeliveryRules)
                    .map(c -> DatasetContentDeliveryRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContentDeliveryRules(Collection<DatasetContentDeliveryRule.BuilderImpl> contentDeliveryRules) {
            this.contentDeliveryRules = DatasetContentDeliveryRulesCopier.copyFromBuilder(contentDeliveryRules);
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return retentionPeriod != null ? retentionPeriod.toBuilder() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        public final VersioningConfiguration.Builder getVersioningConfiguration() {
            return versioningConfiguration != null ? versioningConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder versioningConfiguration(VersioningConfiguration versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration;
            return this;
        }

        public final void setVersioningConfiguration(VersioningConfiguration.BuilderImpl versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration != null ? versioningConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatasetRequest build() {
            return new UpdateDatasetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
