/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An instance of a variable to be passed to the "containerAction" execution. Each variable must have a name and a value
 * given by one of "stringValue", "datasetContentVersionValue", or "outputFileUriValue".
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Variable implements SdkPojo, Serializable, ToCopyableBuilder<Variable.Builder, Variable> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Variable::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Variable::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()).build();

    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Variable::doubleValue)).setter(setter(Builder::doubleValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()).build();

    private static final SdkField<DatasetContentVersionValue> DATASET_CONTENT_VERSION_VALUE_FIELD = SdkField
            .<DatasetContentVersionValue> builder(MarshallingType.SDK_POJO)
            .getter(getter(Variable::datasetContentVersionValue))
            .setter(setter(Builder::datasetContentVersionValue))
            .constructor(DatasetContentVersionValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetContentVersionValue").build())
            .build();

    private static final SdkField<OutputFileUriValue> OUTPUT_FILE_URI_VALUE_FIELD = SdkField
            .<OutputFileUriValue> builder(MarshallingType.SDK_POJO).getter(getter(Variable::outputFileUriValue))
            .setter(setter(Builder::outputFileUriValue)).constructor(OutputFileUriValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputFileUriValue").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            STRING_VALUE_FIELD, DOUBLE_VALUE_FIELD, DATASET_CONTENT_VERSION_VALUE_FIELD, OUTPUT_FILE_URI_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String stringValue;

    private final Double doubleValue;

    private final DatasetContentVersionValue datasetContentVersionValue;

    private final OutputFileUriValue outputFileUriValue;

    private Variable(BuilderImpl builder) {
        this.name = builder.name;
        this.stringValue = builder.stringValue;
        this.doubleValue = builder.doubleValue;
        this.datasetContentVersionValue = builder.datasetContentVersionValue;
        this.outputFileUriValue = builder.outputFileUriValue;
    }

    /**
     * <p>
     * The name of the variable.
     * </p>
     * 
     * @return The name of the variable.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The value of the variable as a string.
     * </p>
     * 
     * @return The value of the variable as a string.
     */
    public String stringValue() {
        return stringValue;
    }

    /**
     * <p>
     * The value of the variable as a double (numeric).
     * </p>
     * 
     * @return The value of the variable as a double (numeric).
     */
    public Double doubleValue() {
        return doubleValue;
    }

    /**
     * <p>
     * The value of the variable as a structure that specifies a data set content version.
     * </p>
     * 
     * @return The value of the variable as a structure that specifies a data set content version.
     */
    public DatasetContentVersionValue datasetContentVersionValue() {
        return datasetContentVersionValue;
    }

    /**
     * <p>
     * The value of the variable as a structure that specifies an output file URI.
     * </p>
     * 
     * @return The value of the variable as a structure that specifies an output file URI.
     */
    public OutputFileUriValue outputFileUriValue() {
        return outputFileUriValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(datasetContentVersionValue());
        hashCode = 31 * hashCode + Objects.hashCode(outputFileUriValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Variable)) {
            return false;
        }
        Variable other = (Variable) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(stringValue(), other.stringValue())
                && Objects.equals(doubleValue(), other.doubleValue())
                && Objects.equals(datasetContentVersionValue(), other.datasetContentVersionValue())
                && Objects.equals(outputFileUriValue(), other.outputFileUriValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Variable").add("Name", name()).add("StringValue", stringValue())
                .add("DoubleValue", doubleValue()).add("DatasetContentVersionValue", datasetContentVersionValue())
                .add("OutputFileUriValue", outputFileUriValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "stringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "doubleValue":
            return Optional.ofNullable(clazz.cast(doubleValue()));
        case "datasetContentVersionValue":
            return Optional.ofNullable(clazz.cast(datasetContentVersionValue()));
        case "outputFileUriValue":
            return Optional.ofNullable(clazz.cast(outputFileUriValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Variable, T> g) {
        return obj -> g.apply((Variable) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Variable> {
        /**
         * <p>
         * The name of the variable.
         * </p>
         * 
         * @param name
         *        The name of the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value of the variable as a string.
         * </p>
         * 
         * @param stringValue
         *        The value of the variable as a string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * The value of the variable as a double (numeric).
         * </p>
         * 
         * @param doubleValue
         *        The value of the variable as a double (numeric).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValue(Double doubleValue);

        /**
         * <p>
         * The value of the variable as a structure that specifies a data set content version.
         * </p>
         * 
         * @param datasetContentVersionValue
         *        The value of the variable as a structure that specifies a data set content version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetContentVersionValue(DatasetContentVersionValue datasetContentVersionValue);

        /**
         * <p>
         * The value of the variable as a structure that specifies a data set content version.
         * </p>
         * This is a convenience that creates an instance of the {@link DatasetContentVersionValue.Builder} avoiding the
         * need to create one manually via {@link DatasetContentVersionValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatasetContentVersionValue.Builder#build()} is called immediately
         * and its result is passed to {@link #datasetContentVersionValue(DatasetContentVersionValue)}.
         * 
         * @param datasetContentVersionValue
         *        a consumer that will call methods on {@link DatasetContentVersionValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetContentVersionValue(DatasetContentVersionValue)
         */
        default Builder datasetContentVersionValue(Consumer<DatasetContentVersionValue.Builder> datasetContentVersionValue) {
            return datasetContentVersionValue(DatasetContentVersionValue.builder().applyMutation(datasetContentVersionValue)
                    .build());
        }

        /**
         * <p>
         * The value of the variable as a structure that specifies an output file URI.
         * </p>
         * 
         * @param outputFileUriValue
         *        The value of the variable as a structure that specifies an output file URI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputFileUriValue(OutputFileUriValue outputFileUriValue);

        /**
         * <p>
         * The value of the variable as a structure that specifies an output file URI.
         * </p>
         * This is a convenience that creates an instance of the {@link OutputFileUriValue.Builder} avoiding the need to
         * create one manually via {@link OutputFileUriValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputFileUriValue.Builder#build()} is called immediately and its
         * result is passed to {@link #outputFileUriValue(OutputFileUriValue)}.
         * 
         * @param outputFileUriValue
         *        a consumer that will call methods on {@link OutputFileUriValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputFileUriValue(OutputFileUriValue)
         */
        default Builder outputFileUriValue(Consumer<OutputFileUriValue.Builder> outputFileUriValue) {
            return outputFileUriValue(OutputFileUriValue.builder().applyMutation(outputFileUriValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String stringValue;

        private Double doubleValue;

        private DatasetContentVersionValue datasetContentVersionValue;

        private OutputFileUriValue outputFileUriValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Variable model) {
            name(model.name);
            stringValue(model.stringValue);
            doubleValue(model.doubleValue);
            datasetContentVersionValue(model.datasetContentVersionValue);
            outputFileUriValue(model.outputFileUriValue);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStringValue() {
            return stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public final Double getDoubleValue() {
            return doubleValue;
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
            return this;
        }

        public final void setDoubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
        }

        public final DatasetContentVersionValue.Builder getDatasetContentVersionValue() {
            return datasetContentVersionValue != null ? datasetContentVersionValue.toBuilder() : null;
        }

        @Override
        public final Builder datasetContentVersionValue(DatasetContentVersionValue datasetContentVersionValue) {
            this.datasetContentVersionValue = datasetContentVersionValue;
            return this;
        }

        public final void setDatasetContentVersionValue(DatasetContentVersionValue.BuilderImpl datasetContentVersionValue) {
            this.datasetContentVersionValue = datasetContentVersionValue != null ? datasetContentVersionValue.build() : null;
        }

        public final OutputFileUriValue.Builder getOutputFileUriValue() {
            return outputFileUriValue != null ? outputFileUriValue.toBuilder() : null;
        }

        @Override
        public final Builder outputFileUriValue(OutputFileUriValue outputFileUriValue) {
            this.outputFileUriValue = outputFileUriValue;
            return this;
        }

        public final void setOutputFileUriValue(OutputFileUriValue.BuilderImpl outputFileUriValue) {
            this.outputFileUriValue = outputFileUriValue != null ? outputFileUriValue.build() : null;
        }

        @Override
        public Variable build() {
            return new Variable(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
