/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iotanalytics.IoTAnalyticsClient;
import software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageRequest;
import software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageResponse;
import software.amazon.awssdk.services.iotanalytics.model.CancelPipelineReprocessingRequest;
import software.amazon.awssdk.services.iotanalytics.model.CancelPipelineReprocessingResponse;
import software.amazon.awssdk.services.iotanalytics.model.CreateChannelRequest;
import software.amazon.awssdk.services.iotanalytics.model.CreateChannelResponse;
import software.amazon.awssdk.services.iotanalytics.model.CreateDatasetContentRequest;
import software.amazon.awssdk.services.iotanalytics.model.CreateDatasetContentResponse;
import software.amazon.awssdk.services.iotanalytics.model.CreateDatasetRequest;
import software.amazon.awssdk.services.iotanalytics.model.CreateDatasetResponse;
import software.amazon.awssdk.services.iotanalytics.model.CreateDatastoreRequest;
import software.amazon.awssdk.services.iotanalytics.model.CreateDatastoreResponse;
import software.amazon.awssdk.services.iotanalytics.model.CreatePipelineRequest;
import software.amazon.awssdk.services.iotanalytics.model.CreatePipelineResponse;
import software.amazon.awssdk.services.iotanalytics.model.DeleteChannelRequest;
import software.amazon.awssdk.services.iotanalytics.model.DeleteChannelResponse;
import software.amazon.awssdk.services.iotanalytics.model.DeleteDatasetContentRequest;
import software.amazon.awssdk.services.iotanalytics.model.DeleteDatasetContentResponse;
import software.amazon.awssdk.services.iotanalytics.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.iotanalytics.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.iotanalytics.model.DeleteDatastoreRequest;
import software.amazon.awssdk.services.iotanalytics.model.DeleteDatastoreResponse;
import software.amazon.awssdk.services.iotanalytics.model.DeletePipelineRequest;
import software.amazon.awssdk.services.iotanalytics.model.DeletePipelineResponse;
import software.amazon.awssdk.services.iotanalytics.model.DescribeChannelRequest;
import software.amazon.awssdk.services.iotanalytics.model.DescribeChannelResponse;
import software.amazon.awssdk.services.iotanalytics.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.iotanalytics.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.iotanalytics.model.DescribeDatastoreRequest;
import software.amazon.awssdk.services.iotanalytics.model.DescribeDatastoreResponse;
import software.amazon.awssdk.services.iotanalytics.model.DescribeLoggingOptionsRequest;
import software.amazon.awssdk.services.iotanalytics.model.DescribeLoggingOptionsResponse;
import software.amazon.awssdk.services.iotanalytics.model.DescribePipelineRequest;
import software.amazon.awssdk.services.iotanalytics.model.DescribePipelineResponse;
import software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentRequest;
import software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentResponse;
import software.amazon.awssdk.services.iotanalytics.model.InternalFailureException;
import software.amazon.awssdk.services.iotanalytics.model.InvalidRequestException;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsException;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsRequest;
import software.amazon.awssdk.services.iotanalytics.model.LimitExceededException;
import software.amazon.awssdk.services.iotanalytics.model.ListChannelsRequest;
import software.amazon.awssdk.services.iotanalytics.model.ListChannelsResponse;
import software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest;
import software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsResponse;
import software.amazon.awssdk.services.iotanalytics.model.ListDatasetsRequest;
import software.amazon.awssdk.services.iotanalytics.model.ListDatasetsResponse;
import software.amazon.awssdk.services.iotanalytics.model.ListDatastoresRequest;
import software.amazon.awssdk.services.iotanalytics.model.ListDatastoresResponse;
import software.amazon.awssdk.services.iotanalytics.model.ListPipelinesRequest;
import software.amazon.awssdk.services.iotanalytics.model.ListPipelinesResponse;
import software.amazon.awssdk.services.iotanalytics.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotanalytics.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotanalytics.model.PutLoggingOptionsRequest;
import software.amazon.awssdk.services.iotanalytics.model.PutLoggingOptionsResponse;
import software.amazon.awssdk.services.iotanalytics.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.iotanalytics.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotanalytics.model.RunPipelineActivityRequest;
import software.amazon.awssdk.services.iotanalytics.model.RunPipelineActivityResponse;
import software.amazon.awssdk.services.iotanalytics.model.SampleChannelDataRequest;
import software.amazon.awssdk.services.iotanalytics.model.SampleChannelDataResponse;
import software.amazon.awssdk.services.iotanalytics.model.ServiceUnavailableException;
import software.amazon.awssdk.services.iotanalytics.model.StartPipelineReprocessingRequest;
import software.amazon.awssdk.services.iotanalytics.model.StartPipelineReprocessingResponse;
import software.amazon.awssdk.services.iotanalytics.model.TagResourceRequest;
import software.amazon.awssdk.services.iotanalytics.model.TagResourceResponse;
import software.amazon.awssdk.services.iotanalytics.model.ThrottlingException;
import software.amazon.awssdk.services.iotanalytics.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotanalytics.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotanalytics.model.UpdateChannelRequest;
import software.amazon.awssdk.services.iotanalytics.model.UpdateChannelResponse;
import software.amazon.awssdk.services.iotanalytics.model.UpdateDatasetRequest;
import software.amazon.awssdk.services.iotanalytics.model.UpdateDatasetResponse;
import software.amazon.awssdk.services.iotanalytics.model.UpdateDatastoreRequest;
import software.amazon.awssdk.services.iotanalytics.model.UpdateDatastoreResponse;
import software.amazon.awssdk.services.iotanalytics.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.iotanalytics.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.iotanalytics.paginators.ListChannelsIterable;
import software.amazon.awssdk.services.iotanalytics.paginators.ListDatasetContentsIterable;
import software.amazon.awssdk.services.iotanalytics.paginators.ListDatasetsIterable;
import software.amazon.awssdk.services.iotanalytics.paginators.ListDatastoresIterable;
import software.amazon.awssdk.services.iotanalytics.paginators.ListPipelinesIterable;
import software.amazon.awssdk.services.iotanalytics.transform.BatchPutMessageRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.CancelPipelineReprocessingRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.CreateChannelRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.CreateDatasetContentRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.CreateDatasetRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.CreateDatastoreRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.CreatePipelineRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.DeleteChannelRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.DeleteDatasetContentRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.DeleteDatasetRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.DeleteDatastoreRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.DeletePipelineRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.DescribeChannelRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.DescribeDatasetRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.DescribeDatastoreRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.DescribeLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.DescribePipelineRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.GetDatasetContentRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.ListChannelsRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.ListDatasetContentsRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.ListDatasetsRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.ListDatastoresRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.ListPipelinesRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.PutLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.RunPipelineActivityRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.SampleChannelDataRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.StartPipelineReprocessingRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.UpdateChannelRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.UpdateDatasetRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.UpdateDatastoreRequestMarshaller;
import software.amazon.awssdk.services.iotanalytics.transform.UpdatePipelineRequestMarshaller;

@SdkInternalApi
final class DefaultIoTAnalyticsClient
implements IoTAnalyticsClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIoTAnalyticsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "iotanalytics";
    }

    @Override
    public BatchPutMessageResponse batchPutMessage(BatchPutMessageRequest batchPutMessageRequest) throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchPutMessageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (BatchPutMessageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchPutMessage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchPutMessageRequest).withMarshaller((Marshaller)new BatchPutMessageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CancelPipelineReprocessingResponse cancelPipelineReprocessing(CancelPipelineReprocessingRequest cancelPipelineReprocessingRequest) throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelPipelineReprocessingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CancelPipelineReprocessingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelPipelineReprocessing").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelPipelineReprocessingRequest).withMarshaller((Marshaller)new CancelPipelineReprocessingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateChannelResponse createChannel(CreateChannelRequest createChannelRequest) throws InvalidRequestException, ResourceAlreadyExistsException, InternalFailureException, ServiceUnavailableException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateChannelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateChannel").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createChannelRequest).withMarshaller((Marshaller)new CreateChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateDatasetResponse createDataset(CreateDatasetRequest createDatasetRequest) throws InvalidRequestException, ResourceAlreadyExistsException, InternalFailureException, ServiceUnavailableException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatasetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDatasetRequest).withMarshaller((Marshaller)new CreateDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateDatasetContentResponse createDatasetContent(CreateDatasetContentRequest createDatasetContentRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatasetContentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateDatasetContentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDatasetContent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDatasetContentRequest).withMarshaller((Marshaller)new CreateDatasetContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateDatastoreResponse createDatastore(CreateDatastoreRequest createDatastoreRequest) throws InvalidRequestException, ResourceAlreadyExistsException, InternalFailureException, ServiceUnavailableException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatastoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateDatastoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDatastore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDatastoreRequest).withMarshaller((Marshaller)new CreateDatastoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreatePipelineResponse createPipeline(CreatePipelineRequest createPipelineRequest) throws InvalidRequestException, ResourceAlreadyExistsException, InternalFailureException, ServiceUnavailableException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPipelineRequest).withMarshaller((Marshaller)new CreatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteChannelResponse deleteChannel(DeleteChannelRequest deleteChannelRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteChannelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteChannel").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteChannelRequest).withMarshaller((Marshaller)new DeleteChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteDatasetResponse deleteDataset(DeleteDatasetRequest deleteDatasetRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatasetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDatasetRequest).withMarshaller((Marshaller)new DeleteDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteDatasetContentResponse deleteDatasetContent(DeleteDatasetContentRequest deleteDatasetContentRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatasetContentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteDatasetContentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDatasetContent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDatasetContentRequest).withMarshaller((Marshaller)new DeleteDatasetContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteDatastoreResponse deleteDatastore(DeleteDatastoreRequest deleteDatastoreRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatastoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteDatastoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDatastore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDatastoreRequest).withMarshaller((Marshaller)new DeleteDatastoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeletePipelineResponse deletePipeline(DeletePipelineRequest deletePipelineRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeletePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePipelineRequest).withMarshaller((Marshaller)new DeletePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeChannelResponse describeChannel(DescribeChannelRequest describeChannelRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeChannelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeChannel").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeChannelRequest).withMarshaller((Marshaller)new DescribeChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeDatasetResponse describeDataset(DescribeDatasetRequest describeDatasetRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatasetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDatasetRequest).withMarshaller((Marshaller)new DescribeDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeDatastoreResponse describeDatastore(DescribeDatastoreRequest describeDatastoreRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatastoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeDatastoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDatastore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDatastoreRequest).withMarshaller((Marshaller)new DescribeDatastoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeLoggingOptionsResponse describeLoggingOptions(DescribeLoggingOptionsRequest describeLoggingOptionsRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLoggingOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeLoggingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoggingOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoggingOptionsRequest).withMarshaller((Marshaller)new DescribeLoggingOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribePipelineResponse describePipeline(DescribePipelineRequest describePipelineRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePipelineRequest).withMarshaller((Marshaller)new DescribePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDatasetContentResponse getDatasetContent(GetDatasetContentRequest getDatasetContentRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDatasetContentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDatasetContentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDatasetContent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDatasetContentRequest).withMarshaller((Marshaller)new GetDatasetContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListChannelsResponse listChannels(ListChannelsRequest listChannelsRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListChannelsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListChannelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListChannels").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listChannelsRequest).withMarshaller((Marshaller)new ListChannelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListChannelsIterable listChannelsPaginator(ListChannelsRequest listChannelsRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        return new ListChannelsIterable(this, this.applyPaginatorUserAgent(listChannelsRequest));
    }

    @Override
    public ListDatasetContentsResponse listDatasetContents(ListDatasetContentsRequest listDatasetContentsRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetContentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDatasetContentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasetContents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDatasetContentsRequest).withMarshaller((Marshaller)new ListDatasetContentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDatasetContentsIterable listDatasetContentsPaginator(ListDatasetContentsRequest listDatasetContentsRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        return new ListDatasetContentsIterable(this, this.applyPaginatorUserAgent(listDatasetContentsRequest));
    }

    @Override
    public ListDatasetsResponse listDatasets(ListDatasetsRequest listDatasetsRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDatasetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDatasetsRequest).withMarshaller((Marshaller)new ListDatasetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDatasetsIterable listDatasetsPaginator(ListDatasetsRequest listDatasetsRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        return new ListDatasetsIterable(this, this.applyPaginatorUserAgent(listDatasetsRequest));
    }

    @Override
    public ListDatastoresResponse listDatastores(ListDatastoresRequest listDatastoresRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatastoresResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDatastoresResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatastores").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDatastoresRequest).withMarshaller((Marshaller)new ListDatastoresRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDatastoresIterable listDatastoresPaginator(ListDatastoresRequest listDatastoresRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        return new ListDatastoresIterable(this, this.applyPaginatorUserAgent(listDatastoresRequest));
    }

    @Override
    public ListPipelinesResponse listPipelines(ListPipelinesRequest listPipelinesRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipelinesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListPipelinesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipelines").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPipelinesRequest).withMarshaller((Marshaller)new ListPipelinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPipelinesIterable listPipelinesPaginator(ListPipelinesRequest listPipelinesRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        return new ListPipelinesIterable(this, this.applyPaginatorUserAgent(listPipelinesRequest));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutLoggingOptionsResponse putLoggingOptions(PutLoggingOptionsRequest putLoggingOptionsRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutLoggingOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutLoggingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutLoggingOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putLoggingOptionsRequest).withMarshaller((Marshaller)new PutLoggingOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RunPipelineActivityResponse runPipelineActivity(RunPipelineActivityRequest runPipelineActivityRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RunPipelineActivityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RunPipelineActivityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RunPipelineActivity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)runPipelineActivityRequest).withMarshaller((Marshaller)new RunPipelineActivityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SampleChannelDataResponse sampleChannelData(SampleChannelDataRequest sampleChannelDataRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SampleChannelDataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SampleChannelDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SampleChannelData").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sampleChannelDataRequest).withMarshaller((Marshaller)new SampleChannelDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartPipelineReprocessingResponse startPipelineReprocessing(StartPipelineReprocessingRequest startPipelineReprocessingRequest) throws ResourceNotFoundException, ResourceAlreadyExistsException, InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartPipelineReprocessingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartPipelineReprocessingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartPipelineReprocessing").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startPipelineReprocessingRequest).withMarshaller((Marshaller)new StartPipelineReprocessingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateChannelResponse updateChannel(UpdateChannelRequest updateChannelRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateChannelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateChannel").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateChannelRequest).withMarshaller((Marshaller)new UpdateChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateDatasetResponse updateDataset(UpdateDatasetRequest updateDatasetRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDatasetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDatasetRequest).withMarshaller((Marshaller)new UpdateDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateDatastoreResponse updateDatastore(UpdateDatastoreRequest updateDatastoreRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDatastoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateDatastoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDatastore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDatastoreRequest).withMarshaller((Marshaller)new UpdateDatastoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdatePipelineResponse updatePipeline(UpdatePipelineRequest updatePipelineRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, IoTAnalyticsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePipelineRequest).withMarshaller((Marshaller)new UpdatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(IoTAnalyticsException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InternalFailureException").exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(410)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(503)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends IoTAnalyticsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.10.44").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((IoTAnalyticsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

