/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomerManagedDatastoreS3Storage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomerManagedDatastoreS3Storage> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomerManagedDatastoreS3Storage.getter(CustomerManagedDatastoreS3Storage::bucket)).setter(CustomerManagedDatastoreS3Storage.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucket").build()}).build();
    private static final SdkField<String> KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomerManagedDatastoreS3Storage.getter(CustomerManagedDatastoreS3Storage::keyPrefix)).setter(CustomerManagedDatastoreS3Storage.setter(Builder::keyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPrefix").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomerManagedDatastoreS3Storage.getter(CustomerManagedDatastoreS3Storage::roleArn)).setter(CustomerManagedDatastoreS3Storage.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, KEY_PREFIX_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final String keyPrefix;
    private final String roleArn;

    private CustomerManagedDatastoreS3Storage(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.keyPrefix = builder.keyPrefix;
        this.roleArn = builder.roleArn;
    }

    public String bucket() {
        return this.bucket;
    }

    public String keyPrefix() {
        return this.keyPrefix;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerManagedDatastoreS3Storage)) {
            return false;
        }
        CustomerManagedDatastoreS3Storage other = (CustomerManagedDatastoreS3Storage)obj;
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.keyPrefix(), other.keyPrefix()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"CustomerManagedDatastoreS3Storage").add("Bucket", (Object)this.bucket()).add("KeyPrefix", (Object)this.keyPrefix()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "keyPrefix": {
                return Optional.ofNullable(clazz.cast(this.keyPrefix()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomerManagedDatastoreS3Storage, T> g) {
        return obj -> g.apply((CustomerManagedDatastoreS3Storage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String keyPrefix;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerManagedDatastoreS3Storage model) {
            this.bucket(model.bucket);
            this.keyPrefix(model.keyPrefix);
            this.roleArn(model.roleArn);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKeyPrefix() {
            return this.keyPrefix;
        }

        @Override
        public final Builder keyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public final void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public CustomerManagedDatastoreS3Storage build() {
            return new CustomerManagedDatastoreS3Storage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomerManagedDatastoreS3Storage> {
        public Builder bucket(String var1);

        public Builder keyPrefix(String var1);

        public Builder roleArn(String var1);
    }
}

