/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DatasetContentState {
    CREATING("CREATING"),
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DatasetContentState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DatasetContentState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DatasetContentState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DatasetContentState> knownValues() {
        return Stream.of(DatasetContentState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

