/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.DatastorePartitions;
import software.amazon.awssdk.services.iotanalytics.model.DatastoreStatus;
import software.amazon.awssdk.services.iotanalytics.model.DatastoreStorage;
import software.amazon.awssdk.services.iotanalytics.model.FileFormatConfiguration;
import software.amazon.awssdk.services.iotanalytics.model.RetentionPeriod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Datastore
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Datastore> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Datastore.getter(Datastore::name)).setter(Datastore.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<DatastoreStorage> STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storage").getter(Datastore.getter(Datastore::storage)).setter(Datastore.setter(Builder::storage)).constructor(DatastoreStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storage").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Datastore.getter(Datastore::arn)).setter(Datastore.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Datastore.getter(Datastore::statusAsString)).setter(Datastore.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retentionPeriod").getter(Datastore.getter(Datastore::retentionPeriod)).setter(Datastore.setter(Builder::retentionPeriod)).constructor(RetentionPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(Datastore.getter(Datastore::creationTime)).setter(Datastore.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(Datastore.getter(Datastore::lastUpdateTime)).setter(Datastore.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<Instant> LAST_MESSAGE_ARRIVAL_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastMessageArrivalTime").getter(Datastore.getter(Datastore::lastMessageArrivalTime)).setter(Datastore.setter(Builder::lastMessageArrivalTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastMessageArrivalTime").build()}).build();
    private static final SdkField<FileFormatConfiguration> FILE_FORMAT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fileFormatConfiguration").getter(Datastore.getter(Datastore::fileFormatConfiguration)).setter(Datastore.setter(Builder::fileFormatConfiguration)).constructor(FileFormatConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormatConfiguration").build()}).build();
    private static final SdkField<DatastorePartitions> DATASTORE_PARTITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("datastorePartitions").getter(Datastore.getter(Datastore::datastorePartitions)).setter(Datastore.setter(Builder::datastorePartitions)).constructor(DatastorePartitions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastorePartitions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STORAGE_FIELD, ARN_FIELD, STATUS_FIELD, RETENTION_PERIOD_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, LAST_MESSAGE_ARRIVAL_TIME_FIELD, FILE_FORMAT_CONFIGURATION_FIELD, DATASTORE_PARTITIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final DatastoreStorage storage;
    private final String arn;
    private final String status;
    private final RetentionPeriod retentionPeriod;
    private final Instant creationTime;
    private final Instant lastUpdateTime;
    private final Instant lastMessageArrivalTime;
    private final FileFormatConfiguration fileFormatConfiguration;
    private final DatastorePartitions datastorePartitions;

    private Datastore(BuilderImpl builder) {
        this.name = builder.name;
        this.storage = builder.storage;
        this.arn = builder.arn;
        this.status = builder.status;
        this.retentionPeriod = builder.retentionPeriod;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.lastMessageArrivalTime = builder.lastMessageArrivalTime;
        this.fileFormatConfiguration = builder.fileFormatConfiguration;
        this.datastorePartitions = builder.datastorePartitions;
    }

    public final String name() {
        return this.name;
    }

    public final DatastoreStorage storage() {
        return this.storage;
    }

    public final String arn() {
        return this.arn;
    }

    public final DatastoreStatus status() {
        return DatastoreStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final RetentionPeriod retentionPeriod() {
        return this.retentionPeriod;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final Instant lastMessageArrivalTime() {
        return this.lastMessageArrivalTime;
    }

    public final FileFormatConfiguration fileFormatConfiguration() {
        return this.fileFormatConfiguration;
    }

    public final DatastorePartitions datastorePartitions() {
        return this.datastorePartitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.storage());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastMessageArrivalTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFormatConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastorePartitions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Datastore)) {
            return false;
        }
        Datastore other = (Datastore)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.storage(), other.storage()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.lastMessageArrivalTime(), other.lastMessageArrivalTime()) && Objects.equals(this.fileFormatConfiguration(), other.fileFormatConfiguration()) && Objects.equals(this.datastorePartitions(), other.datastorePartitions());
    }

    public final String toString() {
        return ToString.builder((String)"Datastore").add("Name", (Object)this.name()).add("Storage", (Object)this.storage()).add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("RetentionPeriod", (Object)this.retentionPeriod()).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("LastMessageArrivalTime", (Object)this.lastMessageArrivalTime()).add("FileFormatConfiguration", (Object)this.fileFormatConfiguration()).add("DatastorePartitions", (Object)this.datastorePartitions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "storage": {
                return Optional.ofNullable(clazz.cast(this.storage()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "retentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "lastMessageArrivalTime": {
                return Optional.ofNullable(clazz.cast(this.lastMessageArrivalTime()));
            }
            case "fileFormatConfiguration": {
                return Optional.ofNullable(clazz.cast(this.fileFormatConfiguration()));
            }
            case "datastorePartitions": {
                return Optional.ofNullable(clazz.cast(this.datastorePartitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Datastore, T> g) {
        return obj -> g.apply((Datastore)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private DatastoreStorage storage;
        private String arn;
        private String status;
        private RetentionPeriod retentionPeriod;
        private Instant creationTime;
        private Instant lastUpdateTime;
        private Instant lastMessageArrivalTime;
        private FileFormatConfiguration fileFormatConfiguration;
        private DatastorePartitions datastorePartitions;

        private BuilderImpl() {
        }

        private BuilderImpl(Datastore model) {
            this.name(model.name);
            this.storage(model.storage);
            this.arn(model.arn);
            this.status(model.status);
            this.retentionPeriod(model.retentionPeriod);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.lastMessageArrivalTime(model.lastMessageArrivalTime);
            this.fileFormatConfiguration(model.fileFormatConfiguration);
            this.datastorePartitions(model.datastorePartitions);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final DatastoreStorage.Builder getStorage() {
            return this.storage != null ? this.storage.toBuilder() : null;
        }

        @Override
        public final Builder storage(DatastoreStorage storage) {
            this.storage = storage;
            return this;
        }

        public final void setStorage(DatastoreStorage.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatastoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return this.retentionPeriod != null ? this.retentionPeriod.toBuilder() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public final Instant getLastMessageArrivalTime() {
            return this.lastMessageArrivalTime;
        }

        @Override
        public final Builder lastMessageArrivalTime(Instant lastMessageArrivalTime) {
            this.lastMessageArrivalTime = lastMessageArrivalTime;
            return this;
        }

        public final void setLastMessageArrivalTime(Instant lastMessageArrivalTime) {
            this.lastMessageArrivalTime = lastMessageArrivalTime;
        }

        public final FileFormatConfiguration.Builder getFileFormatConfiguration() {
            return this.fileFormatConfiguration != null ? this.fileFormatConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder fileFormatConfiguration(FileFormatConfiguration fileFormatConfiguration) {
            this.fileFormatConfiguration = fileFormatConfiguration;
            return this;
        }

        public final void setFileFormatConfiguration(FileFormatConfiguration.BuilderImpl fileFormatConfiguration) {
            this.fileFormatConfiguration = fileFormatConfiguration != null ? fileFormatConfiguration.build() : null;
        }

        public final DatastorePartitions.Builder getDatastorePartitions() {
            return this.datastorePartitions != null ? this.datastorePartitions.toBuilder() : null;
        }

        @Override
        public final Builder datastorePartitions(DatastorePartitions datastorePartitions) {
            this.datastorePartitions = datastorePartitions;
            return this;
        }

        public final void setDatastorePartitions(DatastorePartitions.BuilderImpl datastorePartitions) {
            this.datastorePartitions = datastorePartitions != null ? datastorePartitions.build() : null;
        }

        public Datastore build() {
            return new Datastore(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Datastore> {
        public Builder name(String var1);

        public Builder storage(DatastoreStorage var1);

        default public Builder storage(Consumer<DatastoreStorage.Builder> storage) {
            return this.storage((DatastoreStorage)((DatastoreStorage.Builder)DatastoreStorage.builder().applyMutation(storage)).build());
        }

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(DatastoreStatus var1);

        public Builder retentionPeriod(RetentionPeriod var1);

        default public Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return this.retentionPeriod((RetentionPeriod)((RetentionPeriod.Builder)RetentionPeriod.builder().applyMutation(retentionPeriod)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder lastMessageArrivalTime(Instant var1);

        public Builder fileFormatConfiguration(FileFormatConfiguration var1);

        default public Builder fileFormatConfiguration(Consumer<FileFormatConfiguration.Builder> fileFormatConfiguration) {
            return this.fileFormatConfiguration((FileFormatConfiguration)((FileFormatConfiguration.Builder)FileFormatConfiguration.builder().applyMutation(fileFormatConfiguration)).build());
        }

        public Builder datastorePartitions(DatastorePartitions var1);

        default public Builder datastorePartitions(Consumer<DatastorePartitions.Builder> datastorePartitions) {
            return this.datastorePartitions((DatastorePartitions)((DatastorePartitions.Builder)DatastorePartitions.builder().applyMutation(datastorePartitions)).build());
        }
    }
}

