/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotanalytics.model.DatastorePartition;
import software.amazon.awssdk.services.iotanalytics.model.PartitionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatastorePartitions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatastorePartitions> {
    private static final SdkField<List<DatastorePartition>> PARTITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("partitions").getter(DatastorePartitions.getter(DatastorePartitions::partitions)).setter(DatastorePartitions.setter(Builder::partitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatastorePartition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<DatastorePartition> partitions;

    private DatastorePartitions(BuilderImpl builder) {
        this.partitions = builder.partitions;
    }

    public final boolean hasPartitions() {
        return this.partitions != null && !(this.partitions instanceof SdkAutoConstructList);
    }

    public final List<DatastorePartition> partitions() {
        return this.partitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitions() ? this.partitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastorePartitions)) {
            return false;
        }
        DatastorePartitions other = (DatastorePartitions)obj;
        return this.hasPartitions() == other.hasPartitions() && Objects.equals(this.partitions(), other.partitions());
    }

    public final String toString() {
        return ToString.builder((String)"DatastorePartitions").add("Partitions", this.hasPartitions() ? this.partitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "partitions": {
                return Optional.ofNullable(clazz.cast(this.partitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatastorePartitions, T> g) {
        return obj -> g.apply((DatastorePartitions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DatastorePartition> partitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DatastorePartitions model) {
            this.partitions(model.partitions);
        }

        public final List<DatastorePartition.Builder> getPartitions() {
            List<DatastorePartition.Builder> result = PartitionsCopier.copyToBuilder(this.partitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder partitions(Collection<DatastorePartition> partitions) {
            this.partitions = PartitionsCopier.copy(partitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(DatastorePartition ... partitions) {
            this.partitions(Arrays.asList(partitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(Consumer<DatastorePartition.Builder> ... partitions) {
            this.partitions(Stream.of(partitions).map(c -> (DatastorePartition)((DatastorePartition.Builder)DatastorePartition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPartitions(Collection<DatastorePartition.BuilderImpl> partitions) {
            this.partitions = PartitionsCopier.copyFromBuilder(partitions);
        }

        public DatastorePartitions build() {
            return new DatastorePartitions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatastorePartitions> {
        public Builder partitions(Collection<DatastorePartition> var1);

        public Builder partitions(DatastorePartition ... var1);

        public Builder partitions(Consumer<DatastorePartition.Builder> ... var1);
    }
}

