/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimestampPartition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimestampPartition> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attributeName").getter(TimestampPartition.getter(TimestampPartition::attributeName)).setter(TimestampPartition.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeName").build()}).build();
    private static final SdkField<String> TIMESTAMP_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timestampFormat").getter(TimestampPartition.getter(TimestampPartition::timestampFormat)).setter(TimestampPartition.setter(Builder::timestampFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestampFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD, TIMESTAMP_FORMAT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String attributeName;
    private final String timestampFormat;

    private TimestampPartition(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.timestampFormat = builder.timestampFormat;
    }

    public final String attributeName() {
        return this.attributeName;
    }

    public final String timestampFormat() {
        return this.timestampFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampFormat());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestampPartition)) {
            return false;
        }
        TimestampPartition other = (TimestampPartition)obj;
        return Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.timestampFormat(), other.timestampFormat());
    }

    public final String toString() {
        return ToString.builder((String)"TimestampPartition").add("AttributeName", (Object)this.attributeName()).add("TimestampFormat", (Object)this.timestampFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "timestampFormat": {
                return Optional.ofNullable(clazz.cast(this.timestampFormat()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimestampPartition, T> g) {
        return obj -> g.apply((TimestampPartition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private String timestampFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(TimestampPartition model) {
            this.attributeName(model.attributeName);
            this.timestampFormat(model.timestampFormat);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getTimestampFormat() {
            return this.timestampFormat;
        }

        @Override
        public final Builder timestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
            return this;
        }

        public final void setTimestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
        }

        public TimestampPartition build() {
            return new TimestampPartition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimestampPartition> {
        public Builder attributeName(String var1);

        public Builder timestampFormat(String var1);
    }
}

