/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotanalytics.IoTAnalyticsClient;
import software.amazon.awssdk.services.iotanalytics.model.ListDatastoresRequest;
import software.amazon.awssdk.services.iotanalytics.model.ListDatastoresResponse;

public class ListDatastoresIterable
implements SdkIterable<ListDatastoresResponse> {
    private final IoTAnalyticsClient client;
    private final ListDatastoresRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDatastoresIterable(IoTAnalyticsClient client, ListDatastoresRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDatastoresResponseFetcher();
    }

    public Iterator<ListDatastoresResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDatastoresResponseFetcher
    implements SyncPageFetcher<ListDatastoresResponse> {
        private ListDatastoresResponseFetcher() {
        }

        public boolean hasNextPage(ListDatastoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDatastoresResponse nextPage(ListDatastoresResponse previousPage) {
            if (previousPage == null) {
                return ListDatastoresIterable.this.client.listDatastores(ListDatastoresIterable.this.firstRequest);
            }
            return ListDatastoresIterable.this.client.listDatastores((ListDatastoresRequest)((Object)ListDatastoresIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

