/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotjobsdataplane.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPendingJobExecutionsResponse extends IotJobsDataPlaneResponse implements
        ToCopyableBuilder<GetPendingJobExecutionsResponse.Builder, GetPendingJobExecutionsResponse> {
    private static final SdkField<List<JobExecutionSummary>> IN_PROGRESS_JOBS_FIELD = SdkField
            .<List<JobExecutionSummary>> builder(MarshallingType.LIST)
            .getter(getter(GetPendingJobExecutionsResponse::inProgressJobs))
            .setter(setter(Builder::inProgressJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inProgressJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobExecutionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobExecutionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<JobExecutionSummary>> QUEUED_JOBS_FIELD = SdkField
            .<List<JobExecutionSummary>> builder(MarshallingType.LIST)
            .getter(getter(GetPendingJobExecutionsResponse::queuedJobs))
            .setter(setter(Builder::queuedJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobExecutionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobExecutionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IN_PROGRESS_JOBS_FIELD,
            QUEUED_JOBS_FIELD));

    private final List<JobExecutionSummary> inProgressJobs;

    private final List<JobExecutionSummary> queuedJobs;

    private GetPendingJobExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.inProgressJobs = builder.inProgressJobs;
        this.queuedJobs = builder.queuedJobs;
    }

    /**
     * Returns true if the InProgressJobs property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInProgressJobs() {
        return inProgressJobs != null && !(inProgressJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of JobExecutionSummary objects with status IN_PROGRESS.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInProgressJobs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of JobExecutionSummary objects with status IN_PROGRESS.
     */
    public List<JobExecutionSummary> inProgressJobs() {
        return inProgressJobs;
    }

    /**
     * Returns true if the QueuedJobs property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasQueuedJobs() {
        return queuedJobs != null && !(queuedJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of JobExecutionSummary objects with status QUEUED.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQueuedJobs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of JobExecutionSummary objects with status QUEUED.
     */
    public List<JobExecutionSummary> queuedJobs() {
        return queuedJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inProgressJobs());
        hashCode = 31 * hashCode + Objects.hashCode(queuedJobs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPendingJobExecutionsResponse)) {
            return false;
        }
        GetPendingJobExecutionsResponse other = (GetPendingJobExecutionsResponse) obj;
        return Objects.equals(inProgressJobs(), other.inProgressJobs()) && Objects.equals(queuedJobs(), other.queuedJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetPendingJobExecutionsResponse").add("InProgressJobs", inProgressJobs())
                .add("QueuedJobs", queuedJobs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inProgressJobs":
            return Optional.ofNullable(clazz.cast(inProgressJobs()));
        case "queuedJobs":
            return Optional.ofNullable(clazz.cast(queuedJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPendingJobExecutionsResponse, T> g) {
        return obj -> g.apply((GetPendingJobExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotJobsDataPlaneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPendingJobExecutionsResponse> {
        /**
         * <p>
         * A list of JobExecutionSummary objects with status IN_PROGRESS.
         * </p>
         * 
         * @param inProgressJobs
         *        A list of JobExecutionSummary objects with status IN_PROGRESS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inProgressJobs(Collection<JobExecutionSummary> inProgressJobs);

        /**
         * <p>
         * A list of JobExecutionSummary objects with status IN_PROGRESS.
         * </p>
         * 
         * @param inProgressJobs
         *        A list of JobExecutionSummary objects with status IN_PROGRESS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inProgressJobs(JobExecutionSummary... inProgressJobs);

        /**
         * <p>
         * A list of JobExecutionSummary objects with status IN_PROGRESS.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobExecutionSummary>.Builder} avoiding the
         * need to create one manually via {@link List<JobExecutionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobExecutionSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #inProgressJobs(List<JobExecutionSummary>)}.
         * 
         * @param inProgressJobs
         *        a consumer that will call methods on {@link List<JobExecutionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inProgressJobs(List<JobExecutionSummary>)
         */
        Builder inProgressJobs(Consumer<JobExecutionSummary.Builder>... inProgressJobs);

        /**
         * <p>
         * A list of JobExecutionSummary objects with status QUEUED.
         * </p>
         * 
         * @param queuedJobs
         *        A list of JobExecutionSummary objects with status QUEUED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queuedJobs(Collection<JobExecutionSummary> queuedJobs);

        /**
         * <p>
         * A list of JobExecutionSummary objects with status QUEUED.
         * </p>
         * 
         * @param queuedJobs
         *        A list of JobExecutionSummary objects with status QUEUED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queuedJobs(JobExecutionSummary... queuedJobs);

        /**
         * <p>
         * A list of JobExecutionSummary objects with status QUEUED.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobExecutionSummary>.Builder} avoiding the
         * need to create one manually via {@link List<JobExecutionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobExecutionSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #queuedJobs(List<JobExecutionSummary>)}.
         * 
         * @param queuedJobs
         *        a consumer that will call methods on {@link List<JobExecutionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queuedJobs(List<JobExecutionSummary>)
         */
        Builder queuedJobs(Consumer<JobExecutionSummary.Builder>... queuedJobs);
    }

    static final class BuilderImpl extends IotJobsDataPlaneResponse.BuilderImpl implements Builder {
        private List<JobExecutionSummary> inProgressJobs = DefaultSdkAutoConstructList.getInstance();

        private List<JobExecutionSummary> queuedJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPendingJobExecutionsResponse model) {
            super(model);
            inProgressJobs(model.inProgressJobs);
            queuedJobs(model.queuedJobs);
        }

        public final Collection<JobExecutionSummary.Builder> getInProgressJobs() {
            return inProgressJobs != null ? inProgressJobs.stream().map(JobExecutionSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inProgressJobs(Collection<JobExecutionSummary> inProgressJobs) {
            this.inProgressJobs = JobExecutionSummaryListCopier.copy(inProgressJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inProgressJobs(JobExecutionSummary... inProgressJobs) {
            inProgressJobs(Arrays.asList(inProgressJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inProgressJobs(Consumer<JobExecutionSummary.Builder>... inProgressJobs) {
            inProgressJobs(Stream.of(inProgressJobs).map(c -> JobExecutionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInProgressJobs(Collection<JobExecutionSummary.BuilderImpl> inProgressJobs) {
            this.inProgressJobs = JobExecutionSummaryListCopier.copyFromBuilder(inProgressJobs);
        }

        public final Collection<JobExecutionSummary.Builder> getQueuedJobs() {
            return queuedJobs != null ? queuedJobs.stream().map(JobExecutionSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder queuedJobs(Collection<JobExecutionSummary> queuedJobs) {
            this.queuedJobs = JobExecutionSummaryListCopier.copy(queuedJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queuedJobs(JobExecutionSummary... queuedJobs) {
            queuedJobs(Arrays.asList(queuedJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queuedJobs(Consumer<JobExecutionSummary.Builder>... queuedJobs) {
            queuedJobs(Stream.of(queuedJobs).map(c -> JobExecutionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setQueuedJobs(Collection<JobExecutionSummary.BuilderImpl> queuedJobs) {
            this.queuedJobs = JobExecutionSummaryListCopier.copyFromBuilder(queuedJobs);
        }

        @Override
        public GetPendingJobExecutionsResponse build() {
            return new GetPendingJobExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
