/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotjobsdataplane.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateJobExecutionRequest extends IotJobsDataPlaneRequest implements
        ToCopyableBuilder<UpdateJobExecutionRequest.Builder, UpdateJobExecutionRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJobExecutionRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJobExecutionRequest::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJobExecutionRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> STATUS_DETAILS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(UpdateJobExecutionRequest::statusDetails))
            .setter(setter(Builder::statusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> STEP_TIMEOUT_IN_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(UpdateJobExecutionRequest::stepTimeoutInMinutes)).setter(setter(Builder::stepTimeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepTimeoutInMinutes").build())
            .build();

    private static final SdkField<Long> EXPECTED_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(UpdateJobExecutionRequest::expectedVersion)).setter(setter(Builder::expectedVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedVersion").build()).build();

    private static final SdkField<Boolean> INCLUDE_JOB_EXECUTION_STATE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(UpdateJobExecutionRequest::includeJobExecutionState))
            .setter(setter(Builder::includeJobExecutionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeJobExecutionState").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_JOB_DOCUMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateJobExecutionRequest::includeJobDocument)).setter(setter(Builder::includeJobDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeJobDocument").build())
            .build();

    private static final SdkField<Long> EXECUTION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(UpdateJobExecutionRequest::executionNumber)).setter(setter(Builder::executionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            THING_NAME_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, STEP_TIMEOUT_IN_MINUTES_FIELD, EXPECTED_VERSION_FIELD,
            INCLUDE_JOB_EXECUTION_STATE_FIELD, INCLUDE_JOB_DOCUMENT_FIELD, EXECUTION_NUMBER_FIELD));

    private final String jobId;

    private final String thingName;

    private final String status;

    private final Map<String, String> statusDetails;

    private final Long stepTimeoutInMinutes;

    private final Long expectedVersion;

    private final Boolean includeJobExecutionState;

    private final Boolean includeJobDocument;

    private final Long executionNumber;

    private UpdateJobExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.thingName = builder.thingName;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.stepTimeoutInMinutes = builder.stepTimeoutInMinutes;
        this.expectedVersion = builder.expectedVersion;
        this.includeJobExecutionState = builder.includeJobExecutionState;
        this.includeJobDocument = builder.includeJobDocument;
        this.executionNumber = builder.executionNumber;
    }

    /**
     * <p>
     * The unique identifier assigned to this job when it was created.
     * </p>
     * 
     * @return The unique identifier assigned to this job when it was created.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The name of the thing associated with the device.
     * </p>
     * 
     * @return The name of the thing associated with the device.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The new status for the job execution (IN_PROGRESS, FAILED, SUCCESS, or REJECTED). This must be specified on every
     * update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The new status for the job execution (IN_PROGRESS, FAILED, SUCCESS, or REJECTED). This must be specified
     *         on every update.
     * @see JobExecutionStatus
     */
    public JobExecutionStatus status() {
        return JobExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The new status for the job execution (IN_PROGRESS, FAILED, SUCCESS, or REJECTED). This must be specified on every
     * update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The new status for the job execution (IN_PROGRESS, FAILED, SUCCESS, or REJECTED). This must be specified
     *         on every update.
     * @see JobExecutionStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * Returns true if the StatusDetails property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStatusDetails() {
        return statusDetails != null && !(statusDetails instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Optional. A collection of name/value pairs that describe the status of the job execution. If not specified, the
     * statusDetails are unchanged.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatusDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Optional. A collection of name/value pairs that describe the status of the job execution. If not
     *         specified, the statusDetails are unchanged.
     */
    public Map<String, String> statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * Specifies the amount of time this device has to finish execution of this job. If the job execution status is not
     * set to a terminal state before this timer expires, or before the timer is reset (by again calling
     * <code>UpdateJobExecution</code>, setting the status to <code>IN_PROGRESS</code> and specifying a new timeout
     * value in this field) the job execution status will be automatically set to <code>TIMED_OUT</code>. Note that
     * setting or resetting this timeout has no effect on that job execution timeout which may have been specified when
     * the job was created (<code>CreateJob</code> using field <code>timeoutConfig</code>).
     * </p>
     * 
     * @return Specifies the amount of time this device has to finish execution of this job. If the job execution status
     *         is not set to a terminal state before this timer expires, or before the timer is reset (by again calling
     *         <code>UpdateJobExecution</code>, setting the status to <code>IN_PROGRESS</code> and specifying a new
     *         timeout value in this field) the job execution status will be automatically set to <code>TIMED_OUT</code>
     *         . Note that setting or resetting this timeout has no effect on that job execution timeout which may have
     *         been specified when the job was created (<code>CreateJob</code> using field <code>timeoutConfig</code>).
     */
    public Long stepTimeoutInMinutes() {
        return stepTimeoutInMinutes;
    }

    /**
     * <p>
     * Optional. The expected current version of the job execution. Each time you update the job execution, its version
     * is incremented. If the version of the job execution stored in Jobs does not match, the update is rejected with a
     * VersionMismatch error, and an ErrorResponse that contains the current job execution status data is returned.
     * (This makes it unnecessary to perform a separate DescribeJobExecution request in order to obtain the job
     * execution status data.)
     * </p>
     * 
     * @return Optional. The expected current version of the job execution. Each time you update the job execution, its
     *         version is incremented. If the version of the job execution stored in Jobs does not match, the update is
     *         rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution
     *         status data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in
     *         order to obtain the job execution status data.)
     */
    public Long expectedVersion() {
        return expectedVersion;
    }

    /**
     * <p>
     * Optional. When included and set to true, the response contains the JobExecutionState data. The default is false.
     * </p>
     * 
     * @return Optional. When included and set to true, the response contains the JobExecutionState data. The default is
     *         false.
     */
    public Boolean includeJobExecutionState() {
        return includeJobExecutionState;
    }

    /**
     * <p>
     * Optional. When set to true, the response contains the job document. The default is false.
     * </p>
     * 
     * @return Optional. When set to true, the response contains the job document. The default is false.
     */
    public Boolean includeJobDocument() {
        return includeJobDocument;
    }

    /**
     * <p>
     * Optional. A number that identifies a particular job execution on a particular device.
     * </p>
     * 
     * @return Optional. A number that identifies a particular job execution on a particular device.
     */
    public Long executionNumber() {
        return executionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(stepTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(expectedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(includeJobExecutionState());
        hashCode = 31 * hashCode + Objects.hashCode(includeJobDocument());
        hashCode = 31 * hashCode + Objects.hashCode(executionNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobExecutionRequest)) {
            return false;
        }
        UpdateJobExecutionRequest other = (UpdateJobExecutionRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(thingName(), other.thingName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusDetails(), other.statusDetails())
                && Objects.equals(stepTimeoutInMinutes(), other.stepTimeoutInMinutes())
                && Objects.equals(expectedVersion(), other.expectedVersion())
                && Objects.equals(includeJobExecutionState(), other.includeJobExecutionState())
                && Objects.equals(includeJobDocument(), other.includeJobDocument())
                && Objects.equals(executionNumber(), other.executionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateJobExecutionRequest").add("JobId", jobId()).add("ThingName", thingName())
                .add("Status", statusAsString()).add("StatusDetails", statusDetails())
                .add("StepTimeoutInMinutes", stepTimeoutInMinutes()).add("ExpectedVersion", expectedVersion())
                .add("IncludeJobExecutionState", includeJobExecutionState()).add("IncludeJobDocument", includeJobDocument())
                .add("ExecutionNumber", executionNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "stepTimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(stepTimeoutInMinutes()));
        case "expectedVersion":
            return Optional.ofNullable(clazz.cast(expectedVersion()));
        case "includeJobExecutionState":
            return Optional.ofNullable(clazz.cast(includeJobExecutionState()));
        case "includeJobDocument":
            return Optional.ofNullable(clazz.cast(includeJobDocument()));
        case "executionNumber":
            return Optional.ofNullable(clazz.cast(executionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobExecutionRequest, T> g) {
        return obj -> g.apply((UpdateJobExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotJobsDataPlaneRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateJobExecutionRequest> {
        /**
         * <p>
         * The unique identifier assigned to this job when it was created.
         * </p>
         * 
         * @param jobId
         *        The unique identifier assigned to this job when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The name of the thing associated with the device.
         * </p>
         * 
         * @param thingName
         *        The name of the thing associated with the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The new status for the job execution (IN_PROGRESS, FAILED, SUCCESS, or REJECTED). This must be specified on
         * every update.
         * </p>
         * 
         * @param status
         *        The new status for the job execution (IN_PROGRESS, FAILED, SUCCESS, or REJECTED). This must be
         *        specified on every update.
         * @see JobExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The new status for the job execution (IN_PROGRESS, FAILED, SUCCESS, or REJECTED). This must be specified on
         * every update.
         * </p>
         * 
         * @param status
         *        The new status for the job execution (IN_PROGRESS, FAILED, SUCCESS, or REJECTED). This must be
         *        specified on every update.
         * @see JobExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobExecutionStatus
         */
        Builder status(JobExecutionStatus status);

        /**
         * <p>
         * Optional. A collection of name/value pairs that describe the status of the job execution. If not specified,
         * the statusDetails are unchanged.
         * </p>
         * 
         * @param statusDetails
         *        Optional. A collection of name/value pairs that describe the status of the job execution. If not
         *        specified, the statusDetails are unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(Map<String, String> statusDetails);

        /**
         * <p>
         * Specifies the amount of time this device has to finish execution of this job. If the job execution status is
         * not set to a terminal state before this timer expires, or before the timer is reset (by again calling
         * <code>UpdateJobExecution</code>, setting the status to <code>IN_PROGRESS</code> and specifying a new timeout
         * value in this field) the job execution status will be automatically set to <code>TIMED_OUT</code>. Note that
         * setting or resetting this timeout has no effect on that job execution timeout which may have been specified
         * when the job was created (<code>CreateJob</code> using field <code>timeoutConfig</code>).
         * </p>
         * 
         * @param stepTimeoutInMinutes
         *        Specifies the amount of time this device has to finish execution of this job. If the job execution
         *        status is not set to a terminal state before this timer expires, or before the timer is reset (by
         *        again calling <code>UpdateJobExecution</code>, setting the status to <code>IN_PROGRESS</code> and
         *        specifying a new timeout value in this field) the job execution status will be automatically set to
         *        <code>TIMED_OUT</code>. Note that setting or resetting this timeout has no effect on that job
         *        execution timeout which may have been specified when the job was created (<code>CreateJob</code> using
         *        field <code>timeoutConfig</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepTimeoutInMinutes(Long stepTimeoutInMinutes);

        /**
         * <p>
         * Optional. The expected current version of the job execution. Each time you update the job execution, its
         * version is incremented. If the version of the job execution stored in Jobs does not match, the update is
         * rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution status
         * data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in order to
         * obtain the job execution status data.)
         * </p>
         * 
         * @param expectedVersion
         *        Optional. The expected current version of the job execution. Each time you update the job execution,
         *        its version is incremented. If the version of the job execution stored in Jobs does not match, the
         *        update is rejected with a VersionMismatch error, and an ErrorResponse that contains the current job
         *        execution status data is returned. (This makes it unnecessary to perform a separate
         *        DescribeJobExecution request in order to obtain the job execution status data.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedVersion(Long expectedVersion);

        /**
         * <p>
         * Optional. When included and set to true, the response contains the JobExecutionState data. The default is
         * false.
         * </p>
         * 
         * @param includeJobExecutionState
         *        Optional. When included and set to true, the response contains the JobExecutionState data. The default
         *        is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeJobExecutionState(Boolean includeJobExecutionState);

        /**
         * <p>
         * Optional. When set to true, the response contains the job document. The default is false.
         * </p>
         * 
         * @param includeJobDocument
         *        Optional. When set to true, the response contains the job document. The default is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeJobDocument(Boolean includeJobDocument);

        /**
         * <p>
         * Optional. A number that identifies a particular job execution on a particular device.
         * </p>
         * 
         * @param executionNumber
         *        Optional. A number that identifies a particular job execution on a particular device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionNumber(Long executionNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotJobsDataPlaneRequest.BuilderImpl implements Builder {
        private String jobId;

        private String thingName;

        private String status;

        private Map<String, String> statusDetails = DefaultSdkAutoConstructMap.getInstance();

        private Long stepTimeoutInMinutes;

        private Long expectedVersion;

        private Boolean includeJobExecutionState;

        private Boolean includeJobDocument;

        private Long executionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobExecutionRequest model) {
            super(model);
            jobId(model.jobId);
            thingName(model.thingName);
            status(model.status);
            statusDetails(model.statusDetails);
            stepTimeoutInMinutes(model.stepTimeoutInMinutes);
            expectedVersion(model.expectedVersion);
            includeJobExecutionState(model.includeJobExecutionState);
            includeJobDocument(model.includeJobDocument);
            executionNumber(model.executionNumber);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Map<String, String> getStatusDetails() {
            return statusDetails;
        }

        @Override
        public final Builder statusDetails(Map<String, String> statusDetails) {
            this.statusDetails = DetailsMapCopier.copy(statusDetails);
            return this;
        }

        public final void setStatusDetails(Map<String, String> statusDetails) {
            this.statusDetails = DetailsMapCopier.copy(statusDetails);
        }

        public final Long getStepTimeoutInMinutes() {
            return stepTimeoutInMinutes;
        }

        @Override
        public final Builder stepTimeoutInMinutes(Long stepTimeoutInMinutes) {
            this.stepTimeoutInMinutes = stepTimeoutInMinutes;
            return this;
        }

        public final void setStepTimeoutInMinutes(Long stepTimeoutInMinutes) {
            this.stepTimeoutInMinutes = stepTimeoutInMinutes;
        }

        public final Long getExpectedVersion() {
            return expectedVersion;
        }

        @Override
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        public final Boolean getIncludeJobExecutionState() {
            return includeJobExecutionState;
        }

        @Override
        public final Builder includeJobExecutionState(Boolean includeJobExecutionState) {
            this.includeJobExecutionState = includeJobExecutionState;
            return this;
        }

        public final void setIncludeJobExecutionState(Boolean includeJobExecutionState) {
            this.includeJobExecutionState = includeJobExecutionState;
        }

        public final Boolean getIncludeJobDocument() {
            return includeJobDocument;
        }

        @Override
        public final Builder includeJobDocument(Boolean includeJobDocument) {
            this.includeJobDocument = includeJobDocument;
            return this;
        }

        public final void setIncludeJobDocument(Boolean includeJobDocument) {
            this.includeJobDocument = includeJobDocument;
        }

        public final Long getExecutionNumber() {
            return executionNumber;
        }

        @Override
        public final Builder executionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
            return this;
        }

        public final void setExecutionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateJobExecutionRequest build() {
            return new UpdateJobExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
